/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.gui.TableSettings;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class TransferDialogData {
    static final int DEFAULT_NUMBER_OF_RECORDS = 100;
    static final boolean DEFAULT_IS_HALT_AT_ERROR = true;
    static final boolean DEFAULT_SET_CHIRAL_FLAG = false;
    static final boolean DEFAULT_ALLOW_EMPTY = true;
    public Vector tables;
    public String selectedTable = null;
    public String fileName = null;
    public int numberOfRecords = 100;
    public boolean isHaltAtError = true;
    public boolean setChiralFlag = false;
    public boolean allowEmptyStructures = true;
    public boolean isDrop = false;
    public String deleteWhereString = "";
    public boolean regenerateAll = false;
    public Map<Integer, Boolean> regenerationOptions;
    public TableSettings tableSettings = null;
    public TableSettings oldTableSettings = null;
    private int type;

    public TransferDialogData(int type) {
        this.type = type;
        this.tables = new Vector();
    }

    static String typeToString(int type) {
        String transfer = null;
        switch (type) {
            case 0: {
                transfer = "import";
                break;
            }
            case 1: {
                transfer = "export";
                break;
            }
            case 2: {
                transfer = "delete";
                break;
            }
            case 3: {
                transfer = "regenerate";
                break;
            }
            case 4: {
                transfer = "table_options";
            }
        }
        return transfer;
    }

    public static TransferDialogData getFromSettings(Properties settings, int type) {
        String transfer = TransferDialogData.typeToString(type);
        TransferDialogData tdd = new TransferDialogData(type);
        tdd.selectedTable = settings.getProperty(transfer + ".selectedTable");
        if (type == 0 || type == 1) {
            tdd.fileName = settings.getProperty(transfer + ".fileName");
        }
        if (type == 0) {
            String s = settings.getProperty(transfer + ".numberOfRecords");
            tdd.numberOfRecords = s == null ? 100 : Integer.valueOf(s);
            s = settings.getProperty(transfer + ".isHaltAtError");
            tdd.isHaltAtError = s == null ? true : Boolean.valueOf(s);
            s = settings.getProperty(transfer + ".setChiralFlag");
            tdd.setChiralFlag = s == null ? false : Boolean.valueOf(s);
            s = settings.getProperty(transfer + ".areEmptyStructuresAllowed");
            tdd.allowEmptyStructures = s == null ? true : Boolean.valueOf(s);
        }
        return tdd;
    }

    public void save(Properties settings) {
        String transfer = TransferDialogData.typeToString(this.type);
        if (this.selectedTable != null) {
            settings.put(transfer + ".selectedTable", this.selectedTable);
        }
        if (this.type == 0 || this.type == 1) {
            settings.put(transfer + ".fileName", this.fileName);
        }
        if (this.type == 0) {
            if (this.numberOfRecords == 0) {
                settings.remove(transfer + ".numberOfRecords");
            } else {
                settings.put(transfer + ".numberOfRecords", new Integer(this.numberOfRecords).toString());
            }
            settings.put(transfer + ".isHaltAtError", new Boolean(this.isHaltAtError).toString());
            settings.put(transfer + ".setChiralFlag", new Boolean(this.setChiralFlag).toString());
            settings.put(transfer + ".areEmptyStructuresAllowed", new Boolean(this.allowEmptyStructures).toString());
        }
    }
}

