/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.calculations.ElementalAnalyser;
import chemaxon.common.util.ArrayTools;
import chemaxon.descriptors.MDDBWriter;
import chemaxon.descriptors.MDWriterException;
import chemaxon.enumeration.SearchEnumerator;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.enumeration.supergraph.MarkushAromata;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.formats.MdlCompressor;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.db.CTColumnRegenerator;
import chemaxon.jchem.db.CacheRegistrationUtil;
import chemaxon.jchem.db.ChemicalTermsUpdateHandlerException;
import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.JChemCache;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.MDRegenerator;
import chemaxon.jchem.db.MDTableHandler;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.RegenerationChecker;
import chemaxon.jchem.db.Regenerator;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TableTypeConstants;
import chemaxon.jchem.db.UpdateHandlerException;
import chemaxon.jchem.db.UpdateHandlerOracle;
import chemaxon.jchem.db.UpdateLogCache;
import chemaxon.jchem.db.cdmarkush.CDMarkushHandler;
import chemaxon.jchem.db.cdmarkush.CDMarkushToDB;
import chemaxon.jchem.db.cdmarkush.CDMarkushUtil;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.file.MolRecord;
import chemaxon.jchem.file.ProgressWriter;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.context.MolContext;
import chemaxon.marvin.io.formats.smiles.CxsmilesExport;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.screen.CombinedFingerprint;
import chemaxon.sss.screen.HashCode;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.TautomerUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.ErrorHandler;
import chemaxon.util.MolHandler;
import chemaxon.util.cache.ChemJepCacheMolContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateHandler
extends ErrorHandler
implements TableTypeConstants {
    private static final Logger logger = Logger.getLogger(UpdateHandler.class.getName());
    public static final int UPDATE = 0;
    public static final int INSERT = 1;
    public static final int INSERT_WITH_ID = 2;
    public static final int DUPLICATE_FILTERING_ON = 1;
    public static final int DUPLICATE_FILTERING_OFF = 2;
    public static final int DUPLICATE_FILTERING_TABLE_OPTION = 0;
    public static final int QUERY_TABLE_ENUMERATION_LIMIT = 500;
    private int numberOfFPCols;
    int mode;
    String additionalColumnsString = null;
    CombinedFingerprint cfp = null;
    DatabaseOptions dbOptions;
    ConnectionHandler conh;
    Connection con;
    String tableName;
    Molecule mol = null;
    byte[] structure;
    String smiles;
    String formula;
    String sortableFormula;
    Double molWeight;
    int[] fingerprint;
    int hash;
    String flags;
    String molName = "";
    Molecule genericTautomer;
    boolean isMarkush = false;
    boolean noRingInfoInFP = false;
    boolean reactionMappingIncomplete = false;
    byte[] markushData = null;
    Supergraph superGraph = null;
    HashCode hc = new HashCode();
    ArrayList additionalColumns = new ArrayList();
    PreparedStatement pstmt = null;
    private int counter = 0;
    int max = 0;
    boolean alwaysCreateNew = false;
    long totalMemoryAt1000 = 0L;
    boolean spoiledMax = false;
    private int lastId = 0;
    private String timeStamp = null;
    private boolean regenerateMode = false;
    private String inputFormat = null;
    private RowData rowData = null;
    private ArrayList bigLOBs;
    private ActiveFieldList activeFieldList;
    private ActiveFieldList lastActiveFieldList;
    private int tableType = 0;
    private boolean tautomerDuplicateSearch = false;
    private boolean switchOffAllProtectionsForTDF = false;
    private boolean genericTautomerProtectsChirality = false;
    static final char FLAG_MARKUSH = 'm';
    static final char FLAG_NO_RING_INFO_IN_FP = 'r';
    static final char FLAG_CHIRAL = 'c';
    static final char FLAG_REACTION_MAPPING_INCOMPLETE = 'i';
    private ElementalAnalyser elemanal = null;
    private static final int SORTABLE_FORMULA_MIN_DIGITS = 5;
    private boolean cartridgeMode;
    private String indexedTable;
    private String indexedColumn;
    private boolean firstExecuteCall = true;
    private boolean inputMoleculeSet = false;
    private boolean structureSourceSet = false;
    private String tempTableToWrite = null;
    Field[] fields = null;
    int dbms = 0;
    boolean emptyStructuresAllowed = false;
    String[] descriptorNames = null;
    int cd_id = 0;
    String rowID = null;
    int smilesLength = 254;
    Standardizer standardizer = null;
    private PreparedStatement lastIdPrepStmt = null;
    private PreparedStatement storeUpdateLogPrepStmt = null;
    private JChemSearch jcsearch = null;
    private boolean duplicateFiltering = false;
    private boolean isDuplicateFilteringTO = true;
    private boolean setChiralFlag = false;
    private boolean doNotImport = false;
    private boolean standardize = true;
    private boolean ignoreCTErrors = false;
    private boolean loggingEnabled = true;
    private Molecule inputMol = null;
    private Map<String, String> chemTermColCfg;
    private Map<String, Object> chemTermColValues;
    private final MolContext molContext = new MolContext();
    private boolean chemTermCalcNeeded = true;
    private String molNameField = "";
    private boolean singleInsertLog = false;
    private DatabaseProperties storedUpdateLogDbProp = null;
    private ArrayList registeredCaches = new ArrayList();
    private String cacheTimestamp = null;
    private final UpdateLogCache updateLogCache = new UpdateLogCache();
    private StringBuffer bufferedLogString = new StringBuffer("");
    private int bufferedIdsNo = 0;
    static final int IDS_NO_TO_BUFFER = 10;
    static final String ID_SEPARATOR = ";";
    CDMarkushHandler defaultMarkushHandler = null;
    private int lastPstmtMode = 0;

    public UpdateHandler() {
    }

    public UpdateHandler(ConnectionHandler conh, int mode, String tableName, String additionalColumns) throws SQLException, PropertyNotSetException {
        this.mode = mode;
        this.conh = conh;
        this.con = conh.getConnection();
        this.tableName = tableName;
        this.additionalColumnsString = additionalColumns;
        this.initFields();
    }

    public UpdateHandler(ConnectionHandler conh, int mode, String tableName, String additionalColumns, String indexedTable, String indexedColumn) throws SQLException, PropertyNotSetException {
        this(conh, mode, tableName, additionalColumns, false, indexedTable, indexedColumn);
    }

    UpdateHandler(ConnectionHandler conh, int mode, String tableName, String additionalColumns, boolean regenerateMode, String indexedTable, String indexedColumn) throws SQLException, PropertyNotSetException {
        this.mode = mode;
        this.conh = conh;
        this.con = conh.getConnection();
        this.tableName = tableName;
        this.additionalColumnsString = additionalColumns;
        this.regenerateMode = regenerateMode;
        this.indexedTable = indexedTable;
        this.indexedColumn = indexedColumn;
        this.checkCartridgeMode(indexedTable, indexedColumn);
        this.initFields();
    }

    private void checkCartridgeMode(String indexedTable, String indexedColumn) {
        if (indexedTable != null && indexedColumn == null || indexedTable == null && indexedColumn != null) {
            throw new IllegalArgumentException("indexedTable=" + indexedTable + ", indexedColumn=" + indexedColumn + ". Both indexedTable and indexedColumn " + "must either be null or not null.");
        }
        this.cartridgeMode = indexedTable != null;
    }

    public void init(ConnectionHandler conHandler, int mode, String tableName, String additionalColumns) throws SQLException, PropertyNotSetException {
        this.mode = mode;
        this.conh = conHandler;
        this.con = conHandler.getConnection();
        this.tableName = tableName;
        this.additionalColumnsString = additionalColumns;
        this.initFields();
    }

    public static int getPreferredTableType(Molecule m) {
        boolean isReaction = m.isReaction();
        boolean isMarkush = Supergraph.isMarkushMolecule(m);
        boolean canBeSupergraph = Supergraph.canSupergraphCreated(m);
        boolean isQuery = m.isQuery();
        int type = isReaction ? (isQuery || isMarkush ? 2 : 1) : (isMarkush && canBeSupergraph ? 3 : (isQuery ? 4 : 0));
        return type;
    }

    public static boolean isInsertable(Molecule m, int tableType, boolean isEmptyStructuresAllowed) {
        String error = UpdateHandler.testIfInsertable(m, tableType, null, isEmptyStructuresAllowed);
        return error == null;
    }

    void initFields() throws SQLException, PropertyNotSetException {
        this.tableName = TableInfo.getTableNameWithSchema(this.con, this.tableName);
        if (this.additionalColumnsString == null) {
            this.additionalColumnsString = "";
        }
        this.dbms = DatabaseOptions.getDBMSType(this.con);
        this.singleInsertLog = (this.mode == 1 || this.mode == 2) && this.dbms == 1;
        this.timeStamp = DatabaseOptions.getTimestamp(this.dbms);
        DatabaseProperties dbProp = new DatabaseProperties(this.conh, this.cartridgeMode);
        this.tableType = dbProp.getTableType(this.tableName);
        this.tautomerDuplicateSearch = dbProp.isTautomerDuplicateFilteringEnabled(this.tableName);
        if (this.tautomerDuplicateSearch) {
            this.genericTautomerProtectsChirality = dbProp.isGenericTautomerProtectsChirality(this.tableName);
            this.switchOffAllProtectionsForTDF = dbProp.isSetSwitchOffAllProtectionsForTDF(this.tableName);
        } else {
            this.genericTautomerProtectsChirality = false;
        }
        if (this.tableType != 4) {
            this.smilesLength = UpdateHandler.getSmilesSize(this.con, this.tableName);
        }
        if (this.isDuplicateFilteringTO) {
            this.duplicateFiltering = dbProp.isDuplicateFilteringOption(this.tableName);
        }
        this.dbOptions = DatabaseOptions.getFromDatabase(this.conh);
        try {
            this.standardizer = this.getStandardizer();
        }
        catch (UpdateHandlerException e) {
            logger.throwing("UpdateHandler", "initFields", e);
            throw new SQLException(e);
        }
        int numberOfStrucFPCols = FingerprintHandler.getNumberOfStructuralFPColumns(this.conh, this.tableName, this.cartridgeMode);
        int numberOfCFPCols = FingerprintHandler.getNumberOfCombinedFPColumns(this.conh, this.tableName, this.cartridgeMode);
        this.numberOfFPCols = numberOfCFPCols + numberOfStrucFPCols;
        try {
            this.cfp = FingerprintHandler.getCombinedFingerprint(this.conh, this.tableName, this.cartridgeMode, numberOfStrucFPCols, numberOfCFPCols, this.standardizer, this.tableType == 1);
        }
        catch (IOException e) {
            logger.throwing("UpdateHandler", "initFields", e);
            this.cfp = null;
        }
        int regen = RegenerationChecker.isRegenerationNeeded(this.tableName, new DatabaseProperties(this.conh, this.cartridgeMode));
        if (regen == 1 && this.mode == 1) {
            throw new SQLException("The structure table contains obsolete data. Please recalculate the table.");
        }
        if (regen == 2) {
            throw new SQLException("The structure table contains newer data version that this program version can handle. Please use a later version.");
        }
        StringTokenizer st = new StringTokenizer(this.additionalColumnsString, " ,\n");
        while (st.hasMoreTokens()) {
            AdditionalColumn addCol = new AdditionalColumn();
            addCol.name = st.nextToken().toUpperCase();
            this.additionalColumns.add(addCol);
        }
        this.initChemTermColumns();
        this.getFieldsFromDB();
        this.getMolecularDescriptorNames();
    }

    private void getMolecularDescriptorNames() throws SQLException {
        if (!this.cartridgeMode) {
            MDTableHandler mdth = new MDTableHandler(this.conh, this.tableName);
            this.descriptorNames = mdth.getMolecularDescriptors();
            if (this.mode == 1 || this.mode == 2) {
                int x;
                ArrayList<String> descriptors = new ArrayList<String>();
                for (x = 0; x < this.descriptorNames.length; ++x) {
                    String name = this.descriptorNames[x];
                    if (!mdth.getMDUpdateOnInsert(name)) continue;
                    descriptors.add(name);
                }
                this.descriptorNames = new String[descriptors.size()];
                for (x = 0; x < this.descriptorNames.length; ++x) {
                    this.descriptorNames[x] = (String)descriptors.get(x);
                }
            }
        } else {
            this.descriptorNames = new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFieldsFromDB() throws SQLException {
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.tableName + " WHERE cd_id=0");
            try {
                ResultSetMetaData rmd = rs.getMetaData();
                int cols = rmd.getColumnCount();
                this.fields = new Field[cols];
                for (int i = 0; i < cols; ++i) {
                    Field field = new Field();
                    field.name = rmd.getColumnName(i + 1).toUpperCase();
                    field.type = rmd.getColumnType(i + 1);
                    this.fields[i] = field;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readMax() throws SQLException {
        this.max = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT MAX(");
        sb.append("cd_id");
        sb.append(") FROM ");
        sb.append(this.tableName);
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sb.toString());
            try {
                rs.next();
                this.max = rs.getInt(1);
                this.fields[0].value = new Integer(this.max + 1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMax() throws SQLException {
        int max = 0;
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT MAX(");
        sb.append("cd_id");
        sb.append(") FROM ");
        sb.append(this.tableName);
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sb.toString());
            try {
                rs.next();
                max = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return max;
    }

    private void initChemTermColumns() throws SQLException {
        String colName;
        int i;
        DatabaseProperties dbProps = new DatabaseProperties(this.conh, this.cartridgeMode);
        String[] ctColNames = dbProps.getChemTermColumns(this.tableName);
        if (ctColNames == null || ctColNames.length == 0) {
            return;
        }
        this.chemTermColCfg = new HashMap<String, String>();
        for (i = 0; i < ctColNames.length; ++i) {
            colName = ctColNames[i];
            for (int x = 0; x < this.additionalColumns.size(); ++x) {
                AdditionalColumn addCol = (AdditionalColumn)this.additionalColumns.get(x);
                if (!addCol.name.equals(colName.toUpperCase())) continue;
                throw new IllegalArgumentException("additionalColumnsString cannot contain columns which will be assigned pre-computed values based on Chemical Terms expressions. (Offending column name: " + colName + ".)");
            }
        }
        try {
            for (i = 0; i < ctColNames.length; ++i) {
                colName = ctColNames[i];
                String expression = dbProps.getChemTermForColumn(this.tableName, colName);
                ChemJEP chemJep = ChemJepCacheMolContext.getCreateChemJep(expression);
                ChemJepCacheMolContext.recycleChemJep(expression, chemJep);
                this.chemTermColCfg.put(colName, expression);
            }
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("An exception occurred while initializing Chemical Term expressions: " + parseException.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An exception occurred while initializing Chemical Term expressions: " + e.getMessage());
        }
    }

    PreparedStatement getPstmtForUpdate() throws SQLException {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("UPDATE ");
        sb.append(this.tempTableToWrite == null ? this.tableName : this.tempTableToWrite);
        sb.append(" SET \n");
        int count = 0;
        for (int x = 0; x < this.activeFieldList.size(); ++x) {
            Field field = (Field)this.activeFieldList.get(x);
            if (count++ != 0) {
                sb.append(",\n");
            }
            sb.append(field.name);
            if (field.name.equals("CD_TIMESTAMP")) {
                sb.append("=" + this.timeStamp);
                continue;
            }
            sb.append("=?");
        }
        sb.append("\n WHERE cd_id=?");
        return this.con.prepareStatement(sb.toString());
    }

    PreparedStatement getPstmtForInsert() throws SQLException {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("INSERT INTO ");
        sb.append(this.tempTableToWrite == null ? this.tableName : this.tempTableToWrite);
        sb.append(" (\n");
        String values = "";
        int count = 0;
        for (int x = 0; x < this.activeFieldList.size(); ++x) {
            Field field = (Field)this.activeFieldList.get(x);
            if (count++ != 0) {
                sb.append(",\n");
                values = values + ",";
            }
            sb.append(field.name);
            values = field.name.equals("CD_TIMESTAMP") ? values + this.timeStamp : values + "?";
        }
        sb.append(") ");
        sb = sb.append("VALUES (" + values + ")");
        return this.con.prepareStatement(sb.toString());
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    void setInputMolecule(Molecule mol) {
        this.inputMol = mol;
        this.inputMoleculeSet = true;
    }

    String getSmilesOrSmarts(Molecule mol) {
        if (this.isMarkush) {
            return null;
        }
        String cd_smiles = null;
        if (this.tableType == 4) {
            return UpdateHandler.getSmarts(mol);
        }
        cd_smiles = UpdateHandler.getSmiles(mol);
        if (cd_smiles != null && cd_smiles.length() <= this.smilesLength) {
            return cd_smiles;
        }
        return null;
    }

    static String getSmiles(Molecule mol) {
        String smiles;
        if (mol.getAtomCount() == 0) {
            return " ";
        }
        if (!CxsmilesExport.canBeDescribedByCxsmiles(mol)) {
            return null;
        }
        try {
            smiles = MolExporter.exportToFormat(mol, "cxsmiles");
        }
        catch (IOException e) {
            return null;
        }
        return smiles;
    }

    static String getSmarts(Molecule mol) {
        String smarts;
        if (mol.getAtomCount() == 0) {
            return " ";
        }
        if (!UpdateHandler.canBeDescribedByCxsmarts(mol)) {
            return null;
        }
        try {
            smarts = MolExporter.exportToFormat(mol, "cxsmarts");
        }
        catch (IOException e) {
            return null;
        }
        return smarts;
    }

    private static boolean canBeDescribedByCxsmarts(Molecule mol) {
        RgMolecule rgm;
        boolean isDaylightFormat = MolHandler.isDaylightFormat(mol.getInputFormat());
        if (!isDaylightFormat && UpdateHandler.containsMisleadingDaylightFeatures(mol)) {
            return false;
        }
        int ac = mol.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            MolAtom atom = mol.getAtom(i);
            if (!atom.isLinkNode() && atom.getQPropAsInt("s") == -1 && atom.getQPropAsInt("u") == -1 && atom.getQPropAsInt("rb") == -1) continue;
            return false;
        }
        if (mol instanceof RgMolecule && (rgm = (RgMolecule)mol).getRgroupCount() > 0) {
            return false;
        }
        int bondCount = mol.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolBond bond = mol.getBond(i);
            if ((bond.getFlags() & 0xF000) == 0) continue;
            return false;
        }
        int sgroupCount = mol.getSgroupCount();
        for (int i = 0; i < sgroupCount; ++i) {
            Sgroup sgroup = mol.getSgroup(i);
            int t = sgroup.getType();
            switch (t) {
                case 8: 
                case 9: 
                case 13: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean containsMisleadingDaylightFeatures(Molecule mol) {
        int an = mol.getAtomCount();
        for (int i = 0; i < an; ++i) {
            MolAtom ma = mol.getAtom(i);
            switch (ma.getAtno()) {
                case 131: {
                    return true;
                }
                case 129: {
                    if (ArrayTools.indexInArray(ma.getList(), 1) != -1) break;
                    return true;
                }
            }
            if (ma.getQPropAsInt("H") == -1) continue;
            return true;
        }
        int bondCount = mol.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolBond bond = mol.getBond(i);
            if (bond.getType() != 2 || !UpdateHandler.hasCisTrans(mol, bond)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCisTrans(Molecule mol, MolBond bond) {
        int ct = 0;
        MolAtom atom2 = bond.getAtom1();
        MolAtom atom3 = bond.getAtom2();
        MolAtom atom1 = UpdateHandler.getOtherNeighbour(atom2, atom3);
        MolAtom atom4 = UpdateHandler.getOtherNeighbour(atom3, atom2);
        if (atom1 != null && atom4 != null) {
            ct = mol.getStereo2(bond, atom1, atom4, false);
        }
        return ct != 0 && ct != 192 && ct != 448;
    }

    private static MolAtom getOtherNeighbour(MolAtom a, MolAtom n) {
        int bondCount = a.getBondCount();
        for (int i = 0; i < bondCount; ++i) {
            MolAtom n1 = a.getLigand(i);
            if (n1 == n) continue;
            return n1;
        }
        return null;
    }

    private Standardizer getStandardizer() throws UpdateHandlerException {
        try {
            this.standardizer = TableInfo.getStandardizer(this.conh, this.tableName, this.cartridgeMode);
        }
        catch (SQLException sqle) {
            logger.throwing("UpdateHandler", "getStandardizer", sqle);
            throw new UpdateHandlerException(sqle);
        }
        catch (StandardizerException e) {
            logger.throwing("UpdateHandler", "getStandardizer", e);
            throw new UpdateHandlerException("Invalid standardizer configuration", e);
        }
        return this.standardizer;
    }

    private void standardize(Molecule mol) {
        if (this.standardize) {
            if (this.isMarkush) {
                MarkushAromata ma = new MarkushAromata();
                ma.aromatize(mol);
            } else {
                boolean optionals = this.tableType != 4;
                TableInfo.standardize(mol, this.standardizer, optionals);
            }
        }
    }

    private CDMarkushToDB calculateMarkushData() throws ServiceConfigurationError, IllegalArgumentException {
        if (this.isMarkush) {
            if (this.defaultMarkushHandler == null) {
                this.defaultMarkushHandler = CDMarkushUtil.getDefaultHandler();
            }
            CDMarkushToDB ret = this.defaultMarkushHandler.createData(this.mol);
            this.markushData = ret.getData();
            return ret;
        }
        this.markushData = null;
        return null;
    }

    private void init() throws UpdateHandlerException, MolFormatException {
        RgMolecule rgmol;
        boolean enumeration;
        if (this.rowData != null) {
            this.structure = this.rowData.molString;
            this.smiles = this.rowData.smiles;
            this.formula = this.rowData.formula;
            this.sortableFormula = this.rowData.sortableFormula;
            this.molWeight = this.rowData.molWeight;
            this.hash = this.rowData.hashCode;
            this.flags = this.rowData.flags;
            this.fingerprint = this.rowData.fingerprint;
            this.isMarkush = this.rowData.isMarkush;
            this.noRingInfoInFP = this.rowData.noRingInfoInFP;
            this.reactionMappingIncomplete = this.rowData.reactionMappingIncomplete;
            this.markushData = this.rowData.markushData;
            this.mol = this.rowData.molecule;
            this.chemTermColValues = this.rowData.chemTermColValues;
            this.genericTautomer = this.rowData.genericTautomer;
            this.molName = this.rowData.molName;
            this.rowData = null;
            return;
        }
        this.readMolecule(this.structure);
        if (this.setChiralFlag) {
            this.mol.setAbsStereo(true);
        }
        this.isMarkush = this.tableType == 3;
        Molecule molToEnumerate = null;
        int enumeratedFeatures = SearchUtil.DEFAULT_ENUMERATION;
        boolean bl = enumeration = this.tableType == 4 && SearchEnumerator.isEnumerable(this.mol, enumeratedFeatures);
        if (enumeration) {
            molToEnumerate = (Molecule)this.mol.clone();
            this.calcEnumeratedQueryFingerprintAndSmarts(molToEnumerate, enumeratedFeatures);
        }
        if (this.tautomerDuplicateSearch) {
            this.standardize(this.mol);
            try {
                boolean ignoreIsotopeMatching = false;
                this.genericTautomer = TautomerUtil.createGenericTautomer(this.mol, this.genericTautomerProtectsChirality, this.switchOffAllProtectionsForTDF, ignoreIsotopeMatching);
                this.hash = this.hc.getHashCode(this.genericTautomer);
            }
            catch (PluginException e) {
                e.printStackTrace();
                throw new UpdateHandlerException(e);
            }
        }
        this.standardize(this.mol);
        CDMarkushToDB markushToDB = null;
        try {
            markushToDB = this.calculateMarkushData();
        }
        catch (IllegalArgumentException e) {
            throw new MolFormatException("Could not calculate cd_markush field.", e);
        }
        if (!enumeration) {
            int[][] fingerprints = FingerprintHandler.getFingerprints(this.mol, this.cfp, this.tableType, true, this.tableType != 3, markushToDB);
            this.noRingInfoInFP = this.cfp.isRingInfoIncomplete();
            this.reactionMappingIncomplete = this.cfp.isReactionMappingIncomplete();
            this.fingerprint = this.noRingInfoInFP ? fingerprints[0] : fingerprints[1];
            this.smiles = this.getSmilesOrSmarts(this.mol);
        }
        if (!this.tautomerDuplicateSearch) {
            if (!TableInfo.isFPusedinHashCode(this.tableType)) {
                Molecule molToScreen = this.mol;
                if (this.tableType == 3) {
                    HomologyConversionUtil.deconvertHomologies(molToScreen, true);
                }
                this.hash = this.hc.getHashCode(molToScreen);
            } else {
                this.hash = this.hc.getHashCode(this.mol, this.fingerprint);
            }
        }
        boolean noWeightAndFormula = false;
        if (this.mol instanceof RgMolecule && ((rgmol = (RgMolecule)this.mol).getRgroupCount() != 0 || rgmol.getRoot() instanceof RxnMolecule)) {
            noWeightAndFormula = true;
        }
        if (this.mol instanceof RxnMolecule || this.isMarkush || enumeration) {
            noWeightAndFormula = true;
        }
        if (!noWeightAndFormula) {
            if (this.elemanal == null) {
                this.elemanal = new ElementalAnalyser();
            }
            this.elemanal.setMolecule(this.mol);
            this.formula = this.elemanal.formula();
            this.sortableFormula = this.elemanal.formula(5);
            this.molWeight = new Double(this.elemanal.mass());
        } else {
            this.formula = null;
            this.sortableFormula = null;
            this.molWeight = null;
        }
        this.calcChemTermColValues();
        if (!(this.cartridgeMode || this.regenerateMode || this.dbOptions.doNotCompressStructureField)) {
            int format2 = -1;
            if (this.inputFormat != null) {
                format2 = FileInfo.getFormat(this.inputFormat);
            }
            if (format2 == 1 || format2 == 7 || format2 == 2) {
                try {
                    this.structure = MdlCompressor.convert(this.structure, MdlCompressor.COMPRESS);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        logger.finer("Hash code: " + this.hash);
        this.calcFlags();
    }

    private void calcEnumeratedQueryFingerprintAndSmarts(Molecule molToEnumerate, int enumeratedFeatures) throws UpdateHandlerException {
        SearchEnumerator enumerator = new SearchEnumerator(enumeratedFeatures, molToEnumerate);
        StringBuffer concatenatedSmarts = new StringBuffer();
        ArrayList<int[][]> fingerprints = new ArrayList<int[][]>();
        boolean withRings = true;
        int count = 0;
        boolean cannotDescribeInSmarts = false;
        while (enumerator.hasMoreElements()) {
            if (++count > 500) {
                throw new UpdateHandlerException("The number of enumerations for the input structure exceed the allowed limit (500)");
            }
            Molecule enumeratedQuery = enumerator.nextElement();
            this.standardize(enumeratedQuery);
            if (!cannotDescribeInSmarts) {
                String smarts;
                if (count > 1) {
                    concatenatedSmarts.append(JChemCache.SMARTS_SEPARATOR);
                }
                if ((smarts = this.getSmilesOrSmarts(enumeratedQuery)) == null) {
                    cannotDescribeInSmarts = true;
                } else {
                    concatenatedSmarts.append(smarts);
                }
            }
            fingerprints.add(FingerprintHandler.getFingerprints(enumeratedQuery, this.cfp, this.tableType, withRings, this.tableType != 3, null));
            if (!this.cfp.isRingInfoIncomplete()) continue;
            this.noRingInfoInFP = true;
            withRings = false;
        }
        int[] enumFp = new int[this.numberOfFPCols];
        Arrays.fill(enumFp, -1);
        for (int x = 0; x < count; ++x) {
            int[][] fps = (int[][])fingerprints.get(x);
            int[] fp = this.noRingInfoInFP ? fps[0] : fps[1];
            for (int y = 0; y < fp.length; ++y) {
                int n = y;
                enumFp[n] = enumFp[n] & fp[y];
            }
        }
        this.fingerprint = enumFp;
        this.smiles = cannotDescribeInSmarts ? null : concatenatedSmarts.toString();
    }

    public void setROWID(String rowID) {
        this.rowID = rowID;
    }

    void readMolecule(byte[] structure) throws MolFormatException, UpdateHandlerException {
        this.rowData = null;
        if (structure == null || structure.length == 0) {
            structure = TableInfo.EMPTY_STRUCTURE_AS_BYTES;
        }
        if (this.inputMol == null) {
            this.mol = new MolHandler(structure, this.tableType == 4).getMolecule();
            this.inputFormat = this.mol.getInputFormat();
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(structure);
            try {
                MolInputStream mis = new MolInputStream(bais);
                this.inputFormat = mis.getFormat();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mol = this.inputMol;
            this.inputMol = null;
        }
        String error = UpdateHandler.testIfInsertable(this.mol, this.tableType, this.tableName, this.emptyStructuresAllowed);
        if (error != null) {
            throw new UpdateHandlerException(error);
        }
        this.structure = structure;
    }

    private static String testIfInsertable(Molecule mol, int tableType, String tableName, boolean emptyStructuresAllowed) {
        String errorText;
        boolean emptyStructure = UpdateHandler.isEmptyStructure(mol);
        boolean markush = Supergraph.isMarkushMolecule(mol);
        if (!emptyStructuresAllowed && emptyStructure) {
            return "Empty structure";
        }
        if ((tableType == 0 || tableType == 1) && (mol.isQuery() || markush)) {
            return "Inserting a query or Markush structure is not allowed for table: \"" + tableName + "\"";
        }
        boolean isReaction = mol.isReaction();
        if (isReaction && tableType != 1 && tableType != 2 && tableType != 4) {
            return "Inserting reactions is not allowed for table: \"" + tableName + "\". The table is not a reaction table.";
        }
        if (tableType == 1 && !isReaction && !emptyStructure) {
            return "Only reactions can be stored in reaction table: \"" + tableName + "\". The structure is not a reaction.";
        }
        if (tableType == 3 && (errorText = Supergraph.errorInSupergraphRepresentation(mol)) != null) {
            return "Structure is not valid for table: \"" + tableName + "\" of type Markush.\n" + errorText;
        }
        return null;
    }

    private static boolean isEmptyStructure(Molecule mol) {
        return mol.getAtomCount() == 0;
    }

    void closeAndPrepareIfNeeded() throws SQLException {
        boolean pstmtNeeded = false;
        if (this.activeFieldListChanged()) {
            pstmtNeeded = true;
        }
        if (this.pstmt == null || this.alwaysCreateNew || this.spoiledMax || this.lastPstmtMode != this.mode) {
            pstmtNeeded = true;
        }
        this.lastPstmtMode = this.mode;
        if (this.pstmt != null && pstmtNeeded) {
            this.pstmt.close();
        }
        if (!this.dbOptions.isAutoIncrementProperty && this.mode == 1 && (pstmtNeeded || this.spoiledMax)) {
            this.readMax();
        }
        if (pstmtNeeded) {
            this.pstmt = this.mode == 0 && this.tempTableToWrite == null ? this.getPstmtForUpdate() : this.getPstmtForInsert();
        }
    }

    private boolean activeFieldListChanged() {
        boolean change = false;
        if (this.lastActiveFieldList != null && !this.lastActiveFieldList.equals(this.activeFieldList)) {
            change = true;
        }
        this.lastActiveFieldList = (ActiveFieldList)this.activeFieldList.clone();
        return change;
    }

    public void setStructure(String source) {
        try {
            if (source != null) {
                this.structure = source.getBytes("ASCII");
                this.structureSourceSet = true;
            } else {
                this.structure = null;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setStructure(byte[] source) {
        this.structure = source;
    }

    public void setID(int id) {
        this.cd_id = id;
    }

    public void setIgnoreChemicalTermsExceptions(boolean ignore) {
        this.ignoreCTErrors = ignore;
    }

    public void setLoggingEnabled(boolean value) {
        this.loggingEnabled = value;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    private void calcChemTermColValues() throws ChemicalTermsUpdateHandlerException {
        if (this.chemTermColCfg == null || !this.chemTermCalcNeeded) {
            return;
        }
        this.chemTermColValues = new HashMap<String, Object>();
        Iterator<String> iterator = this.chemTermColCfg.keySet().iterator();
        while (iterator.hasNext()) {
            Exception chemTermError = null;
            String ctColName = null;
            String expression = null;
            try {
                ctColName = iterator.next();
                expression = this.chemTermColCfg.get(ctColName);
                ChemJEP chemJep = ChemJepCacheMolContext.getCreateChemJep(expression);
                this.molContext.setMolecule(this.mol);
                Object ctValue = chemJep.evaluate(this.molContext);
                ChemJepCacheMolContext.recycleChemJep(expression, chemJep);
                Object result = UpdateHandler.checkChemTermColValue(ctValue);
                this.chemTermColValues.put(ctColName, result);
            }
            catch (ParseException parseException) {
                chemTermError = parseException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                chemTermError = illegalArgumentException;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            if (chemTermError == null) continue;
            String errorString = "Error for column " + ctColName + " with structure " + this.structRef() + ": " + chemTermError.getMessage() + ", expression: " + expression;
            if (this.ignoreCTErrors) {
                logger.severe(errorString);
                this.chemTermColValues.put(ctColName, null);
                continue;
            }
            throw new ChemicalTermsUpdateHandlerException(errorString, chemTermError);
        }
    }

    private String structRef() {
        String structRef = null;
        if (this.cd_id != 0) {
            structRef = "cd_id=" + String.valueOf(this.cd_id);
        } else if (this.structure != null) {
            structRef = "structure=" + new String(this.structure);
        } else if (this.mol != null) {
            structRef = "mol=" + this.mol.toFormat(this.mol.getInputFormat());
        }
        return structRef;
    }

    private void setChemTermColFields() throws SQLException {
        if (this.chemTermColValues == null) {
            return;
        }
        String ctColName2 = null;
        try {
            for (String ctColName2 : this.chemTermColValues.keySet()) {
                Object ctValue = this.chemTermColValues.get(ctColName2);
                Field field = this.getField(ctColName2);
                field.value = ctValue;
                this.activeFieldList.add(field);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Error with Chemical Terms evaluation for column " + ctColName2 + ": " + iae.getMessage());
        }
    }

    public static Object checkChemTermColValue(Object result) {
        if (result == null) {
            return null;
        }
        boolean supportedResultType = true;
        if (result instanceof Float) {
            Float fltResult = (Float)result;
            if (Float.isNaN(fltResult.floatValue())) {
                return null;
            }
        } else if (result instanceof Double) {
            Double dblResult = (Double)result;
            if (Double.isNaN(dblResult)) {
                return null;
            }
        } else if (result instanceof Molecule) {
            result = ((Molecule)result).toFormat("mrv");
        } else if (!(result instanceof byte[]) && result.getClass().isArray()) {
            supportedResultType = false;
        }
        if (!supportedResultType) {
            throw new IllegalArgumentException("Chemical Terms expression evaluates to an unsupported type: " + result.getClass().getName());
        }
        return result;
    }

    private void setFields() throws SQLException {
        this.resetFields();
        this.setFieldCdId();
        this.setFieldRowId();
        this.setFieldCdStructure();
        this.setFieldCdMarkush();
        this.setFieldCdSmilesOrCdSmarts();
        this.setFieldCdFormula();
        this.setFieldCdSortableFormula();
        this.setFieldCdMolweight();
        this.setFieldCdHash();
        this.setFieldCdFlags();
        this.setFieldCdPreCalculated();
        this.setFieldCdTimestamp();
        this.setFieldFingerprintFields();
        this.setFieldName();
        this.setAdditionalColumns();
        this.setChemTermColFields();
        this.fieldTypeCheck();
        this.checkBigLOBs();
    }

    private void setFieldCdMarkush() throws SQLException {
        if (this.isMarkush) {
            Field field = this.getField("CD_MARKUSH");
            field.value = this.markushData;
            this.activeFieldList.add(field);
        }
    }

    private void fieldTypeCheck() {
        for (int x = 0; x < this.activeFieldList.size(); ++x) {
            Field field = (Field)this.activeFieldList.get(x);
            int type = field.type;
            if (field.forcedType != 0) {
                type = field.forcedType;
            }
            if (this.dbms == 4) {
                if (field.type == 0) {
                    field.forcedType = -1;
                }
                if (field.type == -4) {
                    field.forcedType = -4;
                }
            }
            if ((type == -4 || type == 2004) && field.value instanceof String) {
                try {
                    field.value = ((String)field.value).getBytes("ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            if ((type == 2005 || type == 12) && field.value instanceof byte[]) {
                try {
                    field.value = new String((byte[])field.value, "ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            if (!(field.value instanceof String) || this.isStringType(type)) continue;
            field.value = ((String)field.value).trim();
            if (((String)field.value).length() != 0) continue;
            field.value = null;
        }
    }

    private void resetFields() {
        this.activeFieldList = new ActiveFieldList();
        for (int x = 0; x < this.fields.length; ++x) {
            Field field = this.fields[x];
            field.bigLOB = false;
            field.forcedType = 0;
            field.value = null;
        }
    }

    private void setAdditionalColumns() throws SQLException {
        for (int x = 0; x < this.additionalColumns.size(); ++x) {
            AdditionalColumn addCol = (AdditionalColumn)this.additionalColumns.get(x);
            Field field = this.getField(addCol.name);
            field.value = addCol.value;
            field.forcedType = addCol.forcedType;
            this.activeFieldList.add(field);
        }
    }

    private void setFieldCdTimestamp() throws SQLException {
        if (this.cartridgeMode || this.regenerateMode) {
            return;
        }
        Field field = this.getField("CD_TIMESTAMP");
        this.activeFieldList.add(field);
    }

    private void setFieldFingerprintFields() throws SQLException {
        for (int i = 0; i < this.numberOfFPCols; ++i) {
            Field field = this.getField("CD_FP" + (i + 1));
            field.value = new Integer(this.fingerprint[i]);
            this.activeFieldList.add(field);
        }
    }

    private void calcFlags() {
        this.flags = "";
        if (this.reactionMappingIncomplete) {
            this.flags = this.flags + 'i';
        }
        if (this.noRingInfoInFP) {
            this.flags = this.flags + 'r';
        }
        if (this.isMarkush) {
            this.flags = this.flags + 'm';
        }
        if (this.setChiralFlag) {
            this.flags = this.flags + 'c';
        }
        if (this.flags.length() == 0) {
            this.flags = null;
        }
    }

    public void setStructureNameField(String nameField) {
        this.molNameField = nameField;
    }

    public String getStructureNameField() {
        return this.molNameField.toUpperCase();
    }

    private void setFieldName() throws SQLException {
        String nameField = this.getStructureNameField();
        if (nameField != "") {
            Field field = this.getField(nameField);
            field.value = this.molName;
            this.activeFieldList.add(field);
        }
    }

    private void setFieldCdFlags() throws SQLException {
        Field field = this.getField("CD_FLAGS");
        field.value = this.flags;
        this.activeFieldList.add(field);
    }

    private void setFieldCdHash() throws SQLException {
        Field field = this.getField("CD_HASH");
        field.value = new Integer(this.hash);
        this.activeFieldList.add(field);
    }

    private void setFieldCdMolweight() throws SQLException {
        Field field = this.getField("CD_MOLWEIGHT");
        field.value = this.molWeight;
        this.activeFieldList.add(field);
    }

    private void setFieldCdFormula() throws SQLException {
        Field field = this.getField("CD_FORMULA");
        field.value = this.formula;
        this.activeFieldList.add(field);
    }

    private void setFieldCdSortableFormula() throws SQLException {
        Field field = this.getField("CD_SORTABLE_FORMULA");
        field.value = this.sortableFormula;
        this.activeFieldList.add(field);
    }

    private void setFieldCdSmilesOrCdSmarts() throws SQLException {
        Field field = null;
        field = this.tableType == 4 ? this.getField("CD_SMARTS") : this.getField("CD_SMILES");
        field.value = this.smiles;
        this.activeFieldList.add(field);
    }

    private void setFieldRowId() throws SQLException {
        if (!this.cartridgeMode || this.mode == 0) {
            return;
        }
        Field field = this.getField("RID");
        field.type = -1;
        field.value = this.rowID;
        this.activeFieldList.add(field);
    }

    private void setFieldCdId() throws SQLException {
        Field field = this.getField("CD_ID");
        if (this.mode == 1 && !this.dbOptions.isAutoIncrementProperty) {
            field.value = new Integer(this.max + 1);
            field.type = 4;
            this.activeFieldList.add(field);
        } else if (this.mode == 2 || this.mode == 0 && this.tempTableToWrite != null) {
            field.value = new Integer(this.cd_id);
            field.type = 4;
            this.activeFieldList.add(field);
        }
    }

    private void setFieldCdStructure() throws SQLException {
        if (this.cartridgeMode || this.regenerateMode) {
            return;
        }
        Field field = this.getField("CD_STRUCTURE");
        if (field.type == 2005) {
            String struc = null;
            try {
                struc = new String(this.structure, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            field.value = UpdateHandlerOracle.getCLOB(this.con, struc);
        } else {
            field.value = this.structure;
        }
        this.activeFieldList.add(field);
    }

    private void setFieldCdPreCalculated() throws SQLException {
        Field field = this.getField("CD_PRE_CALCULATED");
        if (this.mode != 0 || this.tempTableToWrite == null) {
            field.value = new Integer(0);
            field.type = 4;
            this.activeFieldList.add(field);
        }
    }

    private Field getField(String name) throws SQLException {
        name = name.toUpperCase();
        for (int x = 0; x < this.fields.length; ++x) {
            Field field = this.fields[x];
            if (!field.name.equals(name)) continue;
            return field;
        }
        throw new SQLException("ERROR: field \"" + name + "\" is not " + "present in table \"" + this.tableName + "\".");
    }

    public void setValueForAdditionalColumn(int index, Object value, int sqlType) throws SQLException {
        AdditionalColumn addCol = (AdditionalColumn)this.additionalColumns.get(index - 1);
        addCol.value = value;
        addCol.forcedType = sqlType;
    }

    public void setValueForAdditionalColumn(int index, Object value) throws SQLException {
        this.setValueForAdditionalColumn(index, value, 0);
    }

    void setValuesForPstmt() throws SQLException {
        int pos = 0;
        for (int x = 0; x < this.activeFieldList.size(); ++x) {
            Field field = (Field)this.activeFieldList.get(x);
            String name = field.name;
            if (name.equals("CD_TIMESTAMP")) continue;
            ++pos;
            Object value = field.value;
            int type = field.type;
            if (field.forcedType != 0) {
                type = field.forcedType;
            }
            if (value == null) {
                this.pstmt.setNull(pos, type);
                continue;
            }
            if (type == 2004) {
                byte[] bytes = (byte[])value;
                if (field.bigLOB) {
                    bytes = new byte[1];
                }
                this.pstmt.setBytes(pos, bytes);
                continue;
            }
            if (type == 2005 && this.dbms == 1) {
                Clob clob = null;
                clob = field.bigLOB ? UpdateHandlerOracle.getCLOB(this.con, "a") : (value instanceof String ? UpdateHandlerOracle.getCLOB(this.con, (String)value) : (Clob)value);
                this.pstmt.setClob(pos, clob);
                continue;
            }
            if (type == -4 || type == -2) {
                byte[] data = null;
                if (value instanceof String) {
                    try {
                        data = ((String)value).getBytes("ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    data = (byte[])value;
                }
                if (this.dbms == 7) {
                    this.pstmt.setBytes(pos, data);
                    continue;
                }
                this.pstmt.setBinaryStream(pos, (InputStream)new ByteArrayInputStream(data), data.length);
                continue;
            }
            if (field.forcedType != 0) {
                this.pstmt.setObject(pos, value, type);
                continue;
            }
            this.pstmt.setObject(pos, value);
        }
        if (this.mode == 0 && this.tempTableToWrite == null) {
            this.pstmt.setInt(++pos, this.cd_id);
        }
    }

    private boolean isStringType(int type) {
        return type == 1 || type == 12 || type == -1 || type == 2005;
    }

    private boolean isBigLOB(Field field) throws SQLException {
        if (this.dbms != 1 || field.type != 2004 && field.type != 2005) {
            return false;
        }
        Object value = field.value;
        long length = 0L;
        if (value instanceof byte[]) {
            length = ((byte[])value).length;
        } else if (value instanceof Clob) {
            length = ((Clob)value).length();
        } else if (value instanceof String) {
            length = ((String)value).length();
        }
        return this.mode == 0 ? length > 2000L : length > 2000L;
    }

    public void setEmptyStructuresAllowed(boolean allowed) {
        this.emptyStructuresAllowed = allowed;
    }

    @Deprecated
    public void setDuplicateFiltering(boolean filtering) {
        this.duplicateFiltering = filtering;
        this.isDuplicateFilteringTO = false;
    }

    public void setDuplicateFiltering(int duplicateFilteringOption) {
        if (duplicateFilteringOption == 2) {
            this.duplicateFiltering = false;
            this.isDuplicateFilteringTO = false;
        } else if (duplicateFilteringOption == 1) {
            this.duplicateFiltering = true;
            this.isDuplicateFilteringTO = false;
        } else if (duplicateFilteringOption == 0) {
            this.isDuplicateFilteringTO = true;
            try {
                DatabaseProperties dbProp = new DatabaseProperties(this.conh, this.cartridgeMode);
                this.tableType = dbProp.getTableType(this.tableName);
                this.duplicateFiltering = this.tableName == null || this.tableName.equals("") ? false : dbProp.isDuplicateFilteringOption(this.tableName);
            }
            catch (SQLException e) {
                this.duplicateFiltering = false;
            }
        }
    }

    public void setSetChiralFlag(boolean setChiralFlag) {
        this.setChiralFlag = setChiralFlag;
    }

    public boolean getSetChiralFlag() {
        return this.setChiralFlag;
    }

    public void setStandardizationEnabled(boolean allowed) {
        this.standardize = allowed;
    }

    void setImportDisabled(boolean disabled) {
        this.doNotImport = disabled;
    }

    private int searchDuplicateID() throws SQLException {
        logger.finer("Searching for duplicates.");
        if (this.jcsearch == null) {
            this.jcsearch = this.cartridgeMode ? new JChemSearch(this.indexedTable, this.indexedColumn) : new JChemSearch();
            this.jcsearch.setConnectionHandler(this.conh);
            this.jcsearch.setStructureTable(this.tableName);
            this.jcsearch.setRunMode(0);
            int hitsNeeded = this.mode == 0 ? 2 : 1;
            this.jcsearch.setStandardizationDisabled(true);
            this.jcsearch.setUsePreparedStatements(true);
            JChemSearchOptions jso = new JChemSearchOptions(5);
            jso.setMaxResultCount(hitsNeeded);
            this.jcsearch.setSearchOptions(jso);
        }
        this.jcsearch.setQueryStructure(this.mol);
        this.jcsearch.setPreCalculatedHashCode(this.hash);
        this.jcsearch.setPreCalculatedGenericTautomer(this.genericTautomer);
        this.jcsearch.setPreCalculatedSmiles(this.smiles);
        try {
            this.jcsearch.run();
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.throwing("UpdateHandler", "searchDuplicateID", e);
            }
            throw new SQLException(e);
        }
        int foundItemsCount = this.jcsearch.getResultCount();
        if (this.mode == 0) {
            for (int i = 0; i < foundItemsCount; ++i) {
                int hit = this.jcsearch.getResult(i);
                if (hit == this.cd_id) continue;
                return hit;
            }
            return -1;
        }
        if (foundItemsCount > 0) {
            return this.jcsearch.getResult(0);
        }
        return -1;
    }

    public void execute() throws SQLException {
        this.execute(false);
    }

    public int execute(boolean returnLastId) throws SQLException {
        int id;
        boolean emptyStrucutre;
        if (this.dbms == 10) {
            throw new IllegalArgumentException("JChem does not support DDL and DML commands for Composite Databases.");
        }
        if (this.firstExecuteCall) {
            returnLastId = true;
            this.firstExecuteCall = false;
        }
        if (this.mode == 1 && this.descriptorNames.length > 0) {
            returnLastId = true;
        }
        if (this.singleInsertLog) {
            returnLastId = true;
        }
        if (this.inputMoleculeSet && !this.structureSourceSet) {
            throw new IllegalArgumentException("You must call setStructure(String) with the source of the molecule which is set with setInputMolecule(Molecule)");
        }
        try {
            this.init();
        }
        catch (UpdateHandlerException e) {
            throw new SQLException(e);
        }
        catch (MolFormatException e) {
            throw new SQLException(e);
        }
        if (this.reactionMappingIncomplete) {
            returnLastId = true;
        }
        boolean bl = emptyStrucutre = this.mol == null || UpdateHandler.isEmptyStructure(this.mol);
        if (this.duplicateFiltering && !emptyStrucutre && !this.regenerateMode && (id = this.searchDuplicateID()) != -1) {
            return -id;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "No duplicates found or no duplicate searching. duplicateFiltering: {0}", this.duplicateFiltering);
        }
        if (this.doNotImport) {
            return 0;
        }
        this.setFields();
        if (this.bigLOBs.size() > 0) {
            returnLastId = true;
        }
        boolean prevCommit = true;
        if (this.mode == 1 && returnLastId && this.dbms == 6) {
            prevCommit = this.con.getAutoCommit();
            this.con.setAutoCommit(false);
        }
        int n = this.lastId = this.mode == 2 || this.mode == 0 ? this.cd_id : 0;
        if (this.mode == 1 && !this.dbOptions.isAutoIncrementProperty) {
            this.spoiledMax = false;
            int maxTest = 10;
            for (int i = 0; i == 0 || this.spoiledMax && i < maxTest; ++i) {
                this.closeAndPrepareIfNeeded();
                this.setValuesForPstmt();
                try {
                    this.pstmt.executeUpdate();
                    this.spoiledMax = false;
                    continue;
                }
                catch (SQLException e) {
                    if (i == maxTest - 1) {
                        throw e;
                    }
                    this.spoiledMax = true;
                }
            }
            ++this.max;
            this.lastId = this.max;
        } else if (this.mode == 1 && returnLastId && this.dbms == 1 && this.dbOptions.isAutoIncrementProperty || this.dbms == 5 && !this.regenerateMode) {
            Field field = this.getField("CD_ID");
            this.lastId = this.getNextId(this.dbms);
            field.value = new Integer(this.lastId);
            this.activeFieldList.add(field);
            this.closeAndPrepareIfNeeded();
            this.setValuesForPstmt();
            this.pstmt.executeUpdate();
        } else {
            this.closeAndPrepareIfNeeded();
            this.setValuesForPstmt();
            this.pstmt.executeUpdate();
            if (this.dbms == 7 && this.mode == 2) {
                this.updatePostgreSequence();
            }
        }
        if (this.mode == 0 && this.tempTableToWrite != null) {
            UpdateHandler.setPreCalculated(this.conh, this.tableName, this.cd_id, true);
        }
        if (this.mode == 1 && returnLastId && (this.dbms == 3 || this.dbms == 6 || this.dbms == 7 || this.dbms == 2 || this.dbms == 8 || this.dbms == 9)) {
            this.lastId = this.getLastId(this.dbms);
        }
        if (this.bigLOBs.size() > 0) {
            try {
                UpdateHandlerOracle.updateBigLOBs(this.con, this.bigLOBs, this.tableName, this.lastId);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        if (this.descriptorNames.length > 0 && !this.regenerateMode) {
            int id2 = 0;
            id2 = this.mode == 0 || this.mode == 2 ? this.cd_id : this.lastId;
            this.updateDescriptors(id2);
        }
        if (this.mode == 1 && returnLastId && this.dbms == 6) {
            if (prevCommit) {
                this.con.commit();
            }
            this.con.setAutoCommit(prevCommit);
        }
        ++this.counter;
        if (this.reactionMappingIncomplete) {
            logger.warning("WARNING: Reaction with cd_id " + this.lastId + " could not be fully mapped.");
        }
        if (this.singleInsertLog && this.loggingEnabled) {
            int cdid = this.mode == 2 ? this.cd_id : this.lastId;
            byte updateCode = 4;
            String updateType = this.getInsertLogString(cdid, false);
            if (updateType != null) {
                ArrayList newCaches = this.prepareStoring(this.conh);
                UpdateHandler.storeUpdate(this.conh, updateType, this.dbms, this.tableName, this, this.registeredCaches);
                if (newCaches != null && newCaches.size() > 0) {
                    this.updateLogCache.logsForNewCaches(newCaches, this.storeUpdateLogPrepStmt);
                }
            }
            this.updateLogCache.storeUpdate(updateCode, cdid);
        }
        return this.lastId;
    }

    private String getInsertLogString(int cdid, boolean forcedReturn) {
        if (!forcedReturn) {
            ++this.bufferedIdsNo;
            if (this.bufferedIdsNo == 1) {
                this.bufferedLogString = new StringBuffer("Insert:" + cdid);
            } else {
                this.bufferedLogString.append(ID_SEPARATOR + cdid);
            }
        }
        if (forcedReturn && this.bufferedIdsNo > 0 || this.bufferedIdsNo == 10) {
            this.bufferedIdsNo = 0;
            String ret = this.bufferedLogString.toString();
            this.bufferedLogString = new StringBuffer("");
            return ret;
        }
        return null;
    }

    private void checkBigLOBs() throws SQLException {
        this.bigLOBs = new ArrayList();
        for (int x = 0; x < this.fields.length; ++x) {
            if (this.isBigLOB(this.fields[x])) {
                this.fields[x].bigLOB = true;
                this.bigLOBs.add(this.fields[x]);
                continue;
            }
            this.fields[x].bigLOB = false;
        }
    }

    private void updateDescriptors(int id) {
        MDDBWriter writer = new MDDBWriter();
        writer.setConnectionHandler(this.conh);
        writer.setStructureTable(this.tableName);
        writer.setMDNames(this.descriptorNames);
        if (this.mode == 0) {
            writer.setUpdateMode(true);
        }
        try {
            try {
                writer.put(new MolHandler(this.structure).getMolecule(), id);
            }
            catch (MolFormatException e) {
                e.printStackTrace();
            }
            writer.close();
        }
        catch (MDWriterException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextId(int dbms) throws SQLException {
        if (this.lastIdPrepStmt == null) {
            String sql = null;
            if (dbms == 1) {
                sql = "SELECT " + this.tableName + "_SQ.NEXTVAL FROM DUAL";
            } else if (dbms == 5) {
                sql = "SELECT gen_id(GEN_" + this.tableName + "_CD_ID, 1) FROM rdb$database";
            } else {
                return 0;
            }
            this.lastIdPrepStmt = this.con.prepareStatement(sql);
        }
        int nextVal = 0;
        ResultSet rs = this.lastIdPrepStmt.executeQuery();
        try {
            if (rs.next()) {
                nextVal = rs.getInt(1);
            }
        }
        finally {
            rs.close();
        }
        return nextVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastId(int dbms) throws SQLException {
        if (this.lastIdPrepStmt == null) {
            String sql = null;
            if (dbms == 3) {
                sql = "SELECT LAST_INSERT_ID() AS id";
            } else if (dbms == 6) {
                sql = "SELECT IDENTITY_VAL_LOCAL() AS ID FROM " + this.tableName;
            } else if (dbms == 7) {
                sql = "SELECT CURRVAL('" + this.tableName + "_cd_id_seq')";
            } else if (dbms == 2) {
                sql = "SELECT @@IDENTITY AS NewID";
            } else if (dbms == 8) {
                sql = "CALL IDENTITY()";
            } else if (dbms == 9) {
                sql = "values IDENTITY_VAL_LOCAL()";
            } else {
                return 0;
            }
            this.lastIdPrepStmt = this.con.prepareStatement(sql);
        }
        int id = 0;
        ResultSet rs = this.lastIdPrepStmt.executeQuery();
        try {
            if (rs.next()) {
                id = rs.getInt(1);
            }
        }
        finally {
            rs.close();
        }
        return id;
    }

    public void close() throws SQLException {
        if (this.pstmt != null) {
            if (this.loggingEnabled) {
                this.saveUpdateLogs();
            }
            this.pstmt.close();
        }
        if (this.lastIdPrepStmt != null) {
            this.lastIdPrepStmt.close();
        }
        if (this.storeUpdateLogPrepStmt != null) {
            this.storeUpdateLogPrepStmt.close();
        }
        if (this.jcsearch != null) {
            this.jcsearch.close();
        }
        this.firstExecuteCall = true;
    }

    public void saveUpdateLogs() throws SQLException {
        String updateType = null;
        byte cacheType = -1;
        int cacheID = -1;
        if (this.singleInsertLog) {
            updateType = this.getInsertLogString(-1, true);
            if (updateType == null) {
                return;
            }
            cacheType = 4;
            cacheID = this.lastId;
        } else if (this.mode == 1) {
            if (this.counter <= 1 && this.lastId != 0) {
                cacheType = 4;
                updateType = UpdateLogCache.createLogInfo(cacheType, this.lastId, true);
                cacheID = this.lastId;
            } else {
                cacheType = 5;
                updateType = UpdateLogCache.createLogInfo(cacheType, this.lastId, true);
                cacheID = -1;
            }
        } else if (this.mode == 2) {
            if (this.counter > 1) {
                cacheType = 5;
                updateType = UpdateLogCache.createLogInfo(cacheType, this.lastId, true);
                cacheID = -1;
            } else {
                cacheType = 4;
                updateType = UpdateLogCache.createLogInfo(cacheType, this.cd_id, true);
                cacheID = this.cd_id;
            }
        } else if (this.mode == 0) {
            if (this.counter > 1) {
                cacheType = 1;
                updateType = UpdateLogCache.createLogInfo(cacheType, this.cd_id, true);
                cacheID = -1;
            } else {
                cacheType = 0;
                updateType = UpdateLogCache.createLogInfo(cacheType, this.cd_id, true);
                cacheID = this.cd_id;
            }
        }
        ArrayList newCaches = this.prepareStoring(this.conh);
        UpdateHandler.storeUpdate(this.conh, updateType, this.dbms, this.tableName, this, this.registeredCaches);
        if (newCaches != null && newCaches.size() > 0) {
            this.updateLogCache.logsForNewCaches(newCaches, this.storeUpdateLogPrepStmt);
        }
        this.updateLogCache.storeUpdate(cacheType, cacheID);
    }

    private static void storeUpdate(ConnectionHandler conh, String update, int dbms, String tableName, UpdateHandler uh, ArrayList caches) throws SQLException {
        PreparedStatement pstmt = null;
        if (uh != null) {
            pstmt = uh.storeUpdateLogPrepStmt;
        }
        Connection con = conh.getConnection();
        boolean autoCommit = false;
        if (caches != null && (autoCommit = con.getAutoCommit())) {
            con.setAutoCommit(false);
        }
        if (pstmt == null) {
            String logTableName = TableInfo.getLogTableName(tableName);
            String sql = null;
            sql = dbms == 1 ? "INSERT INTO " + logTableName + " VALUES " + "(" + tableName + "_USQ.NEXTVAL , ?, ?)" : (dbms == 5 ? "INSERT INTO " + logTableName + " VALUES " + "(gen_id(GEN_" + logTableName + "_UPDATE_ID, 1), ?, ?)" : "INSERT INTO " + logTableName + " (update_info, cache_id) VALUES (?, ?)");
            pstmt = con.prepareStatement(sql);
        }
        pstmt.setString(1, update);
        if (caches != null) {
            for (int i = 0; i < caches.size(); ++i) {
                pstmt.setString(2, (String)caches.get(i));
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (autoCommit) {
                con.commit();
                con.setAutoCommit(true);
            }
            pstmt.clearBatch();
        }
        if (uh != null) {
            uh.storeUpdateLogPrepStmt = pstmt;
        } else {
            pstmt.close();
        }
    }

    private ArrayList getNewElements(ArrayList oldCaches, ArrayList newCaches) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < newCaches.size(); ++i) {
            Object o = newCaches.get(i);
            if (oldCaches.contains(newCaches.get(i))) continue;
            ret.add(o);
        }
        return ret;
    }

    private ArrayList prepareStoring(ConnectionHandler conh) throws SQLException {
        DatabaseProperties dp = this.storedUpdateLogDbProp;
        if (dp == null) {
            this.storedUpdateLogDbProp = dp = new DatabaseProperties(conh, false);
        }
        String dbTimestamp = dp.getProperty("cache.validity_timestamp");
        ArrayList modifiedCacheList = this.registeredCaches;
        ArrayList newCaches = null;
        if (this.cacheTimestamp == null || !this.cacheTimestamp.equals("") && !this.cacheTimestamp.equals(dbTimestamp)) {
            modifiedCacheList = UpdateHandler.getRegisteredCaches(conh);
            if (this.cacheTimestamp != null) {
                newCaches = this.getNewElements(this.registeredCaches, modifiedCacheList);
            }
            this.cacheTimestamp = dbTimestamp;
            this.registeredCaches = modifiedCacheList;
        }
        return newCaches;
    }

    private static ArrayList getRegisteredCaches(ConnectionHandler conh) throws SQLException {
        CacheRegistrationUtil cru = new CacheRegistrationUtil(conh);
        ArrayList modifiedCacheList = cru.getRegisteredCacheIDs();
        return modifiedCacheList;
    }

    public static void deleteRows(ConnectionHandler conh, String tableName, String where) throws SQLException {
        UpdateHandler.deleteRows(conh, tableName, where, true);
    }

    public static void deleteRows(ConnectionHandler conh, String tableName, String where, boolean enableLogging) throws SQLException {
        UpdateHandler.deleteRows(conh, tableName, where, false, 0, enableLogging);
    }

    public static void deleteRow(ConnectionHandler conh, String tableName, int cd_id) throws SQLException {
        UpdateHandler.deleteRow(conh, tableName, cd_id, true);
    }

    public static void deleteRow(ConnectionHandler conh, String tableName, int cd_id, boolean enableLogging) throws SQLException {
        String where = "WHERE cd_id = " + cd_id;
        UpdateHandler.deleteRows(conh, tableName, where, true, cd_id, enableLogging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteRows(ConnectionHandler conh, String tableName, String where, boolean singleRow, int cd_id, boolean isLoggingEnabled) throws SQLException {
        Connection con = conh.getConnection();
        int dbms = DatabaseOptions.getDBMSType(con);
        if (where == null) {
            where = "";
        }
        boolean toCommit = false;
        try {
            toCommit = con.getAutoCommit();
            if (toCommit && dbms != 7) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        MDTableHandler mdth = new MDTableHandler(conh, tableName);
        String[] mdTables = mdth.getMDTables();
        try {
            String sql;
            block32: {
                boolean byForeignKey = DatabaseOptions.usesForeignKey(dbms);
                if (mdTables.length > 0 && !byForeignKey) {
                    if (where.length() > 0) {
                        Statement stmt = con.createStatement();
                        try {
                            ResultSet rs = stmt.executeQuery("SELECT cd_id FROM " + tableName + " " + where);
                            try {
                                int x;
                                PreparedStatement[] ps = new PreparedStatement[mdTables.length];
                                for (x = 0; x < mdTables.length; ++x) {
                                    String sql2 = "DELETE FROM " + mdTables[x] + " WHERE cd_id=?";
                                    ps[x] = con.prepareStatement(sql2);
                                }
                                while (rs.next()) {
                                    int id = rs.getInt(1);
                                    for (int x2 = 0; x2 < ps.length; ++x2) {
                                        ps[x2].setInt(1, id);
                                        ps[x2].execute();
                                    }
                                }
                                for (x = 0; x < ps.length; ++x) {
                                    ps[x].close();
                                }
                                break block32;
                            }
                            finally {
                                rs.close();
                            }
                        }
                        finally {
                            stmt.close();
                        }
                    }
                    for (int x = 0; x < mdTables.length; ++x) {
                        sql = "DELETE FROM " + mdTables[x];
                        Statement stmt = con.createStatement();
                        try {
                            stmt.execute(sql);
                            continue;
                        }
                        finally {
                            stmt.close();
                        }
                    }
                }
            }
            Statement stmt = con.createStatement();
            try {
                sql = "DELETE FROM " + tableName + " " + where;
                stmt.execute(sql);
            }
            finally {
                stmt.close();
            }
            if (isLoggingEnabled) {
                String updateString = null;
                updateString = singleRow ? "Deleted:" + cd_id : "Deletes";
                UpdateHandler.storeUpdate(conh, updateString, dbms, tableName, null, UpdateHandler.getRegisteredCaches(conh));
            }
            if (toCommit && dbms != 7) {
                con.commit();
                try {
                    con.setAutoCommit(true);
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException e) {
            if (toCommit && dbms != 7) {
                try {
                    con.rollback();
                    con.setAutoCommit(true);
                }
                catch (SQLException e2) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static String[] getStructureTables(ConnectionHandler conh) throws SQLException {
        Vector<String> tables = new DatabaseProperties(conh, false).getStructureTableNames();
        String[] ret = new String[tables.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = tables.elementAt(i);
        }
        return ret;
    }

    public static void createStructureTable(ConnectionHandler conh, StructureTableOptions options) throws SQLException {
        TableInfo.createTable(conh, options);
    }

    public static void dropStructureTable(ConnectionHandler conh, String tableName) throws SQLException {
        tableName = TableInfo.getTableNameWithSchema(conh.getConnection(), tableName);
        TableInfo.deleteTable(conh, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePostgreSequence() throws SQLException {
        int cd_id = (Integer)this.fields[0].value;
        int curr_id = 0;
        Statement stmt = this.con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT currval('" + this.tableName + "_cd_id_seq')");
            try {
                rs.next();
                curr_id = rs.getInt(1);
            }
            finally {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            if (curr_id < cd_id) {
                stmt.execute("SELECT setval('" + this.tableName + "_cd_id_seq', " + cd_id + ")");
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getSmilesSize(Connection con, String tableName) throws SQLException {
        int size;
        Statement stmt = con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT cd_smiles FROM " + tableName + " WHERE 1=2");
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                size = rsmd.getColumnDisplaySize(1);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return size;
    }

    public static boolean recalculateTable(ConnectionHandler ch, String tableName, boolean changeStandardization, String standardizerConfig, Map chemTermColCfg, Boolean tautomerDuplicateFiltering, ProgressWriter pw) throws UpdateHandlerException {
        return UpdateHandler.recalculateTable(ch, tableName, changeStandardization, standardizerConfig, chemTermColCfg, tautomerDuplicateFiltering, pw, 0);
    }

    public static boolean recalculateTable(ConnectionHandler ch, String tableName, boolean changeStandardization, String standardizerConfig, Map chemTermColCfg, Boolean tautomerDuplicateFiltering, ProgressWriter pw, int regenerationMode) throws UpdateHandlerException {
        int dbms = DatabaseOptions.getDBMSType(ch);
        int threads = 0;
        if (dbms == 4) {
            threads = 1;
        }
        try {
            Regenerator regen = new Regenerator(ch, tableName, changeStandardization, standardizerConfig, chemTermColCfg, tautomerDuplicateFiltering, pw, threads, chemTermColCfg != null, regenerationMode);
            regen.run();
            return !regen.wasError;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UpdateHandlerException(e);
        }
    }

    public static boolean recalculateCTColumns(ConnectionHandler ch, String tableName, String[] columns, ProgressWriter pw) throws UpdateHandlerException {
        return UpdateHandler.recalculateCTColumns(ch, tableName, columns, pw, 0);
    }

    public static boolean recalculateCTColumns(ConnectionHandler ch, String tableName, String[] columns, ProgressWriter pw, int regenerationMode) throws UpdateHandlerException {
        int dbms = DatabaseOptions.getDBMSType(ch);
        int threads = 0;
        if (dbms == 4) {
            threads = 1;
        }
        try {
            CTColumnRegenerator ctRegen = new CTColumnRegenerator(ch, tableName, columns, pw, threads, regenerationMode);
            ctRegen.run();
            return !ctRegen.wasError;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UpdateHandlerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean recalculateMDTables(ConnectionHandler ch, String tableName, ProgressWriter pw) throws UpdateHandlerException, SQLException {
        MDRegenerator mdRegen = new MDRegenerator(ch, pw);
        try {
            if (tableName == null) {
                mdRegen.run();
            } else {
                mdRegen.run(tableName);
            }
            boolean bl = !mdRegen.wasError;
            return bl;
        }
        finally {
            mdRegen.close();
        }
    }

    public static boolean recalculateWithoutCTColumns(ConnectionHandler ch, String tableName, boolean changeStandardization, String standardizerConfig, Boolean tautomerDuplicateFiltering, ProgressWriter pw) throws UpdateHandlerException {
        return UpdateHandler.recalculateWithoutCTColumns(ch, tableName, changeStandardization, standardizerConfig, tautomerDuplicateFiltering, pw, 2);
    }

    public static boolean recalculateWithoutCTColumns(ConnectionHandler ch, String tableName, boolean changeStandardization, String standardizerConfig, Boolean tautomerDuplicateFiltering, ProgressWriter pw, int regenerationMode) throws UpdateHandlerException {
        int dbms = DatabaseOptions.getDBMSType(ch);
        int threads = 0;
        if (dbms == 4) {
            threads = 1;
        }
        try {
            Regenerator regen = new Regenerator(ch, tableName, changeStandardization, standardizerConfig, null, tautomerDuplicateFiltering, pw, threads, false, regenerationMode);
            regen.run();
            return !regen.wasError;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UpdateHandlerException(e);
        }
    }

    public RowData createRowData(String molString) throws UpdateHandlerException, MolFormatException {
        try {
            return this.createRowData(molString.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public RowData createRowData(byte[] molString) throws UpdateHandlerException, MolFormatException {
        this.structure = molString;
        this.init();
        RowData rd = new RowData();
        this.rowData = null;
        rd.molString = this.structure;
        rd.smiles = this.smiles;
        rd.formula = this.formula;
        rd.sortableFormula = this.sortableFormula;
        rd.molWeight = this.molWeight;
        rd.hashCode = this.hash;
        rd.flags = this.flags;
        rd.fingerprint = this.fingerprint;
        rd.isMarkush = this.isMarkush;
        rd.noRingInfoInFP = this.noRingInfoInFP;
        rd.reactionMappingIncomplete = this.reactionMappingIncomplete;
        RowData.access$002(rd, this.markushData);
        rd.molecule = this.mol;
        rd.chemTermColValues = this.chemTermColValues;
        rd.genericTautomer = this.genericTautomer;
        rd.molName = this.molName;
        return rd;
    }

    public void setRowData(RowData rowData) throws SQLException {
        this.rowData = rowData;
    }

    public void setChemTermCalc(boolean isCalcNeeded) {
        this.chemTermCalcNeeded = isCalcNeeded;
    }

    void setTempTableToWrite(String tempTableName) {
        this.tempTableToWrite = tempTableName;
    }

    static boolean flagsIndicateNoRingInfoInFP(String flags) {
        return flags != null && (flags.indexOf(114) != -1 || flags.indexOf(109) != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetPreCalculatedValues(ConnectionHandler conh, String tableName) throws SQLException {
        Statement stmt = conh.getConnection().createStatement();
        try {
            stmt.executeUpdate("UPDATE " + tableName + " SET " + "cd_pre_calculated" + " = 0");
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setPreCalculated(ConnectionHandler conh, String tableName, int cdId, boolean value) throws SQLException {
        Statement stmt = conh.getConnection().createStatement();
        try {
            stmt.executeUpdate("UPDATE " + tableName + " SET " + "cd_pre_calculated" + " = " + (value ? "1" : "0") + " WHERE " + "cd_id" + "=" + cdId);
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPrecalculatedRowNumber(ConnectionHandler conh, String tableName) throws SQLException {
        int number = 0;
        String sql = "SELECT COUNT(*) FROM " + tableName + " WHERE " + "cd_pre_calculated" + " = 1";
        Statement stmt = conh.getConnection().createStatement();
        try {
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (rs.next()) {
                    number = rs.getInt(1);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return number;
    }

    public static class RowData {
        public byte[] molString = null;
        public int[] fingerprint = null;
        public int hashCode = 0;
        public Double molWeight = null;
        public String formula = null;
        public String sortableFormula = null;
        public String smiles = null;
        public MolRecord molRecord = null;
        public boolean isMarkush = false;
        public boolean noRingInfoInFP = false;
        public boolean reactionMappingIncomplete = false;
        private byte[] markushData = null;
        public Molecule molecule = null;
        public Map<String, Object> chemTermColValues = null;
        public Molecule genericTautomer = null;
        public String flags = "";
        public String molName = "";

        public byte[] getMarkushData() {
            return this.markushData;
        }

        static /* synthetic */ byte[] access$002(RowData x0, byte[] x1) {
            x0.markushData = x1;
            return x1;
        }
    }

    class AdditionalColumn {
        String name;
        int forcedType = 0;
        Object value = null;

        AdditionalColumn() {
        }
    }

    class ActiveFieldList
    extends ArrayList {
        ActiveFieldList() {
        }

        @Override
        public boolean add(Object o) {
            if (this.contains(o)) {
                throw new IllegalArgumentException("Error: attempted to add a field twice to active field list: " + ((Field)o).name);
            }
            return super.add(o);
        }
    }

    class Field {
        String name;
        int type;
        Object value;
        boolean bigLOB;
        public int forcedType;

        Field() {
        }
    }
}

