/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db;

import chemaxon.jchem.db.UpdateHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class UpdateHandlerOracle {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Clob getCLOB(Connection con, String clobData) throws SQLException {
        CLOB tempClob = null;
        try {
            tempClob = CLOB.createTemporary((Connection)con, (boolean)true, (int)10);
            tempClob.open(1);
            Writer tempClobWriter = tempClob.getCharacterOutputStream();
            tempClobWriter.write(clobData);
            tempClobWriter.flush();
            tempClobWriter.close();
            tempClob.close();
        }
        catch (Exception e) {
            try {
                tempClob.freeTemporary();
            }
            finally {
                throw new SQLException(e.getMessage(), e);
            }
        }
        return tempClob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBigLOBs(Connection con, ArrayList bigLOBs, String tableName, int id) throws SQLException, IOException {
        Connection retrievedConnection = null;
        do {
            if (retrievedConnection == null) continue;
            con = retrievedConnection;
        } while ((retrievedConnection = con.getMetaData().getConnection()) != con);
        boolean prevAutoCommit = con.getAutoCommit();
        con.setAutoCommit(false);
        boolean success = true;
        Statement stmt = con.createStatement();
        try {
            String sql = "select ";
            int count = 0;
            for (int x = 0; x < bigLOBs.size(); ++x) {
                UpdateHandler.Field field = (UpdateHandler.Field)bigLOBs.get(x);
                if (count++ != 0) {
                    sql = sql + ",";
                }
                sql = sql + field.name;
            }
            sql = sql + " from " + tableName + " where cd_id=" + id + " for update";
            ResultSet rs = stmt.executeQuery(sql);
            try {
                if (rs.next()) {
                    for (int x = 0; x < bigLOBs.size(); ++x) {
                        UpdateHandler.Field field = (UpdateHandler.Field)bigLOBs.get(x);
                        OutputStream outstream = null;
                        if (field.type == 2005) {
                            CLOB clob = ((OracleResultSet)rs).getCLOB(x + 1);
                            Writer writer = clob.getCharacterOutputStream();
                            String str = null;
                            if (field.value instanceof byte[]) {
                                str = new String((byte[])field.value, "ASCII");
                                writer.write(str, 0, str.length());
                            } else if (field.value instanceof String) {
                                str = (String)field.value;
                                writer.write(str, 0, str.length());
                            } else if (field.value instanceof Clob) {
                                Clob clobVal = (Clob)field.value;
                                Reader reader = clobVal.getCharacterStream();
                                int read = 0;
                                char[] buffer = new char[4096];
                                while ((read = reader.read(buffer)) != -1) {
                                    writer.write(buffer, 0, read);
                                }
                            }
                            writer.flush();
                            writer.close();
                            continue;
                        }
                        BLOB blob = ((OracleResultSet)rs).getBLOB(x + 1);
                        outstream = blob.getBinaryOutputStream();
                        byte[] bytes = null;
                        bytes = field.value instanceof String ? ((String)field.value).getBytes("ASCII") : (byte[])field.value;
                        outstream.write(bytes);
                        outstream.flush();
                        outstream.close();
                    }
                } else {
                    success = false;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        if (prevAutoCommit) {
            con.setAutoCommit(true);
        }
        if (!success) {
            throw new SQLException("ERROR: JChem could not set LOB values in table " + tableName + " cd_id=" + id);
        }
    }
}

