/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.cdmarkush;

import chemaxon.struc.Molecule;
import chemaxon.util.Compression;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class CDMarkushFromDBUtil {
    public static Molecule deserialize(byte[] source, int start) throws IllegalArgumentException {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(source, start, source.length - start));
            Molecule mol = (Molecule)ois.readObject();
            ois.close();
            return mol;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Corrupted data.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Markush molecule could be read.", e);
        }
    }

    public static byte[] decompress(byte[] source, int start) throws IllegalArgumentException {
        return Compression.decompress(source, start, source.length - start);
    }
}

