/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.cdmarkush.serializer;

import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.db.cdmarkush.CDMarkushFromDB;
import chemaxon.jchem.db.cdmarkush.CDMarkushFromDBUtil;
import chemaxon.jchem.db.cdmarkush.CDMarkushUtil;
import chemaxon.jchem.db.cdmarkush.serializer.CDMarkushSerializer;
import chemaxon.marvin.io.formats.MoleculeImporter;
import chemaxon.marvin.io.formats.MoleculeImporterIface;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class CDMarkushSerializerFromDB
implements CDMarkushFromDB {
    private static final Logger logger = Logger.getLogger(CDMarkushSerializerFromDB.class.getName());
    private final CDMarkushSerializer.Compression compression;
    private final CDMarkushSerializer.Serialization serialization;
    private final CDMarkushSerializer.SupergraphSaving supergraphSaving;
    private final byte[] magic;
    private final CDMarkushUtil.MarkushCode code;
    private final byte[] data;
    private Molecule markush = null;
    private Supergraph supergraph = null;

    public CDMarkushSerializerFromDB(byte[] data, byte[] magic, CDMarkushSerializer.Compression compression, CDMarkushSerializer.Serialization serialization, CDMarkushSerializer.SupergraphSaving supergraphSaving) throws IllegalArgumentException {
        if (!CDMarkushUtil.checkMagicBytes(data, magic)) {
            throw new IllegalArgumentException("Incompatible data, prefix is: " + CDMarkushUtil.toString(data, magic.length) + " instead of: " + CDMarkushUtil.toString(magic));
        }
        this.data = data;
        this.magic = magic;
        this.code = CDMarkushUtil.MarkushCode.valueOf(data[magic.length]);
        this.compression = compression;
        this.serialization = serialization;
        this.supergraphSaving = supergraphSaving;
    }

    @Override
    public boolean isSearchable() {
        return this.code != CDMarkushUtil.MarkushCode.UNSEARCHABLE;
    }

    @Override
    public Molecule getMarkush() throws IllegalArgumentException {
        if (this.markush == null) {
            if (this.isSearchable()) {
                this.markush = this.createMarkush(this.data);
            } else {
                logger.severe("Unsearchable Markush is not stored in cd_markush.");
                throw new IllegalArgumentException("Unsearchable Markush is not stored in cd_markush.");
            }
        }
        return this.markush;
    }

    @Override
    public Supergraph getSupergraph() throws IllegalArgumentException {
        if (this.supergraph == null) {
            if (this.isSearchable()) {
                this.supergraph = this.createSupergraph(this.getMarkush());
            } else {
                logger.severe("Supergraph cannot be created for unsearchable Markush.");
                throw new IllegalArgumentException("Supergraph cannot be created for unsearchable Markush.");
            }
        }
        return this.supergraph;
    }

    private Molecule createMarkush(byte[] source) throws IllegalArgumentException {
        int start = this.magic.length + 1;
        if (this.compression == CDMarkushSerializer.Compression.GZIP) {
            source = CDMarkushFromDBUtil.decompress(source, start);
            start = 0;
        }
        if (this.serialization == CDMarkushSerializer.Serialization.MRV || this.serialization == CDMarkushSerializer.Serialization.OLDMRV) {
            MoleculeImporterIface importer = null;
            try {
                importer = this.serialization == CDMarkushSerializer.Serialization.MRV ? new MoleculeImporter(new ByteArrayInputStream(source, start, source.length - start)) : new MolImporter(new ByteArrayInputStream(source, start, source.length - start));
                Molecule molecule = importer.read();
                return molecule;
            }
            catch (MolFormatException e) {
                throw new IllegalArgumentException("Could not read Markush.", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read Markush.", e);
            }
            finally {
                try {
                    importer.close();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read Markush.", e);
                }
            }
        }
        return CDMarkushFromDBUtil.deserialize(source, start);
    }

    private Supergraph createSupergraph(Molecule mol) throws IllegalArgumentException {
        try {
            if (this.supergraphSaving == CDMarkushSerializer.SupergraphSaving.YES) {
                Supergraph sg = new Supergraph();
                sg.loadStructure(mol);
                return sg;
            }
            return new Supergraph(mol);
        }
        catch (SupergraphException e) {
            throw new IllegalArgumentException("Could not create Supergraph.", e);
        }
    }
}

