/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.cdmarkush.serializer;

import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphException;
import chemaxon.formats.MolExporter;
import chemaxon.jchem.db.cdmarkush.CDMarkushToDB;
import chemaxon.jchem.db.cdmarkush.CDMarkushToDBUtil;
import chemaxon.jchem.db.cdmarkush.CDMarkushUtil;
import chemaxon.jchem.db.cdmarkush.serializer.CDMarkushSerializer;
import chemaxon.sss.screen.CombinedFingerprint;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.logging.Logger;

public class CDMarkushSerializerToDB
implements CDMarkushToDB {
    private static final Logger logger = Logger.getLogger(CDMarkushSerializerToDB.class.getName());
    private final CDMarkushSerializer.Compression compression;
    private final CDMarkushSerializer.Serialization serialization;
    private final CDMarkushSerializer.SupergraphSaving supergraphSaving;
    private final Molecule structure;
    private final byte[] magic;
    private final CDMarkushUtil.MarkushCode code;
    private byte[] data = null;
    private int[][] fingerprints = null;
    private Supergraph supergraph = null;

    public CDMarkushSerializerToDB(Molecule structure, byte[] magic, CDMarkushSerializer.Compression compression, CDMarkushSerializer.Serialization serialization, CDMarkushSerializer.SupergraphSaving supergraphSaving) {
        this.structure = structure;
        this.magic = magic;
        this.compression = compression;
        this.serialization = serialization;
        this.supergraphSaving = supergraphSaving;
        this.code = CDMarkushUtil.calcMarkushCode(structure);
    }

    private boolean isSearchable() {
        return this.code != CDMarkushUtil.MarkushCode.UNSEARCHABLE;
    }

    @Override
    public final byte[] getData() throws IllegalArgumentException {
        if (this.data == null) {
            byte[] d;
            if (this.isSearchable()) {
                if (this.supergraph == null && this.supergraphSaving == CDMarkushSerializer.SupergraphSaving.YES) {
                    this.supergraph = CDMarkushSerializerToDB.createSupergraph(this.structure);
                }
                Molecule m = null;
                if (this.supergraphSaving == CDMarkushSerializer.SupergraphSaving.YES) {
                    try {
                        m = this.supergraph.saveStructure();
                    }
                    catch (SupergraphException e) {
                        throw new IllegalArgumentException("Error: could not save data in Markush structure.", e);
                    }
                } else {
                    m = this.structure;
                }
                if (this.serialization == CDMarkushSerializer.Serialization.MRV || this.serialization == CDMarkushSerializer.Serialization.OLDMRV) {
                    try {
                        d = MolExporter.exportToBinFormat(m, "mrv");
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Error: could not save Markush structure in MRV format.", e);
                    }
                } else {
                    d = CDMarkushToDBUtil.serialize(m);
                }
                if (this.compression == CDMarkushSerializer.Compression.GZIP) {
                    d = CDMarkushToDBUtil.compress(d);
                }
            } else {
                logger.warning("Unsearchable structure: " + this.structure.getName());
                d = new byte[]{};
            }
            this.data = d;
        }
        return CDMarkushUtil.prependMagicBytes(this.data, this.magic, this.code);
    }

    @Override
    public int[][] calcFingerprints(CombinedFingerprint cfp) throws IllegalArgumentException {
        if (this.fingerprints == null) {
            if (this.isSearchable()) {
                if (this.supergraph == null) {
                    this.supergraph = CDMarkushSerializerToDB.createSupergraph(this.structure);
                }
                this.fingerprints = cfp.getCombinedFingerprints(this.supergraph, null, false, false, true, false);
            } else {
                this.fingerprints = cfp.getBlackFingerprints();
            }
        }
        return this.fingerprints;
    }

    private static Supergraph createSupergraph(Molecule mol) throws IllegalArgumentException {
        try {
            return new Supergraph(mol);
        }
        catch (SupergraphException e) {
            throw new IllegalArgumentException("Error: could create Supergraph.", e);
        }
    }
}

