/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.create;

import chemaxon.jchem.db.create.DataType;
import chemaxon.jchem.db.create.FieldDescriptor;
import chemaxon.jchem.db.create.IntegerEditor;
import chemaxon.jchem.db.create.TableDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SQLStatementTable
extends JPanel {
    public static final int NAME = 0;
    public static final int TYPE = 1;
    public static final int NULL_ALLOWED = 2;
    public static final int INDEXED = 3;
    public static final int SIZE = 4;
    public static final int SCALE = 5;
    public static final int DEFAULT_VALUE = 6;
    private static final int COLUMN_COUNT = 7;
    private TableDescriptor descriptor;
    private JTable table;
    private MyTableModel model;

    public SQLStatementTable(TableDescriptor tableDescriptor) throws IOException {
        super(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.descriptor = tableDescriptor;
        this.table = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                boolean indexable = true;
                if (column == 3) {
                    indexable = (Boolean)SQLStatementTable.this.model.getTableValueAt(row, column);
                }
                if (SQLStatementTable.this.model.isEditableValue(row, column) && indexable) {
                    c.setForeground(Color.BLACK);
                    if (SQLStatementTable.this.model.isBooleanColumn(column)) {
                        ((JCheckBox)c).setEnabled(true);
                    }
                } else {
                    c.setForeground(Color.LIGHT_GRAY);
                    if (SQLStatementTable.this.model.isBooleanColumn(column)) {
                        ((JCheckBox)c).setEnabled(false);
                    }
                }
                return c;
            }
        };
        this.model = new MyTableModel();
        this.table.setModel(this.model);
        this.table.addKeyListener(new MyKeyListener());
        this.table.sizeColumnsToFit(0);
        this.checkForComboBoxColumns();
        this.table.getColumnModel().getColumn(4).setCellEditor(new IntegerEditor(this.model.getSizeMin(), this.model.getSizeMax(), this.table, this.descriptor));
        this.table.getColumnModel().getColumn(5).setCellEditor(new IntegerEditor(this.model.getScaleMin(), this.model.getScaleMax(), this.table, this.descriptor));
        this.packColumns(2);
        this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredScrollableViewportSize().width, this.table.getRowHeight() * this.table.getRowCount()));
        JScrollPane scrollPane = new JScrollPane(this.table);
        c.fill = 1;
        c.weightx = 0.9;
        c.weighty = 0.9;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)scrollPane, c);
        JButton insertRowButton = new JButton();
        insertRowButton.setText("Insert row");
        insertRowButton.setToolTipText("Insert row above the selected rows");
        insertRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLStatementTable.this.insertRowButtonActionPerformed();
            }
        });
        c.fill = 0;
        c.gridwidth = 1;
        c.ipady = 0;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 0.1;
        c.weighty = 0.1;
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)insertRowButton, c);
        JButton deleteRowButton = new JButton();
        deleteRowButton.setText("Delete rows");
        deleteRowButton.setToolTipText("Delete the selected rows");
        deleteRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLStatementTable.this.deleteRowButtonActionPerformed();
            }
        });
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)deleteRowButton, c);
    }

    private void insertRowButtonActionPerformed() {
        this.insertAfterSelectedRows();
    }

    private void deleteRowButtonActionPerformed() {
        this.deleteSelectedRows();
    }

    private void insertAfterSelectedRows() {
        int count = this.table.getSelectedRowCount();
        if (count > 0) {
            int[] rows = this.table.getSelectedRows();
            ((MyTableModel)this.table.getModel()).insertRow(rows[count - 1] + 1);
        }
    }

    private void deleteSelectedRows() {
        int count = this.table.getSelectedRowCount();
        if (count > 0) {
            int[] rows = this.table.getSelectedRows();
            ((MyTableModel)this.table.getModel()).removeRowSelectionInterval(rows[0], rows[count - 1]);
        }
    }

    private void checkForComboBoxColumns() {
        TableColumn col = this.table.getColumnModel().getColumn(1);
        col.setCellRenderer(new MyComboBoxRenderer());
        col.setCellEditor(new MyTableCellEditor());
    }

    private void packColumns(int margin) {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.packColumn(i, margin);
        }
    }

    private void packColumn(int vColIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)this.table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < this.table.getRowCount(); ++r) {
            renderer = this.table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    private DataType findTypeByName(ArrayList list, String name) {
        for (int i = 0; i < list.size(); ++i) {
            if (((DataType)list.get(i)).getName() != name) continue;
            return (DataType)list.get(i);
        }
        return null;
    }

    public void printData() {
        this.descriptor.print();
    }

    private class MyTableModel
    extends AbstractTableModel {
        public String[] columnNames = new String[]{"Field Name", "Data Type", "Null Allowed", "Indexed", "Size", "Scale", "Default Value"};
        private int sizeMin = 0;
        private int sizeMax = 10;
        private int scaleMin = 0;
        private int scaleMax = 10;

        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public int getRowCount() {
            return SQLStatementTable.this.descriptor.fieldCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < SQLStatementTable.this.descriptor.fieldCount() && col < this.columnCount()) {
                return this.getTableValueAt(row, col);
            }
            return null;
        }

        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) == null) {
                return "".getClass();
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this.isEditableValue(row, col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row < SQLStatementTable.this.descriptor.fieldCount() && col < this.columnCount()) {
                this.setTableValueAt(value, row, col);
                this.fireTableDataChanged();
            }
        }

        public void insertRow(int index) {
            FieldDescriptor emptyRow = new FieldDescriptor();
            emptyRow.setFixField(false);
            emptyRow.addAllowedTypes(SQLStatementTable.this.descriptor.getDataTypes());
            if (SQLStatementTable.this.descriptor.getDataTypes().size() > 0) {
                emptyRow.setType((DataType)SQLStatementTable.this.descriptor.getDataTypes().get(0));
                emptyRow.setScale(emptyRow.getType().getDefaultScale());
                emptyRow.setSize(emptyRow.getType().getDefaultSize());
            }
            SQLStatementTable.this.descriptor.addField(emptyRow);
            this.fireTableRowsInserted(index, index);
        }

        public void removeRowSelectionInterval(int fromIndex, int toIndex) {
            for (int i = toIndex; i >= fromIndex; --i) {
                ArrayList field = SQLStatementTable.this.descriptor.getFields();
                if (((FieldDescriptor)field.get(i)).isFixField()) continue;
                SQLStatementTable.this.descriptor.removeField(i);
                this.fireTableRowsDeleted(i, i);
            }
        }

        public boolean isEditableValue(int row, int col) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)SQLStatementTable.this.descriptor.getFields().get(row);
            switch (col) {
                case 0: {
                    return fieldDescriptor.isNameEditable();
                }
                case 1: {
                    return fieldDescriptor.isTypeEditable();
                }
                case 2: {
                    return fieldDescriptor.isNullAllowedEditable();
                }
                case 6: {
                    return fieldDescriptor.isDefaultValueEditable();
                }
                case 3: {
                    return fieldDescriptor.isIndexedEditable();
                }
                case 4: {
                    return fieldDescriptor.isSizeEditable();
                }
                case 5: {
                    return fieldDescriptor.isScaleEditable();
                }
            }
            return false;
        }

        public Object getTableValueAt(int row, int col) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)SQLStatementTable.this.descriptor.getFields().get(row);
            switch (col) {
                case 0: {
                    return fieldDescriptor.getName();
                }
                case 1: {
                    return fieldDescriptor.getType().getName();
                }
                case 2: {
                    return new Boolean(fieldDescriptor.getNullAllowed());
                }
                case 6: {
                    return fieldDescriptor.getDefaultValue();
                }
                case 3: {
                    return new Boolean(fieldDescriptor.getIndexed());
                }
                case 4: {
                    return new Integer(fieldDescriptor.getSize());
                }
                case 5: {
                    return new Integer(fieldDescriptor.getScale());
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int columnCount() {
            return 7;
        }

        public void setTableValueAt(Object value, int row, int col) {
            FieldDescriptor fieldDescriptor = (FieldDescriptor)SQLStatementTable.this.descriptor.getFields().get(row);
            switch (col) {
                case 0: {
                    String newName = new String((String)value);
                    fieldDescriptor.setName(newName);
                    break;
                }
                case 1: {
                    ArrayList allowedTypes = fieldDescriptor.getAllowedTypes();
                    for (int i = 0; i < allowedTypes.size(); ++i) {
                        if (((DataType)allowedTypes.get(i)).getName() != value) continue;
                        fieldDescriptor.setType((DataType)allowedTypes.get(i));
                    }
                    if (!fieldDescriptor.getType().isIndexable()) {
                        fieldDescriptor.setIndexed(false);
                        fieldDescriptor.setIndexedEditable(false);
                    } else {
                        fieldDescriptor.setIndexedEditable(true);
                    }
                    fieldDescriptor.setScale(fieldDescriptor.getType().getDefaultScale());
                    fieldDescriptor.setSize(fieldDescriptor.getType().getDefaultSize());
                    break;
                }
                case 2: {
                    fieldDescriptor.setNullAllowed((Boolean)value);
                    break;
                }
                case 6: {
                    String newDefaultValue = new String((String)value);
                    fieldDescriptor.setDefaultValue(newDefaultValue);
                    break;
                }
                case 3: {
                    fieldDescriptor.setIndexed((Boolean)value);
                    break;
                }
                case 4: {
                    fieldDescriptor.setSize((Integer)value);
                    break;
                }
                case 5: {
                    fieldDescriptor.setScale((Integer)value);
                    break;
                }
            }
        }

        public int getScaleMax() {
            return this.scaleMax;
        }

        public void setScaleMax(int scaleMax) {
            this.scaleMax = scaleMax;
        }

        public int getScaleMin() {
            return this.scaleMin;
        }

        public void setScaleMin(int scaleMin) {
            this.scaleMin = scaleMin;
        }

        public int getSizeMax() {
            return this.sizeMax;
        }

        public void setSizeMax(int sizeMax) {
            this.sizeMax = sizeMax;
        }

        public int getSizeMin() {
            return this.sizeMin;
        }

        public void setSizeMin(int sizeMin) {
            this.sizeMin = sizeMin;
        }

        public boolean isBooleanColumn(int column) {
            return column == 3 || column == 2;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public void setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
        }
    }

    private class MyTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox editorComboBox = new JComboBox();

        public MyTableCellEditor() {
            this.editorComboBox.addActionListener(new ComboBoxAction());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ArrayList allowedTypes = SQLStatementTable.this.descriptor.getAllowedDataTypes(row);
            if (SQLStatementTable.this.model.isEditableValue(row, column)) {
                this.editorComboBox.removeAllItems();
                for (int i = 0; i < allowedTypes.size(); ++i) {
                    this.editorComboBox.addItem(((DataType)allowedTypes.get(i)).getName());
                }
                this.editorComboBox.setSelectedItem(SQLStatementTable.this.model.getTableValueAt(row, column));
            }
            return this.editorComboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorComboBox.getSelectedItem();
        }

        private class ComboBoxAction
        implements ActionListener {
            private ComboBoxAction() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                int row = SQLStatementTable.this.table.getSelectedRow();
                if (row > 0) {
                    FieldDescriptor fieldDescriptor = (FieldDescriptor)SQLStatementTable.this.descriptor.getFields().get(row);
                    if (!fieldDescriptor.getType().isIndexable()) {
                        fieldDescriptor.setIndexed(false);
                        SQLStatementTable.this.model.fireTableCellUpdated(row, 3);
                        fieldDescriptor.setIndexedEditable(false);
                    } else {
                        fieldDescriptor.setIndexedEditable(true);
                    }
                    DataType dataType = SQLStatementTable.this.findTypeByName(SQLStatementTable.this.descriptor.getDataTypes(), (String)MyTableCellEditor.this.editorComboBox.getSelectedItem());
                    if (dataType != null) {
                        fieldDescriptor.setScale(dataType.getDefaultScale());
                        SQLStatementTable.this.model.fireTableCellUpdated(row, 5);
                        fieldDescriptor.setSize(dataType.getDefaultSize());
                        SQLStatementTable.this.model.fireTableCellUpdated(row, 4);
                    }
                }
            }
        }
    }

    private class MyComboBoxRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(Color.WHITE);
            super.setText((String)SQLStatementTable.this.model.getTableValueAt(row, column));
            return this;
        }
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 127) {
                SQLStatementTable.this.deleteSelectedRows();
            }
            if (evt.getKeyCode() == 155) {
                SQLStatementTable.this.insertAfterSelectedRows();
            }
        }
    }
}

