/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.db.create;

import chemaxon.jchem.db.create.SQLStatementTable;
import chemaxon.jchem.db.create.TableDescriptor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class SQLStatementTableDialog
extends JDialog {
    public static final int RETURN_CANCEL = 0;
    public static final int RETURN_OK = 1;
    private int returnStatus = 0;
    private SQLStatementTable sqlTable;

    public SQLStatementTableDialog(JFrame owner, boolean modal, TableDescriptor descriptor) throws IOException {
        super(owner, descriptor.getName(), modal);
        this.initComponents(descriptor);
        this.pack();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents(TableDescriptor descriptor) throws IOException {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SQLStatementTableDialog.this.closeDialog();
            }
        });
        Container pane = this.getContentPane();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.sqlTable = new SQLStatementTable(descriptor);
        this.sqlTable.setToolTipText("SQL statement table for table creation. Add new columns if needed");
        c.fill = 1;
        c.weightx = 0.9;
        c.weighty = 0.9;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        pane.add((Component)this.sqlTable, c);
        JButton okButton = new JButton();
        okButton.setText("Ok");
        okButton.setToolTipText("Accept SQL statement");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLStatementTableDialog.this.okButtonActionPerformed();
            }
        });
        c.fill = 0;
        c.gridwidth = 1;
        c.ipady = 0;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 0.1;
        c.weighty = 0.1;
        c.gridx = 0;
        c.gridy = 1;
        pane.add((Component)okButton, c);
        c.gridx = 1;
        c.gridy = 1;
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLStatementTableDialog.this.cancelButtonActionPerformed();
            }
        });
        pane.add((Component)cancelButton, c);
        JButton editSQLButton = new JButton();
        editSQLButton.setText("Edit SQL");
        editSQLButton.setToolTipText("Edit SQL statement");
        editSQLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLStatementTableDialog.this.editSQLButtonActionPerformed();
            }
        });
        c.gridx = 2;
        c.gridy = 1;
        pane.add((Component)editSQLButton, c);
    }

    private void okButtonActionPerformed() {
        this.sqlTable.printData();
        this.doClose(1);
    }

    private void cancelButtonActionPerformed() {
        this.doClose(0);
    }

    private void editSQLButtonActionPerformed() {
    }

    private void closeDialog() {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

