/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.file;

import chemaxon.jchem.db.Transfer;
import java.io.File;
import java.util.Vector;

public class FileInfo
implements Transfer {
    int format = 2;
    String formatString = null;
    String fileName = null;
    public Vector<String> fieldNames = new Vector();

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFormat(int format2) {
        this.format = format2;
    }

    public int getFormat() {
        return this.format;
    }

    public static int getFormat(String filename) {
        String s = filename.toLowerCase();
        String type = s.substring(s.lastIndexOf(".") + 1);
        int format2 = -1;
        if (type.startsWith("smi")) {
            format2 = 3;
        } else if (type.startsWith("cxsmi")) {
            format2 = 12;
        } else if (type.startsWith("sma")) {
            format2 = 11;
        } else if (type.startsWith("cxsma")) {
            format2 = 13;
        } else if (type.startsWith("mol2")) {
            format2 = 8;
        } else if (type.startsWith("mol")) {
            format2 = 1;
        } else if (type.startsWith("jtf")) {
            format2 = 4;
        } else if (type.startsWith("sd")) {
            format2 = 2;
        } else if (type.startsWith("rd")) {
            format2 = 5;
        } else if (type.startsWith("mrv")) {
            format2 = 6;
        } else if (type.startsWith("rxn")) {
            format2 = 7;
        } else if (type.startsWith("inchi")) {
            format2 = 9;
        } else if (type.startsWith("vmn")) {
            format2 = 10;
        }
        return format2;
    }

    public static boolean isSmilesFormat(int format2) {
        return format2 == 3 || format2 == 12 || format2 == 11 || format2 == 13;
    }

    public static int getFormat(File file) {
        return FileInfo.getFormat(file.getName());
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
        if (formatString != null) {
            this.setFormat(FileInfo.getFormat(formatString));
        }
    }

    public String getFormatString() {
        return this.formatString;
    }
}

