/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.file;

import java.util.ArrayList;

public class ProgressWriter {
    private ArrayList loggerList = new ArrayList();
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private long T0;
    private long tExp = 0L;
    private long v;
    private long remSeconds;
    private long remMinutes;
    private long remHours;
    private long remDays;
    long days;
    long hours;
    long minutes;
    long seconds;
    private String tExpText = " ";
    protected long min;
    protected long max;
    protected String text = "";
    protected String note;
    private boolean canceled = false;

    public void addLogger(Logger logger) {
        this.loggerList.add(logger);
    }

    public void log(int severity, String message, Throwable t) {
        if (this.loggerList.size() == 0) {
            System.err.println(message);
            if (t != null) {
                t.printStackTrace();
            }
        } else {
            for (Logger logger : this.loggerList) {
                logger.addMessage(severity, message, t);
            }
        }
    }

    public ProgressWriter(String note, long min, long max) {
        this.min = min;
        this.max = max;
        this.v = min;
        this.note = note;
        this.T0 = System.currentTimeMillis();
    }

    public long getProgress() {
        return this.v;
    }

    public void setProgress(long nv) {
        this.v = nv;
        if (this.v <= this.min || this.v >= this.max) {
            this.tExp = 0L;
        }
    }

    public void close() {
    }

    public long getMinimum() {
        return this.min;
    }

    public void setMinimum(long m) {
        this.min = m;
    }

    public long getMaximum() {
        return this.max;
    }

    public void setMaximum(long m) {
        this.max = m;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getNote() {
        return this.note;
    }

    public long getRemainingSeconds() {
        return this.remSeconds;
    }

    public long getRemainingMinutes() {
        return this.remMinutes;
    }

    public long getRemainingHours() {
        return this.remHours;
    }

    public long getRemainingDays() {
        return this.remDays;
    }

    public String getExpTimeString() {
        this.calcExpTime();
        if (this.tExp == 0L) {
            this.tExpText = " ";
        } else {
            this.tExpText = this.tExp < 120000L ? this.seconds + " seconds" : (this.tExp < 0x6DDD00L ? this.minutes + " minutes " + this.getRemainingSeconds() + " seconds" : (this.tExp < 172800000L ? this.hours + " hours " + this.getRemainingMinutes() + " minutes" : this.getRemainingDays() + " days " + this.getRemainingHours() + " hours"));
            this.tExpText = "Remaining time: " + this.tExpText;
        }
        return this.tExpText;
    }

    public void calcExpTime() {
        long now = System.currentTimeMillis();
        long tElapsed = now - this.T0;
        long countAhead = this.max - this.v - 1L;
        long counted = this.v - this.min;
        if (counted > 0L) {
            this.tExp = (long)((double)tElapsed * ((double)countAhead / (double)counted));
            this.days = this.tExp / 86400000L;
            this.hours = this.tExp / 3600000L;
            this.minutes = this.tExp / 60000L;
            this.seconds = this.tExp / 1000L;
            this.remSeconds = this.seconds - this.minutes * 60L;
            this.remMinutes = this.minutes - this.hours * 60L;
            this.remHours = this.hours - this.days * 24L;
            this.remDays = this.days;
        } else {
            this.tExp = 0L;
            this.remSeconds = 0L;
            this.remMinutes = 0L;
            this.remHours = 0L;
            this.remDays = 0L;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean value) {
        this.canceled = value;
    }

    public void reset() {
        this.T0 = System.currentTimeMillis();
        this.remSeconds = 0L;
        this.remMinutes = 0L;
        this.remHours = 0L;
        this.remDays = 0L;
        this.days = 0L;
        this.hours = 0L;
        this.minutes = 0L;
        this.seconds = 0L;
        this.v = this.min;
    }

    public static interface Logger {
        public void addMessage(int var1, String var2, Throwable var3);
    }
}

