/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.jchem.db.MDUtilities;
import chemaxon.jchem.gui.JChemFrame;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.StructureFileFilter;
import chemaxon.util.ConnectionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public class AddMDConfigDialog
extends JDialog {
    private ConnectionHandler conh;
    private String tableName;
    private String descName;
    private String confName;

    public AddMDConfigDialog(Frame parent, ConnectionHandler conh, String tableName, String descName) throws SQLException {
        super(parent, true);
        this.setTitle("Add configuration");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AddMDConfigDialog.this.setVisible(false);
                AddMDConfigDialog.this.dispose();
            }
        });
        this.conh = conh;
        this.tableName = tableName;
        this.descName = descName;
        this.displayAddConfigPanel();
        this.pack();
    }

    public String getConfigurationName() {
        return this.confName;
    }

    private void displayAddConfigPanel() throws SQLException {
        JPanel addConfigPanel = new JPanel();
        GridBagConstraints gc = new GridBagConstraints();
        addConfigPanel.setBorder(new BevelBorder(0));
        addConfigPanel.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.anchor = 17;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.insets = new Insets(20, 10, 5, 5);
        JLabel confNameLabel = new JLabel("Configuration Name:");
        addConfigPanel.add((Component)confNameLabel, gc);
        gc.gridx = 1;
        gc.gridwidth = 3;
        JTextField nameTextField = new JTextField();
        nameTextField.setName("ConfigNameTextField");
        nameTextField.setToolTipText("Name of the configuration");
        nameTextField.setText("");
        nameTextField.setPreferredSize(new Dimension(130, 20));
        addConfigPanel.add((Component)nameTextField, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.insets = new Insets(10, 10, 5, 5);
        JLabel fileLabel = new JLabel("Configuration XML file:");
        addConfigPanel.add((Component)fileLabel, gc);
        gc.insets = new Insets(5, 10, 5, 5);
        ++gc.gridy;
        final JTextField fileNameTextField = new JTextField();
        fileNameTextField.setName("ConfigFileNameTextField");
        fileNameTextField.setToolTipText("Path of configuration file");
        fileNameTextField.setText("");
        fileNameTextField.setPreferredSize(new Dimension(150, 20));
        fileNameTextField.setEnabled(false);
        addConfigPanel.add((Component)fileNameTextField, gc);
        gc.gridx = 2;
        gc.anchor = 17;
        JButton browseButton = new JButton();
        browseButton.setName("BrowseButton");
        browseButton.setText("Browse");
        browseButton.setPreferredSize(new Dimension(80, 25));
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser fc = new JFileChooser();
                fc.setFileSelectionMode(0);
                StructureFileFilter filter = new StructureFileFilter(new String[]{"xml"}, "Molecular descriptor configurtation files");
                fc.addChoosableFileFilter(filter);
                try {
                    fc.setAcceptAllFileFilterUsed(false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                fc.showOpenDialog(null);
                if (fc.getSelectedFile() != null) {
                    fileNameTextField.setText(fc.getSelectedFile().getPath());
                }
            }
        });
        addConfigPanel.add((Component)browseButton, gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.anchor = 13;
        gc.insets = new Insets(25, 5, 5, 5);
        JButton addButton = new JButton();
        addButton.setName("AddButton");
        addButton.setText("Add");
        addButton.setPreferredSize(new Dimension(60, 25));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AddMDConfigDialog.this.addConfiguration();
                    MessageDialog.showMessage(AddMDConfigDialog.this.getParent(), "Configuration has been added successfully.");
                    AddMDConfigDialog.this.setVisible(false);
                    AddMDConfigDialog.this.dispose();
                }
                catch (MDGeneratorException e) {
                    e.printStackTrace();
                    MessageDialog.showMessage(AddMDConfigDialog.this.getParent(), e.getMessage());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    MessageDialog.showMessage(AddMDConfigDialog.this.getParent(), e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    MessageDialog.showMessage(AddMDConfigDialog.this.getParent(), e.getMessage());
                }
                catch (Exception e) {
                    MessageDialog.showErrorMessage(AddMDConfigDialog.this.getParent(), e);
                }
            }
        });
        addConfigPanel.add((Component)addButton, gc);
        this.getContentPane().add((Component)addConfigPanel, "North");
    }

    private void addConfiguration() throws MDGeneratorException, SQLException, IOException {
        Component comp = JChemFrame.getComponentByName(this, "ConfigNameTextField");
        String configName = ((JTextField)comp).getText();
        if (configName.equals("")) {
            throw new IllegalArgumentException("Configuration name is empty");
        }
        comp = JChemFrame.getComponentByName(this, "ConfigFileNameTextField");
        String filePath = ((JTextField)comp).getText();
        if (filePath.equals("")) {
            throw new IllegalArgumentException("Descriptor file is not given");
        }
        MDUtilities mdu = new MDUtilities(this.conh, this.tableName);
        mdu.addConfiguration(this.descName, configName, filePath);
        this.confName = configName;
    }
}

