/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.SQLStatementDialog;
import chemaxon.jchem.gui.TableCreateDialog;
import chemaxon.util.ConnectionHandler;
import java.awt.Cursor;
import java.awt.Frame;
import java.sql.SQLException;
import java.sql.Statement;

public class Creator
implements Runnable {
    Frame parent;
    ConnectionHandler conh;

    public Creator(Frame parent, ConnectionHandler conh) {
        this.parent = parent;
        this.conh = conh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            try {
                TableCreateDialog tcDialog = new TableCreateDialog(this.parent, true, this.conh);
                tcDialog.show();
                StructureTableOptions options = tcDialog.getData();
                if (options == null) break block13;
                options.name = options.name.trim();
                if (options.name.equals("")) {
                    MessageDialog.showMessage(this.parent, "Empty name");
                    return;
                }
                boolean exists = true;
                try {
                    Statement stmt = this.conh.getConnection().createStatement();
                    try {
                        stmt.execute("SELECT * FROM " + options.name + " WHERE 1=2");
                    }
                    finally {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    exists = false;
                }
                if (exists) {
                    MessageDialog.showMessage(this.parent, "Table already exists in the database");
                    return;
                }
                SQLStatementDialog sqlDialog = new SQLStatementDialog(this.parent);
                DatabaseOptions dbOptions = DatabaseOptions.getFromDatabase(this.conh);
                String sqlCreateTable = TableInfo.createCreateTableStatement(this.conh, options, dbOptions);
                sqlDialog.setData("Create Table SQL", sqlCreateTable);
                sqlDialog.setVisible(true);
                sqlCreateTable = sqlDialog.getData();
                options.chemTermColsConfig = sqlDialog.getChemTermColsCfg();
                if (sqlCreateTable == null) break block13;
                Cursor prevCursor = this.parent.getCursor();
                this.parent.setCursor(new Cursor(3));
                try {
                    TableInfo.createTable(this.conh, options, sqlCreateTable);
                }
                finally {
                    this.parent.setCursor(prevCursor);
                }
                MessageDialog.showMessage(this.parent, "Table " + options.name + " is created successfully.\n" + "If necessary, please grant rights for users " + "to access it.\n" + "Note: You can add custom columns and Chemical " + "Terms\nexpressions using the Modify pane.");
            }
            catch (SQLException ex) {
                MessageDialog.showSQLMessage(this.parent, ex);
            }
            catch (Throwable ex) {
                MessageDialog.showErrorMessage(this.parent, ex);
            }
        }
    }
}

