/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.gui.ListSelectionDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class ExportOptionsDialog
extends JDialog {
    private ArrayList fields = new ArrayList();
    private ArrayList sFields = new ArrayList();
    private FieldInfo cd_structure = null;
    private boolean okPressed = false;
    private boolean justStructure = false;
    JPanel panel1 = new JPanel();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JLabel jLabel1 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    DefaultListModel listModel = new DefaultListModel();
    JList jList1 = new JList(this.listModel);
    JButton jButton3 = new JButton();
    JButton jButton4 = new JButton();
    JButton jButton5 = new JButton();
    TableInfo tableInfo = null;
    JButton jButton6 = new JButton();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextPane jTextPane1 = new JTextPane();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel jPanel3 = new JPanel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    private int format;

    public ExportOptionsDialog(Frame frame, String title, boolean modal, TableInfo tableInfo, int format2) {
        super(frame, title, modal);
        this.format = format2;
        switch (format2) {
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                this.justStructure = false;
                break;
            }
            default: {
                this.justStructure = true;
            }
        }
        this.tableInfo = tableInfo;
        if (!this.justStructure) {
            Enumeration<FieldInfo> fenum = tableInfo.elements();
            while (fenum.hasMoreElements()) {
                FieldInfo fi = fenum.nextElement();
                String fieldName = fi.getName();
                if (!fieldName.toLowerCase().equals("cd_structure")) {
                    this.fields.add(fi);
                    continue;
                }
                this.cd_structure = fi;
            }
            this.setDefaultSelection();
            this.showList();
        }
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.jButton1.setToolTipText("Accept selection");
        this.jButton1.setSelected(true);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportOptionsDialog.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton2.setToolTipText("Cancel export");
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportOptionsDialog.this.jButton2_actionPerformed(e);
            }
        });
        this.jLabel1.setText("Fields to export");
        this.jButton3.setToolTipText("Adds field to selection");
        this.jButton3.setText("Add");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportOptionsDialog.this.jButton3_actionPerformed(e);
            }
        });
        this.jButton4.setToolTipText("Removes selected field from list ");
        this.jButton4.setText("Remove");
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportOptionsDialog.this.jButton4_actionPerformed(e);
            }
        });
        this.jButton5.setToolTipText("Default selection: all fields in order");
        this.jButton5.setText("Reset");
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportOptionsDialog.this.jButton5_actionPerformed(e);
            }
        });
        this.jButton6.setToolTipText("Orders fields according to database record");
        this.jButton6.setText("Sort");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportOptionsDialog.this.jButton6_actionPerformed(e);
            }
        });
        this.jList1.setToolTipText("List of fields to be exported");
        this.jTextPane1.setToolTipText("type the WHERE statement here");
        this.jLabel2.setText("Condition in SELECT command");
        this.jLabel3.setText("(e.g. WHERE cd_id<1000)");
        this.jPanel1.setLayout(this.gridBagLayout3);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setLayout(this.gridBagLayout4);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ExportOptionsDialog.this.this_windowOpened(e);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 12, 1, new Insets(5, 1, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jScrollPane2, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jButton1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 22, 0));
        this.jPanel3.add((Component)this.jButton2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.panel1.add((Component)this.jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 1), 0, 5));
        this.jPanel2.add((Component)this.jButton4, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.jPanel2.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 11, 3, new Insets(0, 0, 0, 0), 4, 1));
        this.jPanel2.add((Component)this.jButton5, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), -78, 28));
        this.jPanel2.add((Component)this.jButton3, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jButton6, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.jScrollPane2.getViewport().add((Component)this.jTextPane1, null);
        if (this.justStructure) {
            this.jButton3.setEnabled(false);
            this.jButton4.setEnabled(false);
            this.jButton5.setEnabled(false);
            this.jButton6.setEnabled(false);
            this.jList1.setEnabled(false);
            this.jLabel1.setEnabled(false);
        }
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.sFields.clear();
        this.hide();
    }

    void jButton3_actionPerformed(ActionEvent e) {
        this.addToSelection();
        this.showList();
    }

    void showList() {
        this.listModel.clear();
        for (int x = 0; x < this.sFields.size(); ++x) {
            this.listModel.addElement(((FieldInfo)this.sFields.get(x)).toString());
        }
    }

    void jButton4_actionPerformed(ActionEvent e) {
        int[] sel = this.jList1.getSelectedIndices();
        for (int x = sel.length - 1; x >= 0; --x) {
            this.sFields.remove(sel[x]);
        }
        this.showList();
    }

    TableInfo getFields(TableInfo tInfo) {
        if (this.justStructure) {
            return tInfo;
        }
        tInfo.clear();
        for (int x = 0; x < this.sFields.size(); ++x) {
            tInfo.addElement((FieldInfo)this.sFields.get(x));
        }
        tInfo.addElement(this.cd_structure);
        return tInfo;
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.okPressed = true;
        this.hide();
    }

    void jButton5_actionPerformed(ActionEvent e) {
        this.setDefaultSelection();
        this.showList();
    }

    void orderSelection() {
        ArrayList oldSelection = new ArrayList(this.sFields);
        this.sFields.clear();
        for (int x = 0; x < this.fields.size(); ++x) {
            Object field = this.fields.get(x);
            for (int y = 0; y < oldSelection.size(); ++y) {
                if (oldSelection.get(y) != field) continue;
                this.sFields.add(field);
            }
        }
    }

    void jButton6_actionPerformed(ActionEvent e) {
        this.orderSelection();
        this.showList();
    }

    String getConditions() {
        return this.jTextPane1.getText();
    }

    boolean okPressed() {
        return this.okPressed;
    }

    void setDefaultSelection() {
        this.sFields.clear();
        if (this.format == 3 || this.format == 11) {
            return;
        }
        for (int x = 0; x < this.fields.size(); ++x) {
            FieldInfo field = (FieldInfo)this.fields.get(x);
            String name = field.getName();
            if ((name = name.toLowerCase()).startsWith("cd") && !name.equals("cd_id")) continue;
            this.sFields.add(field);
        }
    }

    void addToSelection() {
        ArrayList selectableFields = new ArrayList();
        for (int x = 0; x < this.fields.size(); ++x) {
            FieldInfo fi = (FieldInfo)this.fields.get(x);
            boolean alreadySelected = false;
            for (int y = 0; y < this.sFields.size(); ++y) {
                if (fi != this.sFields.get(y)) continue;
                alreadySelected = true;
            }
            if (alreadySelected) continue;
            selectableFields.add(this.fields.get(x));
        }
        ListSelectionDialog lid = new ListSelectionDialog((Dialog)this, "Choose an item", true, selectableFields);
        lid.setLocation(100, 100);
        lid.show();
        boolean[] selection = lid.getSelection();
        if (selection == null) {
            return;
        }
        for (int x = 0; x < selection.length; ++x) {
            if (!selection[x]) continue;
            this.sFields.add(selectableFields.get(x));
        }
    }

    void this_windowOpened(WindowEvent e) {
        this.jButton1.requestFocus();
    }
}

