/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.SQLToFileHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TransferDialogData;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.gui.ExportOptionsDialog;
import chemaxon.jchem.gui.FileExportOptionsDialog;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.ProgressReporter;
import chemaxon.jchem.gui.TransferDialog;
import chemaxon.util.ConnectionHandler;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class Exporter
implements Runnable {
    private JFrame parent;
    private Connection con;
    private ConnectionHandler conh;
    private Properties settings;

    public Exporter(JFrame parent, ConnectionHandler conh, Properties settings) {
        this.parent = parent;
        this.conh = conh;
        this.con = conh.getConnection();
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block22: {
            this.parent.getJMenuBar().setEnabled(false);
            try {
                File file;
                Vector<String> tables;
                Cursor prevCursor = this.parent.getCursor();
                this.parent.setCursor(new Cursor(3));
                try {
                    tables = new DatabaseProperties(this.conh).getStructureTableNames();
                }
                finally {
                    this.parent.setCursor(prevCursor);
                }
                TransferDialogData tdd = this.selectFileAndTable(tables);
                if (tdd == null) break block22;
                TableInfo tableFields = TableInfo.getTableInfo(this.conh, this.settings, tdd.selectedTable);
                int format2 = FileInfo.getFormat(tdd.fileName);
                String conditions = "";
                ExportOptionsDialog eod = new ExportOptionsDialog(this.parent, "Fields to export", true, tableFields, format2);
                eod.setBounds(10, 10, 500, 400);
                eod.setVisible(true);
                if (!eod.okPressed()) {
                    return;
                }
                conditions = eod.getConditions();
                eod.getFields(tableFields);
                tableFields.autoConnectFieldsForExport();
                FileExportOptionsDialog feod = new FileExportOptionsDialog((Frame)this.parent, "Export options", true, format2);
                feod.setBounds(10, 10, 310, 400);
                feod.setVisible(true);
                if (!feod.okPressed()) {
                    return;
                }
                String lineSep = feod.getEol();
                String delimiter = feod.getDelimiter();
                String quotation = feod.getQuotation();
                boolean jtfWithStructure = feod.isJTFStructureNeeded();
                if (tableFields == null || (file = new File(tdd.fileName)).exists() && JOptionPane.showConfirmDialog(this.parent, tdd.fileName + " exists. " + "Are you sure that you want to replace it?", "", 0) != 0) break block22;
                FileOutputStream os = new FileOutputStream(file);
                int rowCount = DBUtil.getRowCount(this.con, tdd.selectedTable);
                ProgressReporter rep = new ProgressReporter(this.parent, "Exporting...", "Molecule: ", true, 1L, rowCount);
                SQLToFileHandler handler = new SQLToFileHandler(this.conh, tdd.selectedTable, os, tableFields, format2, conditions, lineSep, delimiter, quotation, jtfWithStructure, null, null, null, null);
                prevCursor = this.parent.getCursor();
                this.parent.setCursor(new Cursor(3));
                this.parent.setEnabled(false);
                int i = 1;
                try {
                    rep.setMaximum(rowCount);
                    String notePrefix = "Molecule count: ";
                    while (!rep.isCanceled() && handler.writeNext()) {
                        if (i <= 10 || i % 10 == 0) {
                            rep.setProgress(i);
                            rep.setNote(notePrefix + i);
                        }
                        ++i;
                    }
                }
                finally {
                    this.parent.setCursor(prevCursor);
                    this.parent.setEnabled(true);
                    this.parent.toFront();
                    rep.close();
                    handler.close();
                    ((OutputStream)os).close();
                }
                MessageDialog.showMessage(this.parent, "Number of exported molecules: " + (i - 1));
            }
            catch (SQLException ex) {
                MessageDialog.showSQLMessage(this.parent, ex);
            }
            catch (InterruptedIOException ex) {
                MessageDialog.showMessage(this.parent, "File export cancelled");
            }
            catch (Throwable ex) {
                MessageDialog.showErrorMessage(this.parent, ex);
            }
            finally {
                this.parent.getJMenuBar().setEnabled(true);
            }
        }
    }

    private TransferDialogData selectFileAndTable(Vector tables) {
        TransferDialogData tdd = TransferDialogData.getFromSettings(this.settings, 1);
        tdd.tables = tables;
        TransferDialog d = new TransferDialog((Frame)this.parent, 1);
        d.setData(tdd);
        d.setVisible(true);
        tdd = d.getData();
        if (tdd != null) {
            tdd.save(this.settings);
        }
        return tdd;
    }
}

