/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.gui.ConnectTableCellEditor;
import chemaxon.jchem.gui.FieldConnectTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class FieldConnectDialog
extends JDialog
implements ActionListener {
    private boolean isOkPressed = false;
    private JPanel ivjJDialogContentPane = null;
    private JButton ivjCancelButton = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JTable ivjScrollPaneTable = null;
    private JButton ivjOkButton = null;

    public FieldConnectDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean bl = this.isOkPressed = e.getSource() == this.getOkButton() ? true : this.isOkPressed;
        if (e.getSource() == this.getOkButton()) {
            this.connOkPressed();
        }
        if (e.getSource() == this.getCancelButton()) {
            this.connCancelPressed();
        }
    }

    public void cancelButton_ActionEvents() {
    }

    private void connCancelPressed() {
        try {
            this.setVisible(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connOkPressed() {
        try {
            this.setVisible(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getCancelButton() {
        if (this.ivjCancelButton == null) {
            try {
                this.ivjCancelButton = new JButton();
                this.ivjCancelButton.setName("CancelButton");
                this.ivjCancelButton.setText("Cancel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancelButton;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout(10, 10));
                JPanel buttonPane = new JPanel();
                buttonPane.setLayout(new BoxLayout(buttonPane, 0));
                buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
                buttonPane.add(Box.createHorizontalGlue());
                buttonPane.add(this.getOkButton());
                buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPane.add(this.getCancelButton());
                this.ivjJDialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "North");
                this.ivjJDialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "East");
                this.ivjJDialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "West");
                this.ivjJDialogContentPane.add((Component)this.getJScrollPane1(), "Center");
                this.ivjJDialogContentPane.add((Component)buttonPane, "South");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.ivjJScrollPane1.setVerticalScrollBarPolicy(20);
                this.ivjJScrollPane1.setHorizontalScrollBarPolicy(30);
                this.ivjJScrollPane1.setViewportView(this.getScrollPaneTable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    public FieldConnectTableModel getModel() {
        return this.isOkPressed ? (FieldConnectTableModel)this.getScrollPaneTable().getModel() : null;
    }

    private JButton getOkButton() {
        if (this.ivjOkButton == null) {
            try {
                this.ivjOkButton = new JButton();
                this.ivjOkButton.setName("OkButton");
                this.ivjOkButton.setText("Ok");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOkButton;
    }

    private JTable getScrollPaneTable() {
        if (this.ivjScrollPaneTable == null) {
            try {
                this.ivjScrollPaneTable = new JTable();
                if (this.ivjScrollPaneTable.getRowHeight() < 20) {
                    this.ivjScrollPaneTable.setRowHeight(20);
                }
                this.ivjScrollPaneTable.setName("ScrollPaneTable");
                this.getJScrollPane1().setColumnHeaderView(this.ivjScrollPaneTable.getTableHeader());
                this.getJScrollPane1().getViewport().setScrollMode(2);
                this.ivjScrollPaneTable.setAutoResizeMode(4);
                this.ivjScrollPaneTable.setBackground(Color.lightGray);
                this.ivjScrollPaneTable.setPreferredScrollableViewportSize(new Dimension(500, 200));
                this.ivjScrollPaneTable.setRowSelectionAllowed(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjScrollPaneTable;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
        this.getOkButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
    }

    private void initialize() {
        this.setName("ImportDialog");
        this.setDefaultCloseOperation(2);
        this.setTitle("Connecting Fields");
        this.setModal(true);
        this.setContentPane(this.getJDialogContentPane());
        this.initConnections();
        this.pack();
    }

    public void setModel(FieldConnectTableModel model, Vector fileFields) {
        this.isOkPressed = false;
        JTable table = this.getScrollPaneTable();
        table.setModel(model);
        block5: for (int col = 0; col < 3; ++col) {
            TableColumn column = table.getColumn(table.getColumnName(col));
            DefaultTableCellRenderer columnRenderer = new DefaultTableCellRenderer();
            switch (col) {
                case 0: {
                    column.setPreferredWidth(200);
                    columnRenderer.setBackground(Color.lightGray);
                    column.setCellRenderer(columnRenderer);
                    continue block5;
                }
                case 1: {
                    column.setPreferredWidth(100);
                    columnRenderer.setBackground(Color.lightGray);
                    column.setCellRenderer(columnRenderer);
                    continue block5;
                }
                case 2: {
                    column.setCellEditor(new ConnectTableCellEditor(model, fileFields));
                    columnRenderer.setBackground(Color.white);
                    columnRenderer.setToolTipText("Click into the cell to change connection");
                    column.setCellRenderer(columnRenderer);
                    column.setPreferredWidth(200);
                }
            }
        }
        this.pack();
    }
}

