/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.jchem.db.DBUtil;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.MDUtilities;
import chemaxon.jchem.db.MarkushTableInfo;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.db.sql.TypeConverter;
import chemaxon.jchem.gui.AddColumnDialog;
import chemaxon.jchem.gui.AddDescriptorDialog;
import chemaxon.jchem.gui.AddMDConfigDialog;
import chemaxon.jchem.gui.JChemFrame;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.ProgressReporter;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

class ModifyDialog
extends JDialog {
    private ConnectionHandler conh;
    private DatabaseProperties dbProps;
    private Vector<String> tables;
    private Properties settings;
    private Frame parent;
    public static final String MD_PREFIX = "Descriptor: ";
    public static final String MDCONFIG_PREFIX = "Configuration: ";

    public ModifyDialog(Frame parent, ConnectionHandler conh, Properties settings) throws SQLException {
        super(parent, true);
        this.setTitle("Modify");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ModifyDialog.this.setVisible(false);
                ModifyDialog.this.dispose();
            }
        });
        this.parent = parent;
        this.conh = conh;
        this.dbProps = new DatabaseProperties(conh);
        this.settings = settings;
        try {
            this.tables = this.dbProps.getStructureTableNames();
            String tableName = settings.getProperty("modify.selectedTable");
            if (this.tables.size() == 0) {
                JLabel label = new JLabel("There are no JChem tables in the database.");
                GridBagConstraints gc = new GridBagConstraints();
                this.setLayout(new GridBagLayout());
                gc.insets = new Insets(50, 20, 50, 20);
                this.add((Component)label, gc);
            } else {
                if (tableName == null || !this.tables.contains(tableName)) {
                    tableName = this.tables.get(0);
                }
                this.displayStaticComponents(tableName);
                this.displayDynamicComponents(tableName);
            }
        }
        catch (Exception e) {
            MessageDialog.showErrorMessage(this, e);
        }
        this.pack();
    }

    private void displayStaticComponents(String tableName) throws SQLException {
        JPanel staticPanel = new JPanel();
        GridBagConstraints gc = new GridBagConstraints();
        staticPanel.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.gridwidth = 2;
        gc.insets = new Insets(10, 10, 5, 10);
        JLabel label = new JLabel("Database table:");
        staticPanel.add((Component)label, gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.insets = new Insets(0, 10, 0, 10);
        final JComboBox<String> tableComboBox = new JComboBox<String>();
        tableComboBox.setName("TableComboBox");
        tableComboBox.setToolTipText("Select table");
        tableComboBox.setPreferredSize(new Dimension(200, 25));
        tableComboBox.setEditable(false);
        Iterator<String> iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            tableComboBox.addItem(iterator.next());
        }
        tableComboBox.setSelectedItem(tableName);
        tableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String selectedTable = (String)((JComboBox)evt.getSource()).getSelectedItem();
                ModifyDialog.this.settings.put("modify.selectedTable", selectedTable);
                ModifyDialog.this.refreshPane(selectedTable);
            }
        });
        staticPanel.add(tableComboBox, gc);
        gc.insets = new Insets(0, 0, 0, 10);
        gc.gridx = 1;
        JButton addButton = new JButton();
        addButton.setText("Add column");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String tableName = (String)tableComboBox.getSelectedItem();
                try {
                    new AddColumnDialog(ModifyDialog.this.parent, ModifyDialog.this.conh, tableName).setVisible(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ModifyDialog.this.refreshPane(tableName);
            }
        });
        staticPanel.add((Component)addButton, gc);
        this.getContentPane().add((Component)staticPanel, "North");
    }

    private void displayDynamicComponents(final String tableName) throws SQLException {
        JPanel mainPanel = new JPanel();
        mainPanel.setName("modifyCustomPanel");
        GridBagConstraints gc = new GridBagConstraints();
        mainPanel.setLayout(new GridBagLayout());
        gc.insets = new Insets(20, 10, 10, 10);
        JPanel customPanel = new JPanel();
        customPanel.setBorder(new BevelBorder(0));
        customPanel.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 2;
        gc.anchor = 17;
        gc.insets = new Insets(5, 5, 5, 165);
        JLabel label = new JLabel("Custom fields in the table");
        customPanel.add((Component)label, gc);
        ArrayList fieldNames = DatabaseTools.getFieldNames(this.conh, tableName, null);
        int[] fieldTypes = DatabaseTools.getFieldTypes(this.conh, tableName);
        TypeConverter typeConverter = new TypeConverter(this.conh.getConnection());
        final ArrayList<String> fn = new ArrayList<String>();
        final ArrayList<String> ft = new ArrayList<String>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            String value = (String)fieldNames.get(i);
            if (value.toLowerCase().startsWith("cd_")) continue;
            fn.add(value);
            ft.add(typeConverter.getLocalTypeByCode(fieldTypes[i]));
        }
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                return col == 0 ? "Field Name" : "Field Type";
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return fn.size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return fn.get(row);
                }
                return ft.get(row);
            }
        };
        ++gc.gridy;
        final JTable table = new JTable(dataModel);
        if (fn.size() > 0) {
            TableColumn column = table.getColumnModel().getColumn(0);
            column.setPreferredWidth(140);
            column = table.getColumnModel().getColumn(1);
            column.setPreferredWidth(140);
            gc.insets = new Insets(1, 10, 0, 1);
            customPanel.add((Component)table.getTableHeader(), gc);
            ++gc.gridy;
            gc.insets = new Insets(0, 10, 10, 1);
            customPanel.add((Component)table, gc);
        } else {
            gc.insets = new Insets(1, 10, 15, 10);
            gc.anchor = 10;
            JLabel none1Label = new JLabel("- None -");
            customPanel.add((Component)none1Label, gc);
        }
        ++gc.gridy;
        if (fn.size() > 0) {
            gc.gridwidth = 2;
            gc.gridx = 0;
            ++gc.gridy;
            gc.anchor = 10;
            JButton deleteButton = new JButton();
            deleteButton.setText("Delete selected columns");
            customPanel.add((Component)deleteButton, gc);
            deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int[] selected = table.getSelectedRows();
                    if (selected.length > 0) {
                        ArrayList markedForRemoval = new ArrayList();
                        for (int i = 0; i < selected.length; ++i) {
                            markedForRemoval.add(fn.get(selected[i]));
                        }
                        try {
                            ModifyDialog.this.deleteCustomColumns(tableName, markedForRemoval);
                            MessageDialog.showMessage(ModifyDialog.this.getParent(), "Columns have been removed successfully.");
                        }
                        catch (Exception e) {
                            MessageDialog.showErrorMessage(ModifyDialog.this.getParent(), e);
                        }
                        ModifyDialog.this.refreshPane(tableName);
                    }
                }
            });
            gc.gridx = 1;
        }
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 2;
        gc.insets = new Insets(20, 10, 10, 10);
        mainPanel.add((Component)customPanel, gc);
        JPanel mdPanel = new JPanel();
        mdPanel.setBorder(new BevelBorder(0));
        mdPanel.setLayout(new GridBagLayout());
        gc.insets = new Insets(5, 5, 5, 5);
        gc.anchor = 17;
        JLabel label2 = new JLabel("Molecular descriptors");
        mdPanel.add((Component)label2, gc);
        ++gc.gridy;
        mdPanel.add((Component)this.getTree(tableName), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.insets = new Insets(10, 10, 10, 10);
        gc.anchor = 10;
        mainPanel.add((Component)mdPanel, gc);
        ++gc.gridy;
        gc.anchor = 13;
        gc.insets = new Insets(20, 10, 10, 10);
        JButton doneButton = new JButton();
        doneButton.setText("Done");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyDialog.this.doneAction();
            }
        });
        mainPanel.add((Component)doneButton, gc);
        this.getContentPane().add((Component)mainPanel, "South");
    }

    private JPanel getTree(final String tableName) throws SQLException {
        String[] mds = this.dbProps.getMolecularDescriptors(tableName);
        if (this.dbProps.getTableType(tableName) == 3) {
            mds = this.filterOutMarkushDescriptors(mds);
        }
        final DefaultMutableTreeNode root = new DefaultMutableTreeNode("Molecular Descriptors");
        DefaultMutableTreeNode desc = null;
        DefaultMutableTreeNode conf = null;
        final DefaultTreeModel treeModel = new DefaultTreeModel(root);
        for (String mdName : mds) {
            desc = new DefaultMutableTreeNode(MD_PREFIX + mdName);
            for (String configName : this.dbProps.getMDConfigs(tableName, mdName)) {
                conf = new DefaultMutableTreeNode(MDCONFIG_PREFIX + configName);
                conf.setAllowsChildren(false);
                desc.add(conf);
            }
            root.add(desc);
        }
        final JTree tree = new JTree(treeModel);
        tree.setEditable(false);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setShowsRootHandles(true);
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        JScrollPane treeView = new JScrollPane(tree);
        treeView.setPreferredSize(new Dimension(280, 100));
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)treeView, "North");
        JButton addButton = new JButton("Add");
        if (this.dbProps.getTableType(tableName) == 3) {
            addButton.setEnabled(false);
        }
        final Frame frame = (Frame)this.getParent();
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefaultMutableTreeNode parent = null;
                TreePath parentPath = tree.getSelectionPath();
                parent = parentPath == null ? root : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
                String newNodeName = null;
                try {
                    if (parent.getLevel() == 0) {
                        AddDescriptorDialog add = new AddDescriptorDialog(frame, ModifyDialog.this.conh, tableName);
                        add.setVisible(true);
                        newNodeName = add.getDescriptorName();
                        if (newNodeName != null) {
                            newNodeName = ModifyDialog.MD_PREFIX + newNodeName;
                        }
                    } else if (parent.getLevel() == 1) {
                        AddMDConfigDialog edd = new AddMDConfigDialog(frame, ModifyDialog.this.conh, tableName, parent.toString().substring(ModifyDialog.MD_PREFIX.length()));
                        edd.setVisible(true);
                        newNodeName = edd.getConfigurationName();
                        if (newNodeName != null) {
                            newNodeName = ModifyDialog.MDCONFIG_PREFIX + newNodeName;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (newNodeName != null) {
                    DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(newNodeName);
                    treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
                    tree.scrollPathToVisible(new TreePath(childNode.getPath()));
                }
            }
        });
        JButton removeButton = new JButton("Remove");
        if (this.dbProps.getTableType(tableName) == 3) {
            removeButton.setEnabled(false);
        }
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath currentSelection = tree.getSelectionPath();
                if (currentSelection != null) {
                    DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
                    try {
                        MDUtilities mdu = new MDUtilities(ModifyDialog.this.conh, tableName);
                        if (currentNode.getLevel() == 1) {
                            mdu.removeDescriptor(currentNode.toString().substring(ModifyDialog.MD_PREFIX.length()));
                        } else if (currentNode.getLevel() == 2) {
                            mdu.removeConfiguration(((DefaultMutableTreeNode)currentNode.getParent()).toString().substring(ModifyDialog.MD_PREFIX.length()), currentNode.toString().substring(ModifyDialog.MDCONFIG_PREFIX.length()));
                        }
                    }
                    catch (MDGeneratorException e) {
                        e.printStackTrace();
                        MessageDialog.showMessage(ModifyDialog.this.getParent(), e.getMessage());
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        MessageDialog.showMessage(ModifyDialog.this.getParent(), e.getMessage());
                    }
                    MutableTreeNode parent = (MutableTreeNode)currentNode.getParent();
                    if (parent != null) {
                        treeModel.removeNodeFromParent(currentNode);
                        return;
                    }
                }
            }
        });
        JPanel panel = new JPanel(new GridLayout(0, 2));
        panel.add(addButton);
        panel.add(removeButton);
        treePanel.add((Component)panel, "South");
        return treePanel;
    }

    private String[] filterOutMarkushDescriptors(String[] originalStrings) {
        String[] markushDescriptors = MarkushTableInfo.getMarkushDescriptorNames();
        Vector<String> ret = new Vector<String>();
        for (String value : originalStrings) {
            boolean add = true;
            for (String descName : markushDescriptors) {
                if (!value.equalsIgnoreCase(descName)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            ret.add(value);
        }
        String[] names = new String[ret.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)ret.get(i);
        }
        return names;
    }

    private void deleteCustomColumns(String tableName, ArrayList<String> columns) throws SQLException {
        if (columns.size() > 0) {
            for (String columnName : columns) {
                if (this.dbProps.getChemTermForColumn(tableName, columnName) != null) {
                    this.dbProps.deleteChemTermForColumn(tableName, columnName);
                }
                DBUtil.dropColumn(this.conh.getConnection(), tableName, columnName);
                if (!AddColumnDialog.ctColumns.containsKey(tableName) || !AddColumnDialog.ctColumns.get(tableName).contains(columnName.toLowerCase())) continue;
                ArrayList<String> newColumns = AddColumnDialog.ctColumns.get(tableName);
                newColumns.remove(columnName.toLowerCase());
                if (newColumns.size() >= 1) continue;
                AddColumnDialog.ctColumns.remove(tableName);
            }
        }
    }

    private void refreshPane(String selectedTable) {
        this.getContentPane().remove(JChemFrame.getComponentByName(this, "modifyCustomPanel"));
        try {
            this.displayDynamicComponents(selectedTable);
        }
        catch (Exception e) {
            MessageDialog.showErrorMessage(this, e);
        }
        this.pack();
        this.repaint();
    }

    private void doneAction() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AddColumnDialog.ctColumns.size() > 0) {
                    String text = "The following Chemical Terms columns have \nbeen created and need to be generated \nto contain the appropriate values.\nDo you want to generate them?\n\n";
                    for (String tableName : AddColumnDialog.ctColumns.keySet()) {
                        text = text + tableName.toUpperCase() + ":\n";
                        Iterator<String> columns = AddColumnDialog.ctColumns.get(tableName).iterator();
                        while (columns.hasNext()) {
                            text = text + "    " + columns.next() + "\n";
                        }
                    }
                    int choice = JOptionPane.showConfirmDialog(ModifyDialog.this.parent, text, "", 0);
                    ModifyDialog.this.setVisible(false);
                    ModifyDialog.this.dispose();
                    if (choice == 0) {
                        this.setPriority(1);
                        ProgressReporter pr = new ProgressReporter(ModifyDialog.this.parent, "", "", true, 1L, 1L);
                        boolean success = true;
                        try {
                            HashMap set = (HashMap)AddColumnDialog.ctColumns.clone();
                            for (String tableName : set.keySet()) {
                                pr.reset();
                                pr.setText("Counting new Chemical Terms of " + tableName + "...\n");
                                if (!UpdateHandler.recalculateCTColumns(ModifyDialog.this.conh, tableName, AddColumnDialog.ctColumns.get(tableName).toArray(new String[AddColumnDialog.ctColumns.get(tableName).size()]), pr)) {
                                    success = false;
                                }
                                if (pr != null && pr.isCanceled()) {
                                    if (success) {
                                        MessageDialog.showMessage(ModifyDialog.this.parent, "Chemical Terms recalculation cancelled");
                                    } else {
                                        MessageDialog.showMessage(ModifyDialog.this.parent, "Chemical Terms recalculation cancelled. Please, check the console output because errors have occured during recalculation");
                                    }
                                    return;
                                }
                                AddColumnDialog.ctColumns.remove(tableName);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            success = false;
                        }
                        finally {
                            pr.close();
                        }
                        if (success) {
                            MessageDialog.showMessage(ModifyDialog.this.parent, "Chemical Terms columns have been recalculated successfully");
                        } else {
                            MessageDialog.showMessage(ModifyDialog.this.parent, "Errors have occurred during Chermical Terms recalculation, please, check the console output for details");
                        }
                        return;
                    }
                }
                ModifyDialog.this.setVisible(false);
                ModifyDialog.this.dispose();
            }
        }.start();
    }
}

