/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseOptions;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.WholeNumberField;
import chemaxon.util.ConnectionHandler;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class OptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private ConnectionHandler conh;
    private static final String ILLEGAL_COMMIT_INTERVAL = "Error: commit interval must be 1 or greater";
    private JPanel westPanel;
    private JPanel southPanel;
    private JButton okButton;
    private JTabbedPane tabbedPane;
    private JButton cancelButton;
    private JPanel eastPanel;
    private JPanel advancedPanel;
    private JCheckBox compressCheckBox;
    private WholeNumberField commitIntervalTextBox;

    public OptionsDialog(Frame parent, boolean modal, ConnectionHandler conh) {
        super(parent, modal);
        this.conh = conh;
        this.initComponents();
        this.tabbedPane.setTitleAt(0, "Advanced");
        this.pack();
    }

    private void initComponents() {
        this.southPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.advancedPanel = new JPanel();
        this.eastPanel = new JPanel();
        this.westPanel = new JPanel();
        this.compressCheckBox = new JCheckBox();
        this.setTitle("Options");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OptionsDialog.this.closeDialog();
            }
        });
        this.southPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("Ok");
        this.okButton.setSelected(true);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.okButtonActionPerformed();
            }
        });
        this.southPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.cancelButtonActionPerformed();
            }
        });
        this.southPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.advancedPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.anchor = 17;
        gc.insets = new Insets(30, 10, 10, 0);
        JLabel label1 = new JLabel("Compress MOL, RXN and SDF formats during import");
        String compressTooltip = "Some file formats are stored in a compressed form in the cd_strcutre field (default).\nUnchecking this box will disable this compression.";
        label1.setToolTipText(compressTooltip);
        this.compressCheckBox.setToolTipText(compressTooltip);
        this.advancedPanel.add((Component)this.compressCheckBox, gc);
        gc.gridx = 1;
        gc.gridwidth = 2;
        gc.insets = new Insets(30, 5, 10, 10);
        this.advancedPanel.add((Component)label1, gc);
        JLabel label3 = new JLabel("Commit interval:");
        String commitIntervalTooltip = "Commit interval";
        label3.setToolTipText(commitIntervalTooltip);
        this.commitIntervalTextBox = new WholeNumberField(50, 6);
        this.commitIntervalTextBox.setToolTipText(commitIntervalTooltip);
        gc.gridx = 1;
        gc.gridwidth = 1;
        ++gc.gridy;
        ++gc.gridy;
        this.advancedPanel.add((Component)label3, gc);
        gc.gridx = 2;
        gc.gridwidth = 1;
        this.advancedPanel.add((Component)this.commitIntervalTextBox, gc);
        gc.gridx = 99;
        gc.gridy = 99;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.advancedPanel.add((Component)Box.createVerticalBox(), gc);
        this.tabbedPane.addTab("Advanced", null, this.advancedPanel, "");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)this.eastPanel, "West");
        this.getContentPane().add((Component)this.westPanel, "East");
    }

    private void cancelButtonActionPerformed() {
        this.doClose(0);
    }

    private void okButtonActionPerformed() {
        if (this.commitIntervalTextBox.getValue() != 0) {
            this.doClose(1);
        } else {
            MessageDialog.showMessage(new Frame(), ILLEGAL_COMMIT_INTERVAL);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new OptionsDialog((Frame)new JFrame(), true, new ConnectionHandler()).setVisible(true);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public void setData(DatabaseOptions dbOptions) {
        this.compressCheckBox.setSelected(!dbOptions.doNotCompressStructureField);
        this.commitIntervalTextBox.setValue(dbOptions.commitInterval);
    }

    public DatabaseOptions getData() {
        DatabaseOptions dbOptions = null;
        if (this.returnStatus == 1) {
            try {
                dbOptions = new DatabaseOptions(this.conh);
            }
            catch (SQLException e) {
                dbOptions = new DatabaseOptions();
            }
            boolean bl = dbOptions.doNotCompressStructureField = !this.compressCheckBox.isSelected();
            if (this.commitIntervalTextBox.getValue() != 0) {
                dbOptions.commitInterval = this.commitIntervalTextBox.getValue();
            } else {
                return null;
            }
        }
        return dbOptions;
    }
}

