/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.file.ProgressWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class ProgressReporter
extends ProgressWriter {
    protected Component parent;
    protected JDialog dialog;
    protected JOptionPane pane;
    protected JProgressBar bar;
    protected JLabel tExpLabel = null;
    protected JLabel noteLabel = null;
    protected JLabel msgLabel = null;
    protected String msg;
    protected long lastDisp;
    protected long diff;
    protected boolean tExpNeeded;

    public ProgressReporter(Component parent, String msg, String note, boolean tExpNeeded, long min, long max) {
        super(note, min, max);
        this.parent = parent;
        this.tExpNeeded = tExpNeeded;
        this.diff = (max - min) / 1000L;
        if (this.diff < 1L) {
            this.diff = 1L;
        }
        this.msg = msg;
        this.createDialog(msg.length() > 0);
    }

    protected void createDialog(boolean visible) {
        this.bar = new JProgressBar();
        if (this.min == 0L && this.max == 0L) {
            this.bar.setIndeterminate(true);
        } else {
            this.bar.setMinimum((int)this.min);
            this.bar.setMaximum((int)this.max);
            this.bar.setValue(0);
        }
        this.msgLabel = new JLabel(this.msg + " ");
        if (this.tExpNeeded) {
            this.tExpLabel = new JLabel(this.note);
            this.tExpLabel.setText("Remaining time: XXXXXX minute   XXXXXX seconds");
        }
        if (this.note != null) {
            this.noteLabel = new JLabel(this.note);
            this.noteLabel.setText(" ");
        }
        this.pane = new MyOptionPane(new Object[]{this.msgLabel, this.noteLabel, this.bar, this.tExpLabel});
        this.dialog = this.pane.createDialog(this.parent, "Progress...");
        if (this.tExpNeeded) {
            this.tExpLabel.setText(" ");
        }
        this.dialog.setVisible(visible);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public void setProgress(long nv) {
        super.setProgress(nv);
        if (nv < this.max && nv >= this.lastDisp + this.diff) {
            this.lastDisp = nv;
            if (this.bar != null) {
                this.bar.setValue((int)nv);
            }
        }
        if (this.tExpNeeded) {
            this.tExpLabel.setText(this.getExpTimeString());
        }
    }

    @Override
    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.bar = null;
        }
        super.close();
    }

    @Override
    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object v = this.pane.getValue();
        return v == null || v != JOptionPane.UNINITIALIZED_VALUE;
    }

    @Override
    public void setNote(String note) {
        super.setNote(note);
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (!this.dialog.isVisible() && text.length() > 0) {
            this.dialog.setVisible(true);
        }
        if (this.msgLabel != null) {
            this.msgLabel.setText(text);
        }
    }

    @Override
    public void setMaximum(long m) {
        super.setMaximum(m);
        if (this.bar != null) {
            this.bar.setMaximum((int)m);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.bar != null) {
            this.bar.setValue(0);
        }
        this.lastDisp = 0L;
        this.diff = (this.max - this.min) / 1000L;
        if (this.diff < 1L) {
            this.diff = 1L;
        }
    }

    private static class MyOptionPane
    extends JOptionPane {
        MyOptionPane(Object messageList) {
            super(messageList, 1, 0, null, new Object[]{"Cancel"}, null);
        }

        @Override
        public JDialog createDialog(Component parent, String title) {
            JDialog dialog;
            if (parent instanceof Dialog) {
                dialog = new JDialog((Dialog)parent, title, false);
            } else {
                Frame frame = JOptionPane.getFrameForComponent(parent);
                dialog = new JDialog(frame, title, false);
            }
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(parent);
            dialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                @Override
                public void windowClosing(WindowEvent we) {
                    MyOptionPane.this.setValue(null);
                }

                @Override
                public void windowActivated(WindowEvent we) {
                    if (!this.gotFocus) {
                        MyOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (dialog.isVisible() && event.getSource() == MyOptionPane.this && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            });
            return dialog;
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }
    }
}

