/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class SQLStatementDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel centerPanel;
    private MyTable ctColCfgTable;
    private JButton okButton;
    private JLabel sqlLabel;
    private JPanel sqlPanel;
    private JTextArea sqlText;
    private JScrollPane sqlTextScrollPane;
    private int returnStatus = 0;

    public SQLStatementDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.pack();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.centerPanel = new CenterPanel();
        int mintFontSize = 12;
        Font font = this.sqlText.getFont();
        if (font.getSize() < 12) {
            Font newFont = new Font(font.getName(), font.getStyle(), 12);
            this.sqlText.setFont(newFont);
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SQLStatementDialog.this.closeDialog();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLStatementDialog.this.okButtonActionPerformed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SQLStatementDialog.this.cancelButtonActionPerformed();
            }
        });
        this.getContentPane().add((Component)this.centerPanel, "Center");
    }

    private void okButtonActionPerformed() {
        if (this.ctColCfgTable.isEditing()) {
            this.ctColCfgTable.getDefaultEditor(String.class).stopCellEditing();
        }
        this.doClose(1);
    }

    private void cancelButtonActionPerformed() {
        this.doClose(0);
    }

    private void closeDialog() {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new SQLStatementDialog(new Frame()).setVisible(true);
    }

    public void setData(String title, String sql) {
        this.setTitle(title);
        this.sqlText.setText(sql);
    }

    public String getData() {
        String sql = null;
        if (this.returnStatus == 1) {
            sql = this.sqlText.getText();
        }
        return sql;
    }

    public Map getChemTermColsCfg() {
        TableModel ctColsCfgModel = this.ctColCfgTable.getModel();
        int ctColCount = ctColsCfgModel.getRowCount() - 1;
        if (ctColCount > 0) {
            HashMap<Object, Object> ctColsCfg = new HashMap<Object, Object>();
            for (int ix = 0; ix < ctColCount; ++ix) {
                Object tableName = ctColsCfgModel.getValueAt(ix, 0);
                Object ctExpr = ctColsCfgModel.getValueAt(ix, 1);
                ctColsCfg.put(tableName, ctExpr);
            }
            return ctColsCfg;
        }
        return null;
    }

    public class CenterPanel
    extends JPanel {
        public CenterPanel() {
            this.initComponents();
            if (SQLStatementDialog.this.ctColCfgTable.getRowHeight() < 20) {
                SQLStatementDialog.this.ctColCfgTable.setRowHeight(20);
            }
            ((DefaultCellEditor)SQLStatementDialog.this.ctColCfgTable.getDefaultEditor(String.class)).setClickCountToStart(1);
            SQLStatementDialog.this.ctColCfgTable.setSelectionForeground(Color.BLACK);
            SQLStatementDialog.this.ctColCfgTable.setSelectionBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(550, 600));
        }

        private void initComponents() {
            SQLStatementDialog.this.centerPanel = new JPanel();
            SQLStatementDialog.this.sqlPanel = new JPanel();
            SQLStatementDialog.this.sqlLabel = new JLabel();
            SQLStatementDialog.this.sqlTextScrollPane = new JScrollPane();
            SQLStatementDialog.this.sqlText = new JTextArea();
            SQLStatementDialog.this.ctColCfgTable = new MyTable();
            SQLStatementDialog.this.buttonPanel = new JPanel();
            SQLStatementDialog.this.okButton = new JButton();
            SQLStatementDialog.this.cancelButton = new JButton();
            this.setLayout(new BorderLayout());
            SQLStatementDialog.this.centerPanel.setLayout(new GridBagLayout());
            SQLStatementDialog.this.sqlPanel.setLayout(new BorderLayout(5, 5));
            SQLStatementDialog.this.sqlLabel.setText("Create Table SQL Statement:");
            SQLStatementDialog.this.sqlPanel.add((Component)SQLStatementDialog.this.sqlLabel, "North");
            SQLStatementDialog.this.sqlText.setColumns(80);
            SQLStatementDialog.this.sqlText.setLineWrap(true);
            SQLStatementDialog.this.sqlText.setRows(300);
            SQLStatementDialog.this.sqlText.setToolTipText("SQL statement for table creation. Add new columns if needed");
            SQLStatementDialog.this.sqlText.setWrapStyleWord(true);
            SQLStatementDialog.this.sqlTextScrollPane.setViewportView(SQLStatementDialog.this.sqlText);
            SQLStatementDialog.this.sqlPanel.add((Component)SQLStatementDialog.this.sqlTextScrollPane, "Center");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.8;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            SQLStatementDialog.this.centerPanel.add((Component)SQLStatementDialog.this.sqlPanel, gridBagConstraints);
            this.add((Component)SQLStatementDialog.this.centerPanel, "Center");
            SQLStatementDialog.this.buttonPanel.setLayout(new FlowLayout(2));
            SQLStatementDialog.this.okButton.setText("Ok");
            SQLStatementDialog.this.okButton.setToolTipText("Accept SQL statement");
            SQLStatementDialog.this.buttonPanel.add(SQLStatementDialog.this.okButton);
            SQLStatementDialog.this.cancelButton.setText("Cancel");
            SQLStatementDialog.this.buttonPanel.add(SQLStatementDialog.this.cancelButton);
            this.add((Component)SQLStatementDialog.this.buttonPanel, "South");
        }

        private class MyTableModel
        extends DefaultTableModel {
            public MyTableModel() {
                super(new Object[][]{{null, null}}, new String[]{"Column Name", "Chemical Terms Expression"});
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                int rowCount;
                super.setValueAt(aValue, row, column);
                if (this.isCellEmpty(row, 0) && this.isCellEmpty(row, 1) && (row > 0 || this.getRowCount() > 1)) {
                    this.removeRow(row);
                }
                if (!this.isCellEmpty((rowCount = this.getRowCount()) - 1, 0) && !this.isCellEmpty(rowCount - 1, 1)) {
                    this.addRow(new Object[]{null, null});
                }
            }

            private boolean isCellEmpty(int row, int column) {
                Object aValue = this.getValueAt(row, column);
                return aValue == null || String.valueOf(aValue).trim().length() == 0;
            }
        }
    }

    public static class MyTable
    extends JTable {
        int prevCol = -1;
        int prevRow = -1;

        @Override
        public void columnSelectionChanged(ListSelectionEvent arg0) {
            this.cellSelectionChanged();
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            this.cellSelectionChanged();
        }

        public void cellSelectionChanged() {
            int row = this.getSelectedRow();
            int col = this.getSelectedColumn();
            if (row < 0 || col < 0) {
                return;
            }
            if (row == this.prevRow && col == this.prevCol) {
                return;
            }
            this.prevRow = row;
            this.prevCol = col;
            this.editCellAt(row, col);
        }

        @Override
        public boolean editCellAt(int row, int column, EventObject e) {
            boolean retVal = super.editCellAt(row, column, e);
            if (retVal) {
                this.editorComp.requestFocus();
            }
            return retVal;
        }
    }
}

