/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.sss.search.MolSearchOptions;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class SearchOptionsPanel
extends JPanel {
    private static final String OPTIONS_GUI = "gui";
    private static final String OPTIONS_TEXT = "text";
    private JPanel optionsPanel = null;
    private JTextArea optionsTextArea = null;
    private JRadioButton optionsGUIRadioButton = new JRadioButton("Display on GUI", true);
    private JRadioButton optionsTextRadioButton = new JRadioButton("Display as Text", false);
    private JComboBox searchTypeComboBox = new JComboBox<Object>(new Object[]{"Substructure", "Duplicate", "Full", "Full fragment", "Superstructure"});
    private JComboBox stereoSearchComboBox = new JComboBox<Object>(new Object[]{"Specific", "Exact", "Ignore", "Diastereomer"});
    private JComboBox hitOrderingComboBox = new JComboBox<Object>(new Object[]{"None", "Undef R matching group first"});
    private JCheckBox orderCheckBox = new JCheckBox("Order sensitive search", false);
    private JCheckBox tautomerSearchCheckBox = new JCheckBox("Tautomer search", false);
    private JCheckBox exactBondCheckBox = new JCheckBox("Bond");
    private JComboBox exactChargeComboBox = new JComboBox<Object>(new Object[]{"Default", "Exact", "Ignore"});
    private JComboBox exactIsotopeComboBox = new JComboBox<Object>(new Object[]{"Default", "Exact", "Ignore"});
    private JCheckBox exactQueryAtomCheckBox = new JCheckBox("Query atom");
    private JComboBox exactRadicalComboBox = new JComboBox<Object>(new Object[]{"Default", "Exact", "Ignore"});
    private JComboBox doubleBondStereoComboBox = new JComboBox<Object>(new Object[]{"Marked", "All", "None"});
    private JCheckBox queryAbsStereoCheckBox = new JCheckBox("Absolute stereo", true);
    private JCheckBox targetAbsStereoCheckBox = new JCheckBox("Absolute stereo", true);
    private JCheckBox queryChiralCheckBox = new JCheckBox("Chiral flag");
    private JCheckBox targetChiralCheckBox = new JCheckBox("Chiral flag");
    private JComboBox undefinedRAtomComboBox = new JComboBox<Object>(new Object[]{"Group", "Group/H", "Group/H/Empty", "Undefined R", "All (any-atom)"});
    private JCheckBox bridgingRCheckBox = new JCheckBox("Bridging R allowed", false);
    private JCheckBox RLigandEqualityCheckBox = new JCheckBox("R-ligand equality check", false);

    public SearchOptionsPanel() {
        this.init();
    }

    public MolSearchOptions getSearchOptions() throws IllegalArgumentException {
        return this.optionsGUIRadioButton.isSelected() ? this.getSearchOptionsFromGUI() : this.getSearchOptionsFromTextArea();
    }

    public void setSearchOptions(MolSearchOptions mso) {
        this.setSearchOptionsOnGUI(mso);
        this.setSearchOptionsOnTextArea(mso);
    }

    public boolean isQueryAbsStereo() {
        return this.queryChiralCheckBox.isSelected();
    }

    public void setQueryAbsStereo(boolean value) {
        this.queryChiralCheckBox.setSelected(value);
    }

    public boolean isTargetAbsStereo() {
        return this.targetChiralCheckBox.isSelected();
    }

    public void setTargetAbsStereo(boolean value) {
        this.targetChiralCheckBox.setSelected(value);
    }

    private void setSearchOptionsOnGUI(MolSearchOptions mso) {
        int searchType = mso.getSearchType();
        switch (searchType) {
            case 2: {
                this.searchTypeComboBox.setSelectedIndex(0);
                break;
            }
            case 5: {
                this.searchTypeComboBox.setSelectedIndex(1);
                break;
            }
            case 4: {
                this.searchTypeComboBox.setSelectedIndex(2);
                break;
            }
            case 7: {
                this.searchTypeComboBox.setSelectedIndex(3);
            }
        }
        this.orderCheckBox.setSelected(mso.isOrderSensitiveSearch());
        this.tautomerSearchCheckBox.setSelected(mso.getTautomerSearch() == 1);
        this.exactBondCheckBox.setSelected(mso.isExactBondMatching());
        this.exactQueryAtomCheckBox.setSelected(mso.isExactQueryAtomMatching());
        int stereoSearchType = mso.getStereoSearchType();
        switch (stereoSearchType) {
            case 0: {
                this.stereoSearchComboBox.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.stereoSearchComboBox.setSelectedIndex(1);
                break;
            }
            case 1: {
                this.stereoSearchComboBox.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.stereoSearchComboBox.setSelectedIndex(3);
            }
        }
        int hitOrdering = mso.getHitOrdering();
        switch (hitOrdering) {
            case 0: {
                this.hitOrderingComboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.hitOrderingComboBox.setSelectedIndex(1);
            }
        }
        int matching = mso.getChargeMatching();
        switch (matching) {
            case 0: {
                this.exactChargeComboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.exactChargeComboBox.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.exactChargeComboBox.setSelectedIndex(2);
            }
        }
        matching = mso.getIsotopeMatching();
        switch (matching) {
            case 0: {
                this.exactIsotopeComboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.exactIsotopeComboBox.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.exactIsotopeComboBox.setSelectedIndex(2);
            }
        }
        matching = mso.getRadicalMatching();
        switch (matching) {
            case 0: {
                this.exactRadicalComboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.exactRadicalComboBox.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.exactRadicalComboBox.setSelectedIndex(2);
            }
        }
        int dbsMode = mso.getDoubleBondStereoMatchingMode();
        switch (dbsMode) {
            case 1: {
                this.doubleBondStereoComboBox.setSelectedIndex(0);
                break;
            }
            case 0: {
                this.doubleBondStereoComboBox.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.doubleBondStereoComboBox.setSelectedIndex(2);
            }
        }
        this.queryAbsStereoCheckBox.setSelected(mso.isQueryAbsoluteStereo());
        this.targetAbsStereoCheckBox.setSelected(mso.isTargetAbsoluteStereo());
        int undefinedRAtom = mso.getUndefinedRAtom();
        switch (undefinedRAtom) {
            case 2: {
                this.undefinedRAtomComboBox.setSelectedIndex(0);
                break;
            }
            case 3: {
                this.undefinedRAtomComboBox.setSelectedIndex(1);
                break;
            }
            case 4: {
                this.undefinedRAtomComboBox.setSelectedIndex(2);
                break;
            }
            case 1: {
                this.undefinedRAtomComboBox.setSelectedIndex(3);
                break;
            }
            case 0: {
                this.undefinedRAtomComboBox.setSelectedIndex(4);
            }
        }
        boolean enable = mso.isUndefinedRAtomMatchingGroup();
        this.bridgingRCheckBox.setEnabled(enable);
        this.RLigandEqualityCheckBox.setEnabled(enable);
        this.bridgingRCheckBox.setSelected(mso.isBridgingRAllowed());
        this.RLigandEqualityCheckBox.setSelected(mso.getRLigandEqualityCheck());
    }

    private MolSearchOptions getSearchOptionsFromGUI() {
        MolSearchOptions mso = this.getSearchOptionsFromTextArea();
        int searchType = 0;
        switch (this.searchTypeComboBox.getSelectedIndex()) {
            case 0: {
                searchType = 2;
                break;
            }
            case 1: {
                searchType = 5;
                break;
            }
            case 2: {
                searchType = 4;
                break;
            }
            case 3: {
                searchType = 7;
                break;
            }
            case 4: {
                searchType = 6;
            }
        }
        mso.setSearchType(searchType);
        mso.setOrderSensitiveSearch(this.orderCheckBox.isSelected());
        mso.setTautomerSearch(this.tautomerSearchCheckBox.isSelected() ? 1 : 0);
        mso.setExactBondMatching(this.exactBondCheckBox.isSelected());
        mso.setExactQueryAtomMatching(this.exactQueryAtomCheckBox.isSelected());
        int stereoSearchType = 0;
        switch (this.stereoSearchComboBox.getSelectedIndex()) {
            case 0: {
                stereoSearchType = 0;
                break;
            }
            case 1: {
                stereoSearchType = 2;
                break;
            }
            case 2: {
                stereoSearchType = 1;
                break;
            }
            case 3: {
                stereoSearchType = 3;
            }
        }
        mso.setStereoSearchType(stereoSearchType);
        int hitOrdering = 0;
        switch (this.hitOrderingComboBox.getSelectedIndex()) {
            case 0: {
                hitOrdering = 0;
                break;
            }
            case 1: {
                hitOrdering = 1;
            }
        }
        mso.setHitOrdering(hitOrdering);
        int matching = 0;
        switch (this.exactChargeComboBox.getSelectedIndex()) {
            case 0: {
                matching = 0;
                break;
            }
            case 1: {
                matching = 1;
                break;
            }
            case 2: {
                matching = 2;
            }
        }
        mso.setChargeMatching(matching);
        switch (this.exactIsotopeComboBox.getSelectedIndex()) {
            case 0: {
                matching = 0;
                break;
            }
            case 1: {
                matching = 1;
                break;
            }
            case 2: {
                matching = 2;
            }
        }
        mso.setIsotopeMatching(matching);
        switch (this.exactRadicalComboBox.getSelectedIndex()) {
            case 0: {
                matching = 0;
                break;
            }
            case 1: {
                matching = 1;
                break;
            }
            case 2: {
                matching = 2;
            }
        }
        mso.setRadicalMatching(matching);
        int dbsMode = 0;
        switch (this.doubleBondStereoComboBox.getSelectedIndex()) {
            case 0: {
                dbsMode = 1;
                break;
            }
            case 1: {
                dbsMode = 0;
                break;
            }
            case 2: {
                dbsMode = 2;
            }
        }
        mso.setDoubleBondStereoMatchingMode(dbsMode);
        mso.setQueryAbsoluteStereo(this.queryAbsStereoCheckBox.isSelected());
        mso.setTargetAbsoluteStereo(this.targetAbsStereoCheckBox.isSelected());
        int undefinedRAtom = 0;
        switch (this.undefinedRAtomComboBox.getSelectedIndex()) {
            case 0: {
                undefinedRAtom = 2;
                break;
            }
            case 1: {
                undefinedRAtom = 3;
                break;
            }
            case 2: {
                undefinedRAtom = 4;
                break;
            }
            case 3: {
                undefinedRAtom = 1;
                break;
            }
            case 4: {
                undefinedRAtom = 0;
            }
        }
        mso.setUndefinedRAtom(undefinedRAtom);
        mso.setBridgingRAllowed(this.bridgingRCheckBox.isSelected());
        mso.setRLigandEqualityCheck(this.RLigandEqualityCheckBox.isSelected());
        mso.setMarkushEnabled(true);
        mso.setHitIndexType(0);
        return mso;
    }

    private void setSearchOptionsOnTextArea(MolSearchOptions mso) {
        this.optionsTextArea.setText(mso.toString("\n"));
    }

    private MolSearchOptions getSearchOptionsFromTextArea() {
        String options = this.optionsTextArea.getText();
        MolSearchOptions mso = new MolSearchOptions(2);
        if (options.trim().length() > 0) {
            mso.setOptions(options);
        }
        mso.setHitIndexType(0);
        return mso;
    }

    public void showOptions() {
        try {
            MolSearchOptions mso;
            if (this.optionsGUIRadioButton.isSelected()) {
                mso = this.getSearchOptionsFromTextArea();
                this.setSearchOptionsOnGUI(mso);
            } else {
                mso = this.getSearchOptionsFromGUI();
                this.setSearchOptionsOnTextArea(mso);
            }
            CardLayout cl = (CardLayout)this.optionsPanel.getLayout();
            cl.show(this.optionsPanel, this.optionsGUIRadioButton.isSelected() ? OPTIONS_GUI : OPTIONS_TEXT);
        }
        catch (IllegalArgumentException e) {
            this.optionsTextRadioButton.setSelected(true);
            JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid option", 0);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        topPanel.add((Component)new JLabel("Options"), gc);
        ++gc.gridx;
        topPanel.add((Component)this.optionsGUIRadioButton, gc);
        ++gc.gridx;
        topPanel.add((Component)this.optionsTextRadioButton, gc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.optionsGUIRadioButton);
        bg.add(this.optionsTextRadioButton);
        ActionListener optionsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchOptionsPanel.this.showOptions();
            }
        };
        this.optionsGUIRadioButton.addActionListener(optionsActionListener);
        this.optionsTextRadioButton.addActionListener(optionsActionListener);
        gc.gridx = 0;
        ++gc.gridy;
        gc.gridwidth = 3;
        topPanel.add((Component)new JSeparator(), gc);
        this.add((Component)topPanel, "North");
        this.createOptionsPanel();
        this.add((Component)this.optionsPanel, "Center");
    }

    private void createOptionsPanel() {
        this.optionsPanel = new JPanel();
        this.optionsTextArea = new JTextArea();
        this.optionsPanel.setLayout(new CardLayout(1, 1));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)this.optionsTextArea, "Center");
        this.optionsPanel.add((Component)new JScrollPane(textPanel), OPTIONS_TEXT);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.optionsPanel.add((Component)tabbedPane, OPTIONS_GUI);
        tabbedPane.add("General", this.getGeneralPanel());
        tabbedPane.add("Exact matching", this.getExactPanel());
        tabbedPane.add("Stereo", this.getStereoPanel());
        tabbedPane.add("Undefined R-atom", this.getUndefinedRAtomPanel());
    }

    private JPanel getGeneralPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridwidth = 1;
        panel.add((Component)SearchOptionsPanel.getComboPanel("Search type:", this.searchTypeComboBox), gc);
        ++gc.gridy;
        panel.add((Component)SearchOptionsPanel.getComboPanel("Stereo search:", this.stereoSearchComboBox), gc);
        ++gc.gridy;
        panel.add((Component)SearchOptionsPanel.getComboPanel("Hit ordering:", this.hitOrderingComboBox), gc);
        ++gc.gridy;
        panel.add((Component)this.tautomerSearchCheckBox, gc);
        ++gc.gridy;
        panel.add((Component)this.orderCheckBox, gc);
        return panel;
    }

    private JPanel getExactPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridwidth = 1;
        panel.add((Component)this.exactBondCheckBox, gc);
        ++gc.gridy;
        panel.add((Component)this.exactQueryAtomCheckBox, gc);
        ++gc.gridy;
        panel.add((Component)SearchOptionsPanel.getComboPanel(" Charge:", this.exactChargeComboBox), gc);
        ++gc.gridy;
        panel.add((Component)SearchOptionsPanel.getComboPanel("Isotope:", this.exactIsotopeComboBox), gc);
        ++gc.gridy;
        panel.add((Component)SearchOptionsPanel.getComboPanel("Radical:", this.exactRadicalComboBox), gc);
        return panel;
    }

    private JPanel getStereoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        panel.add((Component)SearchOptionsPanel.getComboPanel("Double bond:", this.doubleBondStereoComboBox), gc);
        gc.gridx = 0;
        ++gc.gridy;
        panel.add((Component)new JLabel("Query"), gc);
        ++gc.gridx;
        panel.add((Component)this.queryChiralCheckBox, gc);
        ++gc.gridx;
        panel.add((Component)this.queryAbsStereoCheckBox, gc);
        gc.gridx = 0;
        ++gc.gridy;
        panel.add((Component)new JLabel("Target"), gc);
        ++gc.gridx;
        panel.add((Component)this.targetChiralCheckBox, gc);
        ++gc.gridx;
        panel.add((Component)this.targetAbsStereoCheckBox, gc);
        return panel;
    }

    private JPanel getUndefinedRAtomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = 17;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.gridwidth = 1;
        panel.add((Component)SearchOptionsPanel.getComboPanel("Matching:", this.undefinedRAtomComboBox), gc);
        ++gc.gridy;
        panel.add((Component)this.bridgingRCheckBox, gc);
        ++gc.gridy;
        panel.add((Component)this.RLigandEqualityCheckBox, gc);
        ActionListener undefinedRAtomActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean enable = SearchOptionsPanel.this.undefinedRAtomComboBox.getSelectedIndex() <= 2;
                SearchOptionsPanel.this.bridgingRCheckBox.setEnabled(enable);
                SearchOptionsPanel.this.RLigandEqualityCheckBox.setEnabled(enable);
            }
        };
        this.undefinedRAtomComboBox.addActionListener(undefinedRAtomActionListener);
        return panel;
    }

    private static JPanel getComboPanel(String label, JComboBox combo) {
        JPanel panel = new JPanel();
        panel.add(new JLabel(label));
        panel.add(combo);
        return panel;
    }
}

