/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.common.util.IntVector;
import chemaxon.jchem.gui.MessageDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectPageDialog
extends JDialog {
    private IntVector hits = null;
    private int cellPerPage = 0;
    private int currentPage = 0;
    private JRadioButton pageRadioButton = null;
    private JRadioButton idRadioButton = null;
    private JSpinner pageSpinner = null;
    private JTextField idTextField = null;
    private int selectedPage = 0;

    public SelectPageDialog(IntVector hits, int cellPerPage, int currentPage) {
        try {
            this.hits = hits;
            this.cellPerPage = cellPerPage;
            this.currentPage = currentPage;
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getSelectedPage() {
        return this.selectedPage;
    }

    private void init() throws Exception {
        this.setTitle("Go to");
        int maxPage = (int)Math.ceil((double)this.hits.size() / (double)this.cellPerPage);
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.pageRadioButton = new JRadioButton("Page", true);
        cp.add((Component)this.pageRadioButton, gc);
        ++gc.gridy;
        this.idRadioButton = new JRadioButton("ID  ", false);
        cp.add((Component)this.idRadioButton, gc);
        ++gc.gridy;
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.pageRadioButton);
        bg.add(this.idRadioButton);
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SelectPageDialog.this.updateEnabled();
            }
        };
        this.pageRadioButton.addChangeListener(listener);
        this.idRadioButton.addChangeListener(listener);
        gc.gridy = 0;
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        SpinnerNumberModel sm = new SpinnerNumberModel(this.currentPage, 1, maxPage, 1);
        this.pageSpinner = new JSpinner(sm);
        cp.add((Component)this.pageSpinner, gc);
        ++gc.gridy;
        this.idTextField = new JTextField();
        cp.add((Component)this.idTextField, gc);
        ++gc.gridy;
        gc.fill = 0;
        gc.anchor = 14;
        gc.weighty = 1.0;
        cp.add((Component)this.getOKButton(), gc);
        this.updateEnabled();
        this.pack();
        this.setSize(new Dimension(200, 100));
        this.setResizable(false);
    }

    private JButton getOKButton() {
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPageDialog.this.okPressed();
            }
        });
        return button;
    }

    private void updateEnabled() {
        this.pageSpinner.setEnabled(this.pageRadioButton.isSelected());
        this.idTextField.setEnabled(this.idRadioButton.isSelected());
    }

    private void okPressed() {
        if (this.pageRadioButton.isSelected()) {
            this.selectedPage = (Integer)this.pageSpinner.getModel().getValue();
            this.hide();
        } else if (this.idRadioButton.isSelected()) {
            String idText = this.idTextField.getText();
            int id = 0;
            try {
                id = new Integer(idText);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (id < 1) {
                MessageDialog.showMessage(this, "Invalid ID specified: " + idText);
                return;
            }
            int idx = this.hits.indexOf(id);
            if (idx != -1) {
                this.selectedPage = 1 + idx / this.cellPerPage;
                this.hide();
                return;
            }
            MessageDialog.showMessage(this, "ID not found: " + id);
        }
    }
}

