/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.TransferDialogData;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.gui.MessageDialog;
import chemaxon.jchem.gui.ProgressReporter;
import chemaxon.jchem.gui.TableSetting;
import chemaxon.jchem.gui.TableSettings;
import chemaxon.jchem.gui.TransferDialog;
import chemaxon.util.ConnectionHandler;
import java.awt.Cursor;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TableOptionsSetter
implements Runnable {
    private JFrame parent;
    private ConnectionHandler conh;
    private Properties settings;

    public TableOptionsSetter(JFrame parent, ConnectionHandler conh, Properties settings) {
        this.parent = parent;
        this.conh = conh;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.parent.getJMenuBar().setEnabled(false);
        try {
            Vector<String> tables;
            Cursor prevCursor = this.parent.getCursor();
            this.parent.setCursor(new Cursor(3));
            try {
                tables = new DatabaseProperties(this.conh).getStructureTableNames();
            }
            finally {
                this.parent.setCursor(prevCursor);
            }
            if (tables.size() == 0) {
                MessageDialog.showMessage(this.parent, "There are no structure tables in the database.");
                this.parent.getJMenuBar().setEnabled(true);
                return;
            }
            TransferDialogData tdd = this.selectTableAndOptions(tables);
            if (tdd == null) {
                return;
            }
            ArrayList changedTables = new ArrayList();
            ArrayList tablesToRegenerate = new ArrayList();
            this.getChanges(tdd, changedTables, tablesToRegenerate);
            if (changedTables.size() == 0) {
                return;
            }
            String msg = "Number of tables affected: " + changedTables.size();
            if (tablesToRegenerate.size() > 0) {
                msg = msg + "\n\nTables need recalculation: " + tablesToRegenerate.size();
                msg = msg + "\nRecalculation can take considerable amount of time depending on the size of the tables.";
            }
            if (JOptionPane.showConfirmDialog(this.parent, msg = msg + "\n\n Continue ?", "", 0) == 1) {
                return;
            }
            TableOptionsSetter.applyChanges(this.conh, tdd, this.parent, changedTables, tablesToRegenerate);
        }
        catch (SQLException ex) {
            MessageDialog.showSQLMessage(this.parent, ex);
        }
        catch (Throwable ex) {
            MessageDialog.showErrorMessage(this.parent, ex);
        }
        finally {
            this.parent.getJMenuBar().setEnabled(true);
        }
    }

    private void getChanges(TransferDialogData tdd, ArrayList changedList, ArrayList regenerateList) {
        Vector tables = tdd.tables;
        TableSettings oldSettings = tdd.oldTableSettings;
        TableSettings newSettings = tdd.tableSettings;
        for (int x = 0; x < tables.size(); ++x) {
            String table = (String)tables.get(x);
            boolean changed = false;
            boolean needsRegeneration = false;
            if (oldSettings.getAbsoluteStereoFlag(table) != newSettings.getAbsoluteStereoFlag(table)) {
                changed = true;
            }
            if (!TableOptionsSetter.equals(oldSettings.getStandardization(table), newSettings.getStandardization(table))) {
                changed = true;
                needsRegeneration = true;
            }
            if (oldSettings.getDuplicateFiltering(table) != newSettings.getDuplicateFiltering(table)) {
                changed = true;
            }
            if (oldSettings.getTautomerDuplicateFiltering(table) != newSettings.getTautomerDuplicateFiltering(table)) {
                changed = true;
                needsRegeneration = true;
            }
            if (oldSettings.getTautomerSwitchOffAllProtections(table) != newSettings.getTautomerSwitchOffAllProtections(table)) {
                changed = true;
                needsRegeneration = true;
            }
            if (changed) {
                changedList.add(table);
            }
            if (!needsRegeneration) continue;
            regenerateList.add(table);
        }
    }

    private static boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyChanges(ConnectionHandler conh, TransferDialogData tdd, JFrame parent, ArrayList changedTables, ArrayList tablesToRegenerate) {
        try {
            TableSettings oldSettings = tdd.oldTableSettings;
            TableSettings newSettings = tdd.tableSettings;
            DatabaseProperties dbProp = new DatabaseProperties(conh);
            for (int x = 0; x < changedTables.size(); ++x) {
                String newStdConfig;
                boolean newSwitchOffAllProts;
                boolean newTautomerFiltering;
                boolean newDuplicateFiltering;
                boolean newAbsStereo;
                String tableName = (String)changedTables.get(x);
                boolean oldAbsStereo = oldSettings.getAbsoluteStereoFlag(tableName);
                if (oldAbsStereo != (newAbsStereo = oldSettings.getAbsoluteStereoFlag(tableName))) {
                    dbProp.setAbsoluteStereoOption(tableName, newAbsStereo);
                }
                Boolean duplicateFiltering = null;
                boolean oldDuplicateFiltering = oldSettings.getDuplicateFiltering(tableName);
                if (oldDuplicateFiltering != (newDuplicateFiltering = newSettings.getDuplicateFiltering(tableName))) {
                    duplicateFiltering = newDuplicateFiltering;
                }
                Boolean tautomerFiltering = null;
                boolean oldTautomerFiltering = oldSettings.getTautomerDuplicateFiltering(tableName);
                if (oldTautomerFiltering != (newTautomerFiltering = newSettings.getTautomerDuplicateFiltering(tableName))) {
                    tautomerFiltering = newTautomerFiltering;
                }
                Boolean tautomerSwitchOffAllProts = null;
                boolean oldSwitchOffAllProts = oldSettings.getTautomerSwitchOffAllProtections(tableName);
                if (oldSwitchOffAllProts != (newSwitchOffAllProts = newSettings.getTautomerSwitchOffAllProtections(tableName))) {
                    tautomerSwitchOffAllProts = newSwitchOffAllProts;
                }
                boolean changeStandardization = false;
                String oldStdConfig = oldSettings.getStandardization(tableName);
                if (!TableOptionsSetter.equals(oldStdConfig, newStdConfig = newSettings.getStandardization(tableName))) {
                    changeStandardization = true;
                }
                ProgressReporter m = new ProgressReporter(parent, "Recalculating " + tableName + " ...", "Molecule: ", true, 1L, 1L);
                Cursor prevCursor = null;
                if (parent != null) {
                    prevCursor = parent.getCursor();
                    parent.setCursor(new Cursor(3));
                    parent.setEnabled(false);
                }
                boolean canceled = false;
                try {
                    if (tablesToRegenerate.contains(tableName)) {
                        UpdateHandler.recalculateTable(conh, tableName, changeStandardization, newStdConfig, null, tautomerFiltering, m);
                    }
                    if (duplicateFiltering != null) {
                        dbProp.setDuplicateFilteringOption(tableName, duplicateFiltering);
                    }
                    if (tautomerSwitchOffAllProts != null) {
                        dbProp.setTableProperty(tableName, "switchOffAllProtections", tautomerSwitchOffAllProts.toString());
                    }
                    if (m.isCanceled()) {
                        canceled = true;
                    }
                }
                finally {
                    if (parent != null) {
                        parent.setCursor(prevCursor);
                        parent.setEnabled(true);
                    }
                    m.close();
                }
                if (!canceled) continue;
                MessageDialog.showMessage(parent, "Recalculation cancelled");
                break;
            }
        }
        catch (SQLException ex) {
            MessageDialog.showSQLMessage(parent, ex);
        }
        catch (Throwable ex) {
            MessageDialog.showErrorMessage(parent, ex);
        }
        finally {
            if (parent != null) {
                parent.getJMenuBar().setEnabled(true);
            }
        }
    }

    private TableSettings getTableSettings(Vector tables) throws SQLException {
        TableSettings tableSettings = new TableSettings();
        for (int x = 0; x < tables.size(); ++x) {
            String tableName = (String)tables.get(x);
            TableSetting ts = new TableSetting();
            ts.absoluteStereo = TableInfo.isAbsoluteStereo(this.conh, tableName);
            DatabaseProperties dbProp = new DatabaseProperties(this.conh);
            ts.tautomerDuplicateFiltering = dbProp.isTautomerDuplicateFilteringEnabled(tableName);
            ts.tautomerSwitchOffAllProtections = dbProp.isSetSwitchOffAllProtectionsForTDF(tableName);
            boolean dfOption = false;
            dfOption = dbProp.isDuplicateFilteringOption(tableName);
            ts.duplicateFiltering = dfOption ? dfOption : false;
            ts.stdConfig = TableInfo.getStandardizerConfig(this.conh, tableName);
            tableSettings.addTable(tableName, ts);
        }
        return tableSettings;
    }

    private TransferDialogData selectTableAndOptions(Vector tables) throws SQLException {
        TransferDialogData tdd = TransferDialogData.getFromSettings(this.settings, 4);
        tdd.tables = tables;
        tdd.tableSettings = this.getTableSettings(tables);
        tdd.oldTableSettings = (TableSettings)tdd.tableSettings.clone();
        TransferDialog d = new TransferDialog((Frame)this.parent, 4, this.conh);
        d.setData(tdd);
        d.show();
        tdd = d.getData();
        if (tdd != null) {
            tdd.save(this.settings);
        }
        return tdd;
    }
}

