/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.TransferDialogData;
import chemaxon.jchem.file.FileInfo;
import chemaxon.jchem.gui.StandardizationChooser;
import chemaxon.jchem.gui.StructureFileFilter;
import chemaxon.jchem.gui.TableSettings;
import chemaxon.jchem.gui.WholeNumberField;
import chemaxon.util.ConnectionHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class TransferDialog
extends JDialog
implements CaretListener,
ChangeListener,
ActionListener,
ItemListener {
    private int type;
    private JPanel dialogContentPane = null;
    private JButton cancelButton = null;
    private JButton okButton = null;
    private JComboBox tableComboBox = null;
    private JButton browseButton = null;
    private JTextField fileNameTextField = null;
    private JFileChooser fileChooser = null;
    boolean isNextPressed = false;
    private WholeNumberField numberOfRecordsField = null;
    private JCheckBox wholeFileCheckBox = null;
    private JCheckBox isHaltAtErrorCheckBox = null;
    private JLabel areDuplicateStructuresAllowed = null;
    private JCheckBox chiralFlagCheckBox = null;
    private JCheckBox allowEmptyStructuresCheckBox = null;
    private JRadioButton dropTableRadioButton = null;
    private JRadioButton deleteRowsRadioButton = null;
    private ButtonGroup deleteButtonGroup = null;
    private JTextField deleteWhereTextField = null;
    private JCheckBox regenerateAllCheckBox = null;
    private JCheckBox regenTableCheckBox = null;
    private JCheckBox regenCTCheckBox = null;
    private JCheckBox regenMDCheckBox = null;
    private JCheckBox absoluteStereoCheckBox = null;
    private JCheckBox tautomerFilteringCheckBox = null;
    private JCheckBox tautomerSwitchOffAllProtectionsCheckBox = null;
    private JCheckBox duplicateFilteringCheckBox = null;
    private ConnectionHandler conh = null;
    private TableSettings tableSettings = null;
    private TableSettings oldTableSettings = null;
    private String currentTableSelection = null;
    private StandardizationChooser stChooser = null;
    private HashMap<Integer, StructureFileFilter> filters = new HashMap();

    public TransferDialog(Frame owner, int type, ConnectionHandler conh) {
        super(owner);
        this.type = type;
        this.conh = conh;
        this.initialize();
    }

    public TransferDialog(Frame owner, int type) {
        this(owner, type, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.textsFilledCheck();
        if (e.getSource() == this.getBrowseButton()) {
            this.connBrowsePressed();
        }
        if (e.getSource() == this.getCancelButton()) {
            this.connCancelPressed();
        }
        if (e.getSource() == this.getOKButton()) {
            this.okPressed();
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (e.getSource() == this.getFileNameTextField()) {
            this.connFileTextFieldAction();
        }
    }

    private int connBrowsePressed() {
        int connBrowsePressedResult = 0;
        try {
            int n = connBrowsePressedResult = this.type == 0 ? this.getFileChooser().showOpenDialog(this) : this.getFileChooser().showSaveDialog(this);
            if (connBrowsePressedResult == 0) {
                String fileName = this.getFileChooser().getSelectedFile().getAbsolutePath();
                int format2 = FileInfo.getFormat(fileName);
                if (this.type == 1 && format2 == -1) {
                    FileFilter sf = this.fileChooser.getFileFilter();
                    if (sf instanceof StructureFileFilter) {
                        Set<String> extensions = ((StructureFileFilter)sf).getAllExtensions();
                        fileName = !sf.getDescription().equals("All supported structure files") && extensions.size() > 0 ? fileName + "." + extensions.iterator().next() : fileName + ".mrv";
                    } else {
                        fileName = fileName + ".mrv";
                    }
                    format2 = FileInfo.getFormat(fileName);
                }
                this.getFileNameTextField().setText(fileName);
                if (this.filters.containsKey(format2)) {
                    this.fileChooser.setFileFilter(this.filters.get(format2));
                }
            }
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
        }
        return connBrowsePressedResult;
    }

    private void connCancelPressed() {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
        }
    }

    private void connEtoC1() {
        try {
            this.wholeFileCheckBox_StateChanged(null);
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
        }
    }

    private void connFileTextFieldAction() {
        try {
            this.textsFilledCheck();
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
        }
    }

    private void okPressed() {
        if (this.stChooser != null) {
            this.tableSettings.setStandardization(this.currentTableSelection, this.stChooser.getConfig());
        }
        this.isNextPressed = true;
        try {
            this.setVisible(false);
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
        }
    }

    private void connTableComboBoxAction() {
        try {
            this.textsFilledCheck();
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
        }
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            try {
                this.browseButton = new JButton();
                this.browseButton.setName("BrowseButton");
                this.browseButton.setText("Browse");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.browseButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            try {
                this.cancelButton = new JButton();
                this.cancelButton.setName("CancelButton");
                this.cancelButton.setText("Cancel");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.cancelButton;
    }

    private JRadioButton getDropTableRadioButton() {
        if (this.dropTableRadioButton == null) {
            try {
                this.dropTableRadioButton = new JRadioButton();
                this.dropTableRadioButton.setName("DropTableRadioButton");
                this.dropTableRadioButton.setText("Drop table");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.dropTableRadioButton;
    }

    private JRadioButton getDeleteRowsRadioButton() {
        if (this.deleteRowsRadioButton == null) {
            try {
                this.deleteRowsRadioButton = new JRadioButton();
                this.deleteRowsRadioButton.setName("DeleteRowsRadioButton");
                this.deleteRowsRadioButton.setText("Delete rows WHERE");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.deleteRowsRadioButton;
    }

    private ButtonGroup getDeleteButtonGroup() {
        if (this.deleteButtonGroup == null) {
            try {
                this.deleteButtonGroup = new ButtonGroup();
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.deleteButtonGroup;
    }

    private JTextField getDeleteWhereTextField() {
        if (this.deleteWhereTextField == null) {
            try {
                this.deleteWhereTextField = new JTextField();
                this.deleteWhereTextField.setName("DeleteWhereTextField");
                this.deleteWhereTextField.setToolTipText("SQL WHERE statement (e.g: \"CD_ID<1000 OR CD_MOLWEIGHT<200\")");
                this.deleteWhereTextField.setText("");
                this.deleteWhereTextField.setPreferredSize(new Dimension(300, 20));
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.deleteWhereTextField;
    }

    private JCheckBox getRegenerateAllCheckBox() {
        if (this.regenerateAllCheckBox == null) {
            try {
                this.regenerateAllCheckBox = new JCheckBox();
                this.regenerateAllCheckBox.setName("RegenerateAllCheckBox");
                this.regenerateAllCheckBox.setText("Recalculate all tables");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.regenerateAllCheckBox;
    }

    private void getRegenerateOptionsCheckBoxes() {
        try {
            this.regenTableCheckBox = new JCheckBox();
            this.regenTableCheckBox.setText("JChem table (without Chemical Terms and Molecular Descriptors)");
            this.regenTableCheckBox.setSelected(true);
            this.regenCTCheckBox = new JCheckBox();
            this.regenCTCheckBox.setText("Chemical Terms");
            this.regenMDCheckBox = new JCheckBox();
            this.regenMDCheckBox.setText("Molecular Descriptors");
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
        }
    }

    public TransferDialogData getData() {
        if (this.isNextPressed) {
            TransferDialogData tdd = new TransferDialogData(this.type);
            for (int i = 0; i < this.tableComboBox.getItemCount(); ++i) {
                tdd.tables.addElement(this.tableComboBox.getItemAt(i));
            }
            tdd.selectedTable = (String)this.tableComboBox.getSelectedItem();
            if (this.type == 1 || this.type == 0) {
                tdd.fileName = this.fileNameTextField.getText();
            }
            if (this.type == 0) {
                if (this.wholeFileCheckBox.isSelected() || this.fileNameTextField.getText().equals("")) {
                    tdd.numberOfRecords = 0;
                } else {
                    tdd.numberOfRecords = this.numberOfRecordsField.getValue();
                    if (tdd.numberOfRecords == 0) {
                        tdd.numberOfRecords = 1;
                    }
                }
                tdd.isHaltAtError = this.isHaltAtErrorCheckBox.isSelected();
                tdd.setChiralFlag = this.chiralFlagCheckBox.isSelected();
                tdd.allowEmptyStructures = this.allowEmptyStructuresCheckBox.isSelected();
            }
            if (this.type == 2) {
                tdd.isDrop = this.dropTableRadioButton.isSelected();
                tdd.deleteWhereString = this.deleteWhereTextField.getText();
            }
            if (this.type == 3) {
                tdd.regenerateAll = this.regenerateAllCheckBox.isSelected();
                tdd.regenerationOptions = new HashMap<Integer, Boolean>();
                tdd.regenerationOptions.put(2, this.regenTableCheckBox.isEnabled() && this.regenTableCheckBox.isSelected());
                tdd.regenerationOptions.put(1, this.regenCTCheckBox.isEnabled() && this.regenCTCheckBox.isSelected());
                tdd.regenerationOptions.put(3, this.regenMDCheckBox.isEnabled() && this.regenMDCheckBox.isSelected());
            }
            if (this.type == 4) {
                tdd.tableSettings = this.tableSettings;
                tdd.oldTableSettings = this.oldTableSettings;
            }
            return tdd;
        }
        return null;
    }

    private JFileChooser getFileChooser() {
        return this.getFileChooser(null);
    }

    private JFileChooser getFileChooser(String fileName) {
        File file;
        if (this.fileChooser == null) {
            try {
                this.fileChooser = new JFileChooser();
                file = null;
                if (fileName != null) {
                    file = new File(fileName);
                }
                this.fileChooser.setFileSelectionMode(0);
                this.fileChooser.setName("FileChooser");
                StructureFileFilter filter = new StructureFileFilter(new String[]{"sd", "sdf", "jtf", "smi", "sma", "cxsmiles", "cxmarts", "mol", "mol2", "inchi", "rd", "rdf", "rxn", "vmn", "mrv"}, "All supported structure files");
                filter.setExtensionListInDescription(false);
                this.fileChooser.addChoosableFileFilter(filter);
                StructureFileFilter def = filter;
                filter = new StructureFileFilter(new String[]{"sd", "sdf"}, "MDL SDfiles");
                this.filters.put(2, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                filter = new StructureFileFilter("jtf", "JChem Table Format");
                this.filters.put(4, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("smi", "Daylight SMILES files");
                this.filters.put(3, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("sma", "Daylight SMARTS files");
                this.filters.put(11, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("cxsmiles", "ChemAxon CXSMILES files");
                this.filters.put(12, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("cxsmarts", "ChemAxon CXSMARTS files");
                this.filters.put(13, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("mol", "MDL Molfiles");
                this.filters.put(1, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("mol2", "Tripos Mol2 files");
                this.filters.put(8, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("inchi", "IUPAC InChI files");
                this.filters.put(9, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter(new String[]{"rdf", "rd"}, "MDL RDfiles");
                this.filters.put(5, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("rxn", "MDL Rxnfiles");
                this.filters.put(7, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("vmn", "Markush DARC format");
                this.filters.put(10, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                filter = new StructureFileFilter("mrv", "Marvin document");
                this.filters.put(6, filter);
                this.fileChooser.addChoosableFileFilter(filter);
                if (filter.accept(file)) {
                    def = filter;
                }
                this.fileChooser.setFileFilter(def);
                if (this.type == 0) {
                    this.fileChooser.setDialogTitle("Choose File to Import");
                } else {
                    this.fileChooser.setDialogTitle("Choose File to Export");
                }
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        if (fileName != null && !fileName.equals("")) {
            file = new File(fileName);
            this.fileChooser.setSelectedFile(file);
        }
        return this.fileChooser;
    }

    private JTextField getFileNameTextField() {
        if (this.fileNameTextField == null) {
            try {
                this.fileNameTextField = new JTextField();
                this.fileNameTextField.setName("FileNameTextField");
                this.fileNameTextField.setToolTipText("Path of " + (this.type == 0 ? "input" : "output") + " file");
                this.fileNameTextField.setText("");
                this.fileNameTextField.setPreferredSize(new Dimension(300, 20));
                this.fileNameTextField.setEnabled(false);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.fileNameTextField;
    }

    private void addToGrid(JPanel pane, Component comp, GridBagLayout g, GridBagConstraints c) {
        g.setConstraints(comp, c);
        pane.add(comp);
    }

    private JCheckBox getAbsoluteStereoCheckBox() {
        if (this.absoluteStereoCheckBox == null) {
            this.absoluteStereoCheckBox = new JCheckBox("Assume absolute stereo flag");
        }
        this.absoluteStereoCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferDialog.this.tableSettings.setAbsoluteStereoFlag(TransferDialog.this.currentTableSelection, TransferDialog.this.absoluteStereoCheckBox.isSelected());
            }
        });
        return this.absoluteStereoCheckBox;
    }

    private JCheckBox getTautomerFilteringCheckBox() {
        if (this.tautomerFilteringCheckBox == null) {
            this.tautomerFilteringCheckBox = new JCheckBox("Duplicate search uses tautomers");
            this.tautomerFilteringCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransferDialog.this.tableSettings.setTautomerDuplicateFiltering(TransferDialog.this.currentTableSelection, TransferDialog.this.tautomerFilteringCheckBox.isSelected());
                    TransferDialog.this.tautomerSwitchOffAllProtectionsCheckBox.setEnabled(TransferDialog.this.tautomerFilteringCheckBox.isSelected());
                }
            });
        }
        return this.tautomerFilteringCheckBox;
    }

    private JCheckBox getTautomerSwitchOffAllProtectionsCheckBox() {
        if (this.tautomerSwitchOffAllProtectionsCheckBox == null) {
            this.tautomerSwitchOffAllProtectionsCheckBox = new JCheckBox("Switch off all protections");
            this.tautomerSwitchOffAllProtectionsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransferDialog.this.tableSettings.setTautomerSwitchOffAllProtections(TransferDialog.this.currentTableSelection, TransferDialog.this.tautomerSwitchOffAllProtectionsCheckBox.isSelected());
                }
            });
        }
        return this.tautomerSwitchOffAllProtectionsCheckBox;
    }

    private JCheckBox getDuplicateFilteringCheckBox() {
        if (this.duplicateFilteringCheckBox == null) {
            this.duplicateFilteringCheckBox = new JCheckBox("Filter out duplicate structures");
            this.duplicateFilteringCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransferDialog.this.tableSettings.setDuplicateFiltering(TransferDialog.this.currentTableSelection, TransferDialog.this.duplicateFilteringCheckBox.isSelected());
                }
            });
        }
        return this.duplicateFilteringCheckBox;
    }

    private JPanel getDialogContentPane() {
        if (this.dialogContentPane == null) {
            try {
                this.dialogContentPane = new JPanel();
                this.dialogContentPane.setName("JDialogContentPane");
                this.dialogContentPane.setLayout(new BorderLayout(10, 10));
                JPanel textPane = new JPanel();
                GridBagLayout g = new GridBagLayout();
                textPane.setLayout(g);
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.insets = new Insets(5, 5, 5, 5);
                c.gridwidth = 1;
                this.addToGrid(textPane, new JLabel("Database table: "), g, c);
                c.gridwidth = 3;
                this.addToGrid(textPane, this.getTableComboBox(), g, c);
                c.gridwidth = 0;
                this.addToGrid(textPane, Box.createRigidArea(new Dimension(10, 10)), g, c);
                if (this.type == 4) {
                    this.stChooser = new StandardizationChooser(this, this.conh, (String)this.getTableComboBox().getSelectedItem());
                    this.addToGrid(textPane, this.getAbsoluteStereoCheckBox(), g, c);
                    this.addToGrid(textPane, this.getDuplicateFilteringCheckBox(), g, c);
                    this.addToGrid(textPane, this.getTautomerFilteringCheckBox(), g, c);
                    this.addToGrid(textPane, this.getTautomerSwitchOffAllProtectionsCheckBox(), g, c);
                    this.addToGrid(textPane, this.stChooser.getPanel(), g, c);
                }
                if (this.type == 3) {
                    this.getRegenerateAllCheckBox();
                    this.addToGrid(textPane, this.regenerateAllCheckBox, g, c);
                    JLabel regenMode = new JLabel("Recalculation Options:");
                    this.addToGrid(textPane, regenMode, g, c);
                    this.getRegenerateOptionsCheckBoxes();
                    c.insets = new Insets(0, 5, 0, 5);
                    this.addToGrid(textPane, this.regenTableCheckBox, g, c);
                    this.addToGrid(textPane, this.regenCTCheckBox, g, c);
                    this.addToGrid(textPane, this.regenMDCheckBox, g, c);
                    ActionListener listener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TransferDialog.this.tableComboBox.setEnabled(!TransferDialog.this.regenerateAllCheckBox.isSelected());
                            try {
                                TransferDialog.this.enableRegenButtonsCheck();
                            }
                            catch (SQLException e1) {
                                e1.printStackTrace();
                            }
                            TransferDialog.this.textsFilledCheck();
                        }
                    };
                    this.regenerateAllCheckBox.addActionListener(listener);
                }
                if (this.type == 2) {
                    this.getDropTableRadioButton();
                    this.getDeleteRowsRadioButton();
                    this.getDeleteButtonGroup();
                    this.getDeleteWhereTextField();
                    this.deleteButtonGroup.add(this.deleteRowsRadioButton);
                    this.deleteButtonGroup.add(this.dropTableRadioButton);
                    this.deleteRowsRadioButton.setSelected(true);
                    ActionListener listener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TransferDialog.this.deleteWhereTextField.setEnabled(TransferDialog.this.deleteRowsRadioButton.isSelected());
                            if (TransferDialog.this.deleteRowsRadioButton.isSelected()) {
                                TransferDialog.this.deleteWhereTextField.setBackground(Color.white);
                            } else {
                                TransferDialog.this.deleteWhereTextField.setBackground(Color.lightGray);
                            }
                        }
                    };
                    this.deleteRowsRadioButton.addActionListener(listener);
                    this.dropTableRadioButton.addActionListener(listener);
                    c.gridwidth = 1;
                    this.addToGrid(textPane, this.deleteRowsRadioButton, g, c);
                    c.gridwidth = 0;
                    this.addToGrid(textPane, this.deleteWhereTextField, g, c);
                    this.addToGrid(textPane, this.dropTableRadioButton, g, c);
                }
                if (this.type == 0 || this.type == 1) {
                    c.gridwidth = 1;
                    this.addToGrid(textPane, new JLabel((this.type == 0 ? "Input" : "Output") + " file: "), g, c);
                    c.gridwidth = 3;
                    this.addToGrid(textPane, this.getFileNameTextField(), g, c);
                    c.gridwidth = 0;
                    this.addToGrid(textPane, this.getBrowseButton(), g, c);
                }
                if (this.type == 0) {
                    c.gridwidth = 0;
                    this.addToGrid(textPane, this.getLinesToCheckPanel(), g, c);
                    c.gridwidth = 2;
                    this.addToGrid(textPane, this.getHaltAtErrorCheckBox(), g, c);
                    this.addToGrid(textPane, this.getAreDuplicateStructuresAllowedInfo(), g, c);
                    c.gridwidth = 0;
                    this.addToGrid(textPane, new JLabel(""), g, c);
                    c.gridwidth = 2;
                    this.addToGrid(textPane, this.getChiralFlagCheckBox(), g, c);
                    this.addToGrid(textPane, this.getAllowEmptyStructuresCheckBox(), g, c);
                    c.gridwidth = 0;
                    this.addToGrid(textPane, new JLabel(""), g, c);
                }
                JPanel buttonPane = new JPanel();
                buttonPane.setLayout(new BoxLayout(buttonPane, 0));
                buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
                buttonPane.add(Box.createHorizontalGlue());
                buttonPane.add(this.getOKButton());
                buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPane.add(this.getCancelButton());
                this.dialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "North");
                this.dialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "East");
                this.dialogContentPane.add(Box.createRigidArea(new Dimension(10, 10)), "West");
                this.dialogContentPane.add((Component)textPane, "Center");
                this.dialogContentPane.add((Component)buttonPane, "South");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.dialogContentPane;
    }

    private JPanel getLinesToCheckPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new BevelBorder(0));
        GridBagLayout g = new GridBagLayout();
        panel.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.gridwidth = 2;
        panel.add((Component)this.getWholeFileCheckBox(), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.anchor = 13;
        panel.add((Component)new JLabel("Number of records to check: "), c);
        ++c.gridx;
        c.weightx = 0.0;
        panel.add((Component)this.getNumberOfRecordsField(), c);
        return panel;
    }

    private JButton getOKButton() {
        if (this.okButton == null) {
            try {
                this.okButton = new JButton();
                this.okButton.setName("OKButton");
                this.okButton.setText("Ok");
                this.okButton.setEnabled(false);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.okButton;
    }

    private WholeNumberField getNumberOfRecordsField() {
        if (this.numberOfRecordsField == null) {
            try {
                this.numberOfRecordsField = new WholeNumberField();
                this.numberOfRecordsField.setName("NumberOfRecordsField");
                this.numberOfRecordsField.setToolTipText("Number of records to check for type and field names in file");
                this.numberOfRecordsField.setPreferredSize(new Dimension(50, 20));
                this.numberOfRecordsField.setEnabled(false);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.numberOfRecordsField;
    }

    private JComboBox getTableComboBox() {
        if (this.tableComboBox == null) {
            try {
                this.tableComboBox = new JComboBox();
                this.tableComboBox.setName("TableComboBox");
                String toolTip = "Table name";
                if (this.type == 0) {
                    toolTip = "Name of table where the file will be imported into";
                } else if (this.type == 1) {
                    toolTip = "Name of table to export from";
                } else if (this.type == 3) {
                    toolTip = "Name of table to recalculate";
                }
                this.tableComboBox.setToolTipText(toolTip);
                this.tableComboBox.setPreferredSize(new Dimension(200, 25));
                this.tableComboBox.setEditable(false);
                this.tableComboBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TransferDialog.this.tableSelectionChanged();
                    }
                });
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.tableComboBox;
    }

    private JCheckBox getWholeFileCheckBox() {
        if (this.wholeFileCheckBox == null) {
            try {
                this.wholeFileCheckBox = new JCheckBox();
                this.wholeFileCheckBox.setName("WholeFileCheckBox");
                this.wholeFileCheckBox.setSelected(true);
                this.wholeFileCheckBox.setText("Check whole file for field names in selected file");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.wholeFileCheckBox;
    }

    private JCheckBox getHaltAtErrorCheckBox() {
        if (this.isHaltAtErrorCheckBox == null) {
            try {
                this.isHaltAtErrorCheckBox = new JCheckBox();
                this.isHaltAtErrorCheckBox.setName("IsHaltAtErrorCheckBox");
                this.isHaltAtErrorCheckBox.setSelected(true);
                this.isHaltAtErrorCheckBox.setText("Halt if an error occurs");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.isHaltAtErrorCheckBox;
    }

    private JLabel getAreDuplicateStructuresAllowedInfo() {
        try {
            this.areDuplicateStructuresAllowed = new JLabel();
            this.areDuplicateStructuresAllowed.setText("Duplicate filtering has been a table option since version 5.4.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.areDuplicateStructuresAllowed;
    }

    private JCheckBox getChiralFlagCheckBox() {
        if (this.chiralFlagCheckBox == null) {
            try {
                this.chiralFlagCheckBox = new JCheckBox();
                this.chiralFlagCheckBox.setName("ChiralFlagCheckBox");
                this.chiralFlagCheckBox.setSelected(false);
                this.chiralFlagCheckBox.setText("Set chiral flag for MDL formats");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.chiralFlagCheckBox;
    }

    private JCheckBox getAllowEmptyStructuresCheckBox() {
        if (this.allowEmptyStructuresCheckBox == null) {
            try {
                this.allowEmptyStructuresCheckBox = new JCheckBox();
                this.allowEmptyStructuresCheckBox.setName("AllowEmptyStructuresCheckBox");
                this.allowEmptyStructuresCheckBox.setSelected(true);
                this.allowEmptyStructuresCheckBox.setText("Allow empty structures");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.allowEmptyStructuresCheckBox;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
        this.getBrowseButton().addActionListener(this);
        this.getCancelButton().addActionListener(this);
        this.getOKButton().addActionListener(this);
        this.getTableComboBox().addItemListener(this);
        if (this.type == 0 || this.type == 1) {
            this.getFileNameTextField().addCaretListener(this);
        }
        if (this.type == 0) {
            this.getWholeFileCheckBox().addChangeListener(this);
        }
    }

    private void initialize() {
        switch (this.type) {
            case 0: {
                this.setTitle("Import");
                break;
            }
            case 1: {
                this.setTitle("Export");
                break;
            }
            case 2: {
                this.setTitle("Delete");
                break;
            }
            case 3: {
                this.setTitle("Recalculate");
                break;
            }
            case 4: {
                this.setTitle("Table Options");
            }
        }
        this.setName("TransferDialog");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(true);
        JPanel dialogContentPane = this.getDialogContentPane();
        this.setContentPane(dialogContentPane);
        this.initConnections();
        this.pack();
        this.setResizable(false);
        this.isNextPressed = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getTableComboBox()) {
            this.connTableComboBoxAction();
        }
    }

    private void tableSelectionChanged() {
        try {
            if (this.type == 4) {
                String tableName = (String)this.tableComboBox.getSelectedItem();
                this.absoluteStereoCheckBox.setSelected(this.tableSettings.getAbsoluteStereoFlag(tableName));
                this.tautomerFilteringCheckBox.setSelected(this.tableSettings.getTautomerDuplicateFiltering(tableName));
                this.tautomerSwitchOffAllProtectionsCheckBox.setEnabled(this.tautomerFilteringCheckBox.isSelected());
                this.tautomerSwitchOffAllProtectionsCheckBox.setSelected(this.tableSettings.getTautomerSwitchOffAllProtections(tableName));
                this.duplicateFilteringCheckBox.setSelected(this.tableSettings.getDuplicateFiltering(tableName));
                this.currentTableSelection = tableName;
                int tableType = new DatabaseProperties(this.conh, false).getTableType(tableName);
                String category = "molecule";
                if (tableType == 4) {
                    category = "query";
                } else if (tableType == 1) {
                    category = "reaction";
                }
                this.stChooser.setTableName(tableName);
                this.stChooser.setCategory(category);
            } else if (this.type == 3) {
                this.enableRegenButtonsCheck();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(TransferDialogData tdd) {
        Enumeration e = tdd.tables.elements();
        this.tableSettings = tdd.tableSettings;
        this.oldTableSettings = tdd.oldTableSettings;
        if (this.type == 4 && tdd.selectedTable == null) {
            tdd.selectedTable = (String)tdd.tables.firstElement();
        }
        while (e.hasMoreElements()) {
            this.getTableComboBox().addItem(e.nextElement());
        }
        this.getTableComboBox().setSelectedItem(tdd.selectedTable);
        if (this.type == 0 || this.type == 1) {
            this.getFileNameTextField().setText(tdd.fileName);
            this.getFileChooser(tdd.fileName);
        }
        if (this.type == 0) {
            this.getWholeFileCheckBox().setSelected(tdd.numberOfRecords == 0);
            this.getNumberOfRecordsField().setValue(tdd.numberOfRecords);
            this.getHaltAtErrorCheckBox().setSelected(tdd.isHaltAtError);
            this.getChiralFlagCheckBox().setSelected(tdd.setChiralFlag);
            this.getAllowEmptyStructuresCheckBox().setSelected(tdd.allowEmptyStructures);
        }
        this.textsFilledCheck();
        this.isNextPressed = false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.getWholeFileCheckBox()) {
            this.connEtoC1();
        }
    }

    public void enableRegenButtonsCheck() throws SQLException {
        DatabaseProperties dbProps = new DatabaseProperties(this.conh, false);
        if (this.regenerateAllCheckBox.isSelected()) {
            boolean isMD = dbProps.isMolecularDescriptorDefined();
            boolean isCT = dbProps.isChemTermColumnDefined();
            this.regenMDCheckBox.setEnabled(isMD);
            this.regenMDCheckBox.setSelected(isMD);
            this.regenCTCheckBox.setEnabled(isCT);
            this.regenCTCheckBox.setSelected(isCT);
        } else {
            String tableName = (String)this.tableComboBox.getSelectedItem();
            boolean isMD = dbProps.getMolecularDescriptors(tableName).length > 0;
            boolean isCT = dbProps.getChemTermColumns(tableName).length > 0;
            this.regenMDCheckBox.setEnabled(isMD);
            this.regenMDCheckBox.setSelected(isMD);
            this.regenCTCheckBox.setEnabled(isCT);
            this.regenCTCheckBox.setSelected(isCT);
        }
    }

    public void textsFilledCheck() {
        boolean enabled = false;
        if (this.type == 2 || this.type == 3 || this.type == 4) {
            String s1 = (String)this.getTableComboBox().getSelectedItem();
            boolean bl = enabled = s1 != null && !s1.equals("");
            if (this.regenerateAllCheckBox != null && this.regenerateAllCheckBox.isSelected()) {
                enabled = true;
            }
        } else {
            String s1 = (String)this.getTableComboBox().getSelectedItem();
            String s2 = this.getFileNameTextField().getText();
            enabled = s1 != null && !s1.equals("") && s2 != null && !s2.equals("");
        }
        this.getOKButton().setEnabled(enabled);
    }

    public void wholeFileCheckBox_StateChanged(ChangeEvent stateChangeEvent) {
        this.getNumberOfRecordsField().setEnabled(!this.getWholeFileCheckBox().isSelected());
    }
}

