/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.gui;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WholeNumberField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

    public WholeNumberField() {
        this(0, 7);
    }

    public WholeNumberField(int value, int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
        this.integerFormatter.setGroupingUsed(false);
        this.setValue(value);
    }

    @Override
    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    public int getValue() {
        int retVal = 0;
        try {
            retVal = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException e) {
            this.toolkit.beep();
        }
        return retVal;
    }

    public void setValue(int value) {
        this.setText(this.integerFormatter.format(value));
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                WholeNumberField.this.toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

