/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop;

import chemaxon.util.StringConverter;
import chemaxon.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

public class JChemServerProperties
extends Properties {
    public static final String THREADS_PER_CALL_KEY_SEARCH = "jcsearchthreadspercall";
    public static final String THREADS_PER_CALL_KEY_REACT = "jcReactThreadsPerCall";
    public static final String THREADS_PER_CALL_KEY_INDEXING = "indexingThreadsPerCall";
    public static final String JCHEM_SERVER_RMI_PORT = "jchem.server.rmi.port";
    protected String propsFileName;
    private boolean jcSearchInfoToStdError;

    public JChemServerProperties(String propsFileName) {
        this.propsFileName = propsFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() throws IOException {
        File propsFile = new File(this.propsFileName);
        if (!propsFile.exists()) {
            propsFile.createNewFile();
        }
        FileInputStream is = new FileInputStream(propsFile);
        try {
            this.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @Override
    public synchronized void putAll(Map map) {
        super.putAll((Map<?, ?>)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store() throws IOException {
        File propFile = new File(this.propsFileName);
        File origFile = new File(this.propsFileName + ".orig");
        if (!origFile.exists()) {
            FileInputStream fin = new FileInputStream(propFile);
            try {
                FileOutputStream fout = new FileOutputStream(origFile);
                try {
                    byte[] buffer = new byte[4096];
                    int rcount = fin.read(buffer);
                    while (rcount != -1) {
                        fout.write(buffer, 0, rcount);
                        rcount = fin.read(buffer);
                    }
                }
                finally {
                    fout.close();
                }
            }
            finally {
                fin.close();
            }
        }
        FileOutputStream ostream = new FileOutputStream(propFile);
        try {
            this.store(ostream, "Cartridge Configuration");
        }
        finally {
            ((OutputStream)ostream).close();
        }
    }

    public synchronized String getDriver() {
        return this.getProperty("driver");
    }

    public synchronized void setDriver(String driver) {
        this.setProperty("driver", driver);
    }

    public synchronized String getUrl() {
        String url = this.getProperty("url");
        if (url == null) {
            String host = this.getProperty("oracle.server.host");
            String port = this.getProperty("oracle.server.port");
            String sid = this.getProperty("oracle.server.instance");
            url = "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
        }
        return url;
    }

    public synchronized void setUrl(String url) {
        this.setProperty("url", url);
    }

    public synchronized String getLogin() {
        return this.getProperty("login");
    }

    public synchronized void setLogin(String login) {
        this.setProperty("login", login);
    }

    public synchronized String getPassword() {
        return this.getProperty("password");
    }

    public synchronized void setPassword(String password) {
        String pw = "";
        if (password != null && password.length() > 0) {
            pw = StringUtil.encrypt(password);
        }
        this.setProperty("password", pw);
    }

    public synchronized String getAdminPassword() {
        String pw = this.getProperty("adminPassword");
        if (pw == null) {
            return null;
        }
        return StringConverter.megfejt(pw);
    }

    public synchronized void setAdminPassword(String adminPassword) {
        if (adminPassword == null || adminPassword.length() == 0) {
            return;
        }
        this.setProperty("adminPassword", adminPassword);
    }

    public synchronized String getFallbackOnSuperUser() {
        return this.getProperty("fallbackOnSuperUser");
    }

    public synchronized void setFallbackOnSuperUser(String fallbackOnSuperUser) {
        this.setProperty("fallbackOnSuperUser", fallbackOnSuperUser);
    }

    public synchronized String getReservedMemory() {
        return this.getProperty("reservedMemory");
    }

    public synchronized void setReservedMemory(String reservedMemory) {
        this.setProperty("reservedMemory", reservedMemory);
    }

    public synchronized boolean isJcSearchInfoToStdError() {
        return this.jcSearchInfoToStdError;
    }

    public synchronized void setJcSearchInfoToStdError(boolean jcSearchInfoToStdError) {
        this.jcSearchInfoToStdError = jcSearchInfoToStdError;
    }

    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public synchronized boolean isThreadCountLimitedToCpuCount() {
        String p = this.getProperty("threadCountLimitedToCpuCount");
        if (p == null) {
            return true;
        }
        return Boolean.valueOf(p);
    }

    public synchronized void setThreadCountLimitedToCpuCount(boolean limit) {
        this.setProperty("threadCountLimitedToCpuCount", String.valueOf(limit));
    }

    public synchronized int getJcSearchThreadsPerCall() {
        return this.getThreadCount(THREADS_PER_CALL_KEY_SEARCH);
    }

    public synchronized int getIndexingThreadsPerCall() {
        return this.getThreadCount(THREADS_PER_CALL_KEY_INDEXING);
    }

    public synchronized int getJcReactThreadsPerCall() {
        return this.getThreadCount(THREADS_PER_CALL_KEY_REACT);
    }

    public int getThreadCount(String workerCountPropertyName) {
        String str = this.getProperty(workerCountPropertyName);
        if (str == null) {
            return this.getAvailableProcessors();
        }
        if (this.isThreadCountLimitedToCpuCount()) {
            return Math.min(Integer.parseInt(str), this.getAvailableProcessors());
        }
        return Integer.parseInt(str);
    }

    public synchronized int getReservedMemoryEffective() {
        String str = this.getReservedMemory();
        if (str == null) {
            return 64;
        }
        return Integer.parseInt(str);
    }

    public int getIndexQueueCapacity() {
        String value = this.getProperty("indexQueueCapacity");
        if (value == null) {
            return 5000;
        }
        return Integer.parseInt(value);
    }

    public String getServerConfigFileName() {
        return this.propsFileName;
    }

    public boolean getBoolean(String key, boolean dfltValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return dfltValue;
        }
        return Boolean.parseBoolean(value);
    }

    public int getInt(String key, int dflt) {
        String value = this.getProperty(key);
        if (value == null) {
            return dflt;
        }
        return Integer.parseInt(value);
    }

    public long getLong(String key, long dflt) {
        String value = this.getProperty(key);
        if (value == null) {
            return dflt;
        }
        return Long.parseLong(value);
    }
}

