/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop;

import chemaxon.sss.search.MolSearchOptions;
import chemaxon.util.CxOptions;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MolSearchOptionsAdapter
extends MolSearchOptions {
    private static Logger logger = Logger.getLogger(MolSearchOptionsAdapter.class.getName());
    private String queryType;
    private boolean tdf;

    public MolSearchOptionsAdapter(String options) {
        super(2);
        this.setOptions(options);
    }

    public MolSearchOptionsAdapter(int searchType) {
        super(searchType);
    }

    @Override
    public void setOption(String name, String value) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("optionsName=" + name + ", value=" + value);
        }
        if (!(name.equalsIgnoreCase("absoluteStereo") || name.equalsIgnoreCase("haltOnError") || name.equalsIgnoreCase("markushScreening") || name.equalsIgnoreCase("markushFPScreening") || name.equalsIgnoreCase("descriptorName") || name.equalsIgnoreCase("earlyResults") || name.equalsIgnoreCase("requireCommit"))) {
            if (name.equalsIgnoreCase("ignoreMixtureBrackets")) {
                boolean b = CxOptions.getBooleanValue(name, value, false);
                this.setMixSgroupMatching(!b);
            } else if (name.equalsIgnoreCase("queryType")) {
                this.queryType = value;
            } else if (name.equalsIgnoreCase("tdf")) {
                this.tdf = CxOptions.getBooleanValue(name, value, false);
            } else {
                super.setOption(name, value);
            }
        }
    }

    public String getQueryType() {
        return this.queryType;
    }

    public boolean isTdf() {
        return this.tdf;
    }
}

