/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop.reactor;

import chemaxon.formats.MolExporter;
import chemaxon.jchem.interop.InteropUtil;
import chemaxon.jchem.interop.reactor.CachedReactData;
import chemaxon.jchem.interop.reactor.InteropReactOption;
import chemaxon.jchem.interop.reactor.InteropReactorConsts;
import chemaxon.jchem.interop.reactor.ReactDataCache;
import chemaxon.jchem.interop.reactor.Reactant;
import chemaxon.jchem.interop.reactor.SynthCodeInfo;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.Reactor;
import chemaxon.struc.Molecule;
import chemaxon.util.CxOptions;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InteropReactor
implements InteropReactorConsts {
    private static final Logger logger = Logger.getLogger(InteropReactor.class.getName());

    public String[] react(String reactionString, String[] reactantStrings, String optionString) throws Exception {
        CxOptions options = new CxOptions(optionString);
        CachedReactData rData = ReactDataCache.getInstance().popReactData(reactionString, options);
        String reactantIdList = InteropReactOption.REACTANT_IDS.getStringValue(options);
        String[] reactantIds = InteropUtil.parseStringList(reactantIdList, ",");
        Molecule[] mols = this.reactCore(rData, this.createReactants(reactantStrings), reactantIds);
        String outFormat = InteropReactOption.OUTFORMAT.getStringValue(options);
        if (outFormat == null) {
            outFormat = "smiles";
        }
        String[] strArray = new String[mols.length];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        MolExporter exporter = new MolExporter(bout, outFormat);
        for (int ix = 0; ix < mols.length; ++ix) {
            exporter.write(mols[ix]);
            strArray[ix] = new String(bout.toByteArray(), "US-ASCII");
            bout.reset();
        }
        return strArray;
    }

    private Reactant[] createReactants(String[] reactantStrings) throws Exception {
        Reactant[] rarr = new Reactant[reactantStrings.length];
        for (int i = 0; i < reactantStrings.length; ++i) {
            String string = reactantStrings[i];
            rarr[i] = Reactant.createReactant(string.getBytes());
        }
        return rarr;
    }

    public Molecule[] reactCore(CachedReactData rData, Reactant[] reactants, String[] reactantIds) throws Exception {
        Molecule[] products = null;
        Molecule[] rtantMols = this.setReactantIdTags(rData, reactants, reactantIds);
        SynthCodeInfo synthCodeInfo = rData.getSynthCodeInfo();
        if (rData.isPermuteReactants()) {
            synthCodeInfo.setComponentIDPropertyNamesUnified(rData.getReactor(), rtantMols);
            products = InteropReactor.reactPermute(rData, rtantMols);
        } else {
            products = InteropReactor.reactDefault(rData, rtantMols);
        }
        return products;
    }

    private Molecule[] setReactantIdTags(CachedReactData rData, Reactant[] reactants, String[] reactantIds) throws Exception {
        SynthCodeInfo synthCodeInfo = rData.getSynthCodeInfo();
        Molecule[] mols = new Molecule[reactants.length];
        for (int i = 0; i < reactants.length; ++i) {
            Molecule mol;
            Reactant reactant = reactants[i];
            mols[i] = mol = reactant.getMolecule();
            String producedId = reactant.getReactantId();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("producedId=" + producedId);
            }
            if (producedId == null) continue;
            String tag = synthCodeInfo.getCreateReactantIdTag(i, mol);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("tag=" + tag);
            }
            mol.setProperty(tag, producedId);
        }
        if (reactantIds != null) {
            synthCodeInfo.setReactantIdsAsTags(mols, reactantIds);
        }
        return mols;
    }

    private static Molecule[] postProcessProducts(CachedReactData rData, Molecule[] products) throws ReactionException {
        return products;
    }

    private static Molecule[] reactDefault(CachedReactData rData, Molecule[] reactants) throws Exception {
        ArrayList<Molecule> products = new ArrayList<Molecule>();
        Reactor reactor = rData.getReactor();
        reactor.setReactants(reactants);
        Molecule[] marr = reactor.react();
        if (logger.isLoggable(Level.FINEST)) {
            InteropReactor.debugMolecules(marr, "immediate products");
        }
        if (rData.getMethod() == 2) {
            return InteropReactor.postProcessProducts(rData, marr);
        }
        while (marr != null && !InteropReactor.isInterrupted()) {
            marr = InteropReactor.postProcessProducts(rData, marr);
            if (logger.isLoggable(Level.FINEST)) {
                InteropReactor.debugMolecules(marr, "post-processed products");
            }
            for (int mix = 0; mix < marr.length; ++mix) {
                products.add(marr[mix]);
            }
            marr = reactor.react();
            if (!logger.isLoggable(Level.FINEST)) continue;
            InteropReactor.debugMolecules(marr, "immediate products");
        }
        return products.toArray(new Molecule[products.size()]);
    }

    private static Molecule[] reactPermute(CachedReactData rData, Molecule[] reactants) throws Exception {
        List<Molecule> reactantList = Arrays.asList(reactants);
        HashSet<Molecule> products = new HashSet<Molecule>();
        Object[] aMutation = new Molecule[reactantList.size()];
        ArrayList permutations = new ArrayList();
        InteropReactor.permute(reactantList, aMutation, permutations);
        Reactor reactor = rData.getReactor();
        for (int ix = 0; ix < permutations.size() && !InteropReactor.isInterrupted(); ++ix) {
            Object[] objArr = (Object[])permutations.get(ix);
            aMutation = new Molecule[objArr.length];
            System.arraycopy(objArr, 0, aMutation, 0, objArr.length);
            reactor.setReactants((Molecule[])aMutation);
            if (logger.isLoggable(Level.FINEST)) {
                InteropReactor.debugMolecules((Molecule[])aMutation, "reactants[" + ix + "]");
            }
            Molecule[] marr = reactor.react();
            while (marr != null && !InteropReactor.isInterrupted()) {
                if (logger.isLoggable(Level.FINEST)) {
                    InteropReactor.debugMolecules(marr, "products[" + ix + "]");
                }
                marr = InteropReactor.postProcessProducts(rData, marr);
                for (int mix = 0; mix < marr.length; ++mix) {
                    products.add(marr[mix]);
                }
                marr = reactor.react();
            }
        }
        return products.toArray(new Molecule[products.size()]);
    }

    private static void debugMolecules(Molecule[] aMutation, String text) {
        if (aMutation == null) {
            return;
        }
        for (int i = 0; i < aMutation.length; ++i) {
            Molecule molecule = aMutation[i];
            String molAsString = "null";
            if (molecule != null) {
                molAsString = molecule.toFormat("smiles");
            }
            StringBuffer properties = new StringBuffer();
            int propCount = molecule.getPropertyCount();
            for (int ix = 0; ix < propCount; ++ix) {
                if (ix > 0) {
                    properties.append("; ");
                }
                String propName = molecule.getPropertyKey(ix);
                String propValue = molecule.getProperty(propName);
                properties.append(propName).append("=").append(propValue);
            }
            logger.finest(text + "[" + i + "]: " + molAsString + ", properties[" + properties.toString() + "]");
        }
    }

    public static void permute(List currentArray, Object[] aPermutation, ArrayList permutations) {
        int origArrayLen = aPermutation.length;
        int currentArrayLen = currentArray.size();
        int position = origArrayLen - currentArrayLen;
        if (currentArrayLen == 1) {
            aPermutation[position] = currentArray.get(0);
            Object[] aperm = new Object[origArrayLen];
            System.arraycopy(aPermutation, 0, aperm, 0, origArrayLen);
            permutations.add(aperm);
        } else {
            for (int ix = 0; ix < currentArray.size() && !InteropReactor.isInterrupted(); ++ix) {
                Object currentElement = currentArray.get(ix);
                aPermutation[position] = currentElement;
                ArrayList newCurrentArray = new ArrayList();
                for (Object element : currentArray) {
                    if (element.equals(currentElement)) continue;
                    newCurrentArray.add(element);
                }
                if (InteropReactor.isInterrupted()) continue;
                InteropReactor.permute(newCurrentArray, aPermutation, permutations);
            }
        }
    }

    private static boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public static void main(String[] args) {
        int arrayLen = 4;
        ArrayList<Integer> theElements = new ArrayList<Integer>();
        for (int ix = 0; ix < arrayLen; ++ix) {
            theElements.add(new Integer(ix));
        }
        Object[] aPermutation = new Object[arrayLen];
        ArrayList permutations = new ArrayList();
        InteropReactor.permute(theElements, aPermutation, permutations);
        for (int ix = 0; ix < permutations.size(); ++ix) {
            aPermutation = (Object[])permutations.get(ix);
            System.out.print("[");
            for (int i = 0; i < aPermutation.length; ++i) {
                System.out.print(aPermutation[i]);
                if (i < aPermutation.length - 1) {
                    System.out.print(",");
                    continue;
                }
                System.out.println("]");
            }
        }
    }
}

