/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.interop.reactor;

import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.interop.InteropUtil;
import chemaxon.jchem.interop.reactor.CachedReactData;
import chemaxon.jchem.interop.reactor.InteropReactOption;
import chemaxon.jchem.interop.reactor.InteropReactorConsts;
import chemaxon.jchem.interop.reactor.SynthCodeInfo;
import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.Reactor;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.CxOptions;
import chemaxon.util.cache.CachedPools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReactDataCache
extends CachedPools
implements InteropReactorConsts {
    private static Logger logger = Logger.getLogger(ReactDataCache.class.getName());
    private static ReactDataCache instance = new ReactDataCache();

    @Override
    protected Object createPoolItem(Object key) throws Exception {
        return null;
    }

    public static ReactDataCache getInstance() {
        return instance;
    }

    public CachedReactData popReactData(String reactionString, CxOptions options) throws Exception {
        return this.popReactData(reactionString, options, new DefaultStandardizerFactory());
    }

    public CachedReactData popReactData(String reactionString, CxOptions options, StandardizerFactory standardizerFactory) throws Exception {
        String key;
        CachedReactData rData;
        if (standardizerFactory == null) {
            standardizerFactory = new DefaultStandardizerFactory();
        }
        if ((rData = (CachedReactData)this.getCreatePoolItem(key = this.createReactDataKey(reactionString, options))) == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Creating cached data for reaction: " + reactionString + ": (" + key + ")");
            }
            rData = this.createCachedReactData(reactionString, options, standardizerFactory);
            rData.setKey(key);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer("Found cached data for reaction: " + reactionString);
        }
        rData.getSynthCodeInfo().setReactantIdTags(options);
        return rData;
    }

    public void pushReactData(CachedReactData rData) {
        this.recyclePoolItem(rData.getKey(), rData);
    }

    private String createReactDataKey(String reactionString, CxOptions jcOptions) {
        StringBuffer buffer = new StringBuffer(reactionString);
        InteropReactOption[] allOptions = InteropReactOption.getAll();
        for (int i = 0; i < allOptions.length; ++i) {
            String strValue;
            InteropReactOption opt = allOptions[i];
            if (opt == InteropReactOption.REACTANT_IDS || opt == InteropReactOption.OUTFORMAT || (strValue = opt.getStringValue(jcOptions)) == null) continue;
            buffer.append("~");
            buffer.append(opt.getName()).append(":").append(strValue);
        }
        return buffer.toString();
    }

    private CachedReactData createCachedReactData(String reactionString, CxOptions options, StandardizerFactory standardizerFactory) throws Exception {
        Standardizer productStandardizer;
        String prodIdxList = InteropReactOption.EXTRACT.getStringValue(options);
        int[] prodIdxArr = InteropUtil.parseIntList(prodIdxList, ",");
        boolean permuteReactants = InteropReactOption.PERMUTE_REACTANTS.getBooleanValue(options, false);
        int method = this.getMethod(options, permuteReactants);
        Reactor reactor = new Reactor();
        reactor.setProductIndexes(prodIdxArr);
        Standardizer reactionStandardizer = standardizerFactory.createStandardizer(InteropReactOption.STANDARDIZER, options);
        if (reactionStandardizer != null) {
            reactor.setStandardizer(reactionStandardizer);
        }
        String allowDuplProdString = InteropReactOption.ALLOW_DUPL_PRODUCTS.getStringValue(options);
        boolean allowDuplProducts = InteropReactOption.ALLOW_DUPL_PRODUCTS.getBooleanValue(options, false);
        if (method == 2) {
            reactor.setTransform(true);
            if (allowDuplProdString != null && !allowDuplProducts) {
                throw new IllegalArgumentException(InteropReactOption.ALLOW_DUPL_PRODUCTS.getName() + " cannot be set to 'n', if " + InteropReactOption.METHOD + " is set to 'a'");
            }
            reactor.setDuplicateFiltering(0);
        } else {
            reactor.setDuplicateFiltering(allowDuplProducts ? 0 : 1);
        }
        reactor.setOutputReactionMappingStyle(this.getOutputReactionMappingStyle(options));
        if (!this.setReactionWithoutSmartsRules(reactor, reactionString, options, reactionStandardizer, method)) {
            String reactionId = SynthCodeInfo.getReactionId(null, options);
            if (reactionId == null) {
                reactor.setReactionString(reactionString);
            } else {
                reactor.setReactionString(reactionString, reactionId);
            }
        }
        if ((productStandardizer = standardizerFactory.createStandardizer(InteropReactOption.STANDARDIZER, options)) != null) {
            reactor.setProductStandardizer(productStandardizer);
        }
        reactor.setReverse(InteropReactOption.REVERSE.getBooleanValue(options, false));
        reactor.setSingle(InteropReactOption.UNAMBIGUOUS_REACTIONS.getBooleanValue(options, false));
        reactor.setIgnoreRules(this.getIgnoreRules(options));
        reactor.setRemoveDuplicateProductReferences(InteropReactOption.REMOVE_DUPL_PROD_REFS.getBooleanValue(options, false));
        reactor.setResultType(this.getOutputType(options));
        this.setRatio(reactor, options);
        SynthCodeInfo synthCodeInfo = new SynthCodeInfo(options, reactor.getReactantCount());
        synthCodeInfo.setComponentIDPropertyNames(reactor);
        CachedReactData rData = new CachedReactData();
        rData.setReaction(reactionString);
        rData.setReactor(reactor);
        rData.setSynthCodeInfo(synthCodeInfo);
        rData.setPermuteReactants(permuteReactants);
        rData.setMethod(method);
        rData.setIgnoreErrors(InteropReactOption.IGNORE_ERRORS.getBooleanValue(options, false));
        return rData;
    }

    protected int getMethod(CxOptions options, boolean permuteReactants) {
        int method = 0;
        char[] methodChar = InteropReactOption.METHOD.getValue(options);
        if (methodChar != null) {
            if (methodChar.length > 1) {
                CxOptions.throwBadOptionValueException(methodChar, InteropReactOption.METHOD.getName());
            }
            switch (methodChar[0]) {
                case 'N': 
                case 'n': {
                    method = 0;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (permuteReactants) {
                        throw new IllegalArgumentException("The permuteReactants option cannot be turned on with method \"fuse reactants\"");
                    }
                    method = 1;
                    break;
                }
                case 'A': 
                case 'a': {
                    if (permuteReactants) {
                        throw new IllegalArgumentException("The permuteReactants option cannot be turned on with method \"combine product sets\"");
                    }
                    method = 2;
                    break;
                }
                default: {
                    CxOptions.throwBadOptionValueException(methodChar, InteropReactOption.METHOD.getName());
                }
            }
        }
        return method;
    }

    protected boolean setReactionWithoutSmartsRules(Reactor reactor, String reactionString, CxOptions options, Standardizer standardizer, int method) throws Exception {
        Molecule mol = null;
        try {
            mol = ReactDataCache.importReaction(reactionString);
        }
        catch (IOException io) {
            return false;
        }
        RxnMolecule rxn = RxnMolecule.getReaction(mol);
        if (rxn == null) {
            throw new Exception("Not a reaction molecule: " + reactionString);
        }
        String reactionId = SynthCodeInfo.getReactionId(rxn, options);
        Reaction reaction = this.createReaction(reactionId);
        reaction.setReaction(rxn, method == 1 || method == 2);
        reactor.setReaction(reaction);
        return true;
    }

    protected static Molecule importReaction(String reactionString) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(reactionString.getBytes("US-ASCII"));
        MolInputStream mis = new MolInputStream(is);
        MolImporter mi = new MolImporter(mis);
        mi.setQueryMode(true);
        return mi.read();
    }

    protected Reaction createReaction(String reactionId) {
        Reaction reaction = null;
        reaction = reactionId == null ? new Reaction() : new Reaction(reactionId);
        return reaction;
    }

    private void setRatio(Reactor reactor, CxOptions options) throws ReactionException {
        String value = InteropReactOption.RATIO.getStringValue(options);
        if (value != null) {
            ArrayList<String> sList = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(value, ":");
            while (t.hasMoreTokens()) {
                sList.add(t.nextToken());
            }
            int[] ratio = new int[sList.size()];
            for (int i = 0; i < ratio.length; ++i) {
                ratio[i] = Integer.parseInt((String)sList.get(i));
            }
            reactor.setRatio(ratio);
        }
    }

    protected int getIgnoreRules(CxOptions options) {
        int rulesToIgnore = 0;
        String str = InteropReactOption.IGNORE_RULES.getStringValue(options);
        if (str != null) {
            if (str.indexOf("r") != -1) {
                rulesToIgnore |= 1;
            }
            if (str.indexOf("s") != -1) {
                rulesToIgnore |= 2;
            }
            if (str.indexOf("t") != -1) {
                rulesToIgnore |= 4;
            }
        }
        return rulesToIgnore;
    }

    protected int getOutputType(CxOptions options) {
        int outputType = 0;
        InteropReactOption outputTypeOpt = InteropReactOption.OUTPUT_TYPE;
        String typeString = outputTypeOpt.getStringValue(options);
        if (typeString != null && typeString.compareToIgnoreCase("products") != 0) {
            if (typeString.compareToIgnoreCase("reaction") == 0) {
                outputType = 1;
            } else if (typeString.compareToIgnoreCase("fusedreaction") == 0) {
                outputType = 4;
            } else {
                throw new IllegalArgumentException("Invalid value for " + outputTypeOpt.getName() + ": " + typeString);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Returning " + outputType);
        }
        return outputType;
    }

    protected int getOutputReactionMappingStyle(CxOptions options) {
        int mappingStyle = 0;
        String mapStyleString = InteropReactOption.OUT_REACTION_MAPSTYLE.getStringValue(options);
        if (mapStyleString == null) {
            return mappingStyle;
        }
        if (mapStyleString.equalsIgnoreCase("changing")) {
            mappingStyle = 1;
        } else if (mapStyleString.equalsIgnoreCase("complete")) {
            mappingStyle = 2;
        } else if (mapStyleString.equalsIgnoreCase("matching")) {
            mappingStyle = 3;
        }
        return mappingStyle;
    }

    public static void main(String[] args) {
        String reactionString = "[#6:3][C:2]([#17,#35:6])=[O:1].[H:7][N:4]([#1,#6:8])[#1,#6:5]>>[#6:3][C:2](=[O:1])[N:4]([#1,#6:8])[#1,#6:5].[#17,#35:6][H:7]";
        Molecule mol = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(reactionString.getBytes("US-ASCII"));
            MolInputStream mis = new MolInputStream(is);
            MolImporter mi = new MolImporter(mis);
            mi.setQueryMode(true);
            mol = mi.read();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.err.println("mol=" + mol);
    }

    public static class DefaultStandardizerFactory
    implements StandardizerFactory {
        @Override
        public Standardizer createStandardizer(InteropReactOption standardizerOption, CxOptions options) throws StandardizerException {
            String stdrString = standardizerOption.getStringValue(options);
            if (stdrString == null) {
                return null;
            }
            String cfgPrefix = "config:";
            if (stdrString.toLowerCase().startsWith("config:")) {
                String cfg = stdrString.substring("config:".length());
                return new Standardizer(cfg);
            }
            throw new IllegalArgumentException("Standardizer option with invalid prefix: '" + stdrString + "'. ");
        }
    }

    public static interface StandardizerFactory {
        public Standardizer createStandardizer(InteropReactOption var1, CxOptions var2) throws Exception;
    }
}

