/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.regsys.RegistrationException;
import chemaxon.jchem.regsys.TestThread;
import chemaxon.jchem.regsys.cmpdreg.BatchRegistration;
import chemaxon.jchem.regsys.cmpdreg.CompoundRegistration;
import chemaxon.jchem.regsys.cmpdreg.RegistrationInputRecord;
import chemaxon.jchem.regsys.cmpdreg.admin.CompoundRegistrationAdministration;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundNotRegisteredOther;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundRegistrationResult;
import chemaxon.jchem.regsys.registrar.FinalAreaTasks;
import chemaxon.jchem.regsys.registrar.TemporaryAreaTasks;
import chemaxon.struc.Molecule;
import chemaxon.util.ConnectionHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;

public class Test {
    private static String driverName = "oracle.jdbc.driver.OracleDriver";
    private static String serverName = "10.0.0.30";
    private static String portNumber = "1521";
    private static String sid = "mydb";
    private static String url = "jdbc:oracle:thin:@" + serverName + ":" + portNumber + ":" + sid;
    private static String username = "compregsys";
    private static String password = "tiger";

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        CompoundRegistrationAdministration cra;
        if (args.length == 0) {
            return;
        }
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        username = args[0].endsWith("2") ? "compregsys2" : "compregsys";
        ConnectionHandler ch = new ConnectionHandler();
        ch.setDriver(driverName);
        ch.setUrl(url);
        ch.setLoginName(username);
        ch.setPassword(password);
        try {
            ch.connect();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        System.err.println(new Date(System.currentTimeMillis()).toString());
        if (args.length > 1) {
            FinalAreaTasks fat;
            CompoundRegistration cr;
            if (args[0].startsWith("registrar")) {
                TemporaryAreaTasks tat = new TemporaryAreaTasks(ch);
                if (args[1].startsWith("all")) {
                    try {
                        tat.registerAllNonDuplicateCompounds();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    catch (RegistrationException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        tat.registerCompound(Integer.parseInt(args[1]));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    catch (RegistrationException e) {
                        e.printStackTrace();
                    }
                    catch (MolFormatException e) {
                        e.printStackTrace();
                    }
                    catch (PropertyNotSetException e) {
                        e.printStackTrace();
                    }
                }
            } else if (args[0].startsWith("multisdfreg")) {
                try {
                    int i;
                    MolImporter mi = new MolImporter(args[1]);
                    ConnectionHandler[] chs = new ConnectionHandler[Runtime.getRuntime().availableProcessors()];
                    TestThread[] tts = new TestThread[Runtime.getRuntime().availableProcessors()];
                    for (i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
                        try {
                            Class.forName(driverName);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        chs[i] = new ConnectionHandler();
                        chs[i].setDriver(driverName);
                        chs[i].setUrl(url);
                        chs[i].setLoginName(username);
                        chs[i].setPassword(password);
                        try {
                            chs[i].connect();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        tts[i] = new TestThread(mi, chs[i]);
                    }
                    System.out.println(new Date(System.currentTimeMillis()).toString());
                    for (i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
                        tts[i].start();
                    }
                    for (i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
                        tts[i].join();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (args[0].startsWith("sdfreg")) {
                cr = new CompoundRegistration(ch, null);
                BatchRegistration br = new BatchRegistration(ch);
                Vector<CompoundNotRegisteredOther> v = new Vector<CompoundNotRegisteredOther>();
                try {
                    MolImporter mi = new MolImporter(args[1]);
                    Molecule m = mi.read();
                    boolean bl = false;
                    while (m != null) {
                        void var7_56;
                        if (!m.toFormat("smarts").equals("")) {
                            try {
                                CompoundRegistrationResult crr = cr.register(new RegistrationInputRecord(m));
                                try {
                                    String batchResult = br.register(crr);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (RegistrationException e) {
                                e.printStackTrace();
                            }
                        } else {
                            v.add(new CompoundNotRegisteredOther("Empty structure"));
                        }
                        if (++var7_56 % 10 == false) {
                            System.out.println("Ready: " + (int)var7_56);
                        }
                        m = mi.read();
                    }
                }
                catch (MolFormatException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                System.err.println(new Date(System.currentTimeMillis()).toString());
                int i = 0;
                for (Object e : v) {
                    if (e instanceof CompoundRegistrationResult) {
                        CompoundRegistrationResult a = (CompoundRegistrationResult)e;
                        System.out.print(++i + ":");
                        a.printOut();
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    String s = (String)e;
                    System.out.println(s);
                }
                try {
                    ch.getConnection().commit();
                    ch.close();
                }
                catch (SQLException e) {}
            } else if (args[0].startsWith("reg")) {
                cr = new CompoundRegistration(ch, null);
                Vector<CompoundRegistrationResult> v = new Vector<CompoundRegistrationResult>();
                try {
                    MolImporter mi = new MolImporter(args[1]);
                    Molecule m = mi.read();
                    int i = 0;
                    while (m != null) {
                        if (!m.toFormat("smarts").equals("")) {
                            try {
                                v.add(cr.register(new RegistrationInputRecord(m)));
                            }
                            catch (RegistrationException registrationException) {
                                registrationException.printStackTrace();
                            }
                        } else {
                            v.add(new CompoundNotRegisteredOther("Empty structure"));
                        }
                        if (++i % 10 == 0) {
                            System.out.println("Ready: " + i);
                        }
                        m = mi.read();
                    }
                }
                catch (MolFormatException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                int i = 0;
                for (CompoundRegistrationResult a : v) {
                    System.out.print(++i + ":");
                    a.printOut();
                }
                try {
                    ch.getConnection().commit();
                    ch.close();
                }
                catch (SQLException e) {}
            } else if (args[0].startsWith("salt")) {
                fat = new FinalAreaTasks(ch);
                try {
                    MolImporter mi = new MolImporter(args[1]);
                    Molecule m = mi.read();
                    int i = 0;
                    while (m != null && !m.toFormat("smarts").equals("")) {
                        try {
                            fat.addSalt(m);
                        }
                        catch (Exception e) {
                            System.err.println("Can not add salt: " + m.toFormat("smarts"));
                        }
                        if (++i % 10 == 0) {
                            System.out.println("Ready: " + i);
                        }
                        m = mi.read();
                    }
                }
                catch (Exception e) {}
            } else if (args[0].startsWith("solvent")) {
                fat = new FinalAreaTasks(ch);
                try {
                    MolImporter mi = new MolImporter(args[1]);
                    Molecule m = mi.read();
                    int i = 0;
                    while (m != null && !m.toFormat("smarts").equals("")) {
                        try {
                            System.out.println(m.toFormat("smiles"));
                            fat.addSolvent(m);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.println("Can not add solvent: " + m.toFormat("smarts"));
                        }
                        if (++i % 10 == 0) {
                            System.out.println("Ready: " + i);
                        }
                        m = mi.read();
                    }
                }
                catch (Exception e) {}
            }
        } else if (args.length == 1 && args[0].startsWith("clear")) {
            FinalAreaTasks fa = new FinalAreaTasks(ch);
            try {
                fa.clearAll();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (args.length == 1 && args[0].startsWith("createnotautomer")) {
            cra = new CompoundRegistrationAdministration(ch);
            try {
                cra.createDatabase(false, 0, null, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if (args.length == 1 && args[0].startsWith("createtautomer")) {
            cra = new CompoundRegistrationAdministration(ch);
            try {
                cra.createDatabase(true, 0, null, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

