/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys.cmpdreg;

import chemaxon.common.util.IntVector;
import chemaxon.formats.MolFormatException;
import chemaxon.jchem.db.DatabaseSearchException;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.regsys.RegistrationException;
import chemaxon.jchem.regsys.cmpdreg.RegistrationInputRecord;
import chemaxon.jchem.regsys.cmpdreg.RegistrationInputRecordWithTypes;
import chemaxon.jchem.regsys.cmpdreg.admin.CompoundRegistrationOptions;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundNotRegisteredDuplicateError;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundNotRegisteredOther;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundNotRegisteredSuspended;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundRegistered;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundRegistrationResult;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.util.ConnectionHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class CompoundRegistration {
    private static final String SALT_FILTER = " SALTFLAG = 1";
    private static final String SOLVENT_FILTER = " SOLVENTFLAG = 1";
    private static final String PRIMARY_FILTER = " PRIMARYFLAG = 1";
    private boolean manuallyChecked = false;
    private CompoundRegistrationOptions cropts = null;
    private ConnectionHandler ch = null;
    private UpdateHandler insertIntoStructuralUnitsTempHandler = null;
    private UpdateHandler insertIntoCompoundsTempHandler = null;
    private long curtime;

    public CompoundRegistration(ConnectionHandler ch, CompoundRegistrationOptions options) {
        this.cropts = options;
        this.ch = ch;
    }

    public CompoundRegistrationResult register(RegistrationInputRecord registrationRecord) throws RegistrationException {
        this.curtime = System.currentTimeMillis();
        RegistrationInputRecordWithTypes rirwt = null;
        if (registrationRecord.getCompound().isQuery()) {
            return new CompoundNotRegisteredOther("Query molecule cannot be inserted.");
        }
        rirwt = registrationRecord instanceof RegistrationInputRecordWithTypes ? (RegistrationInputRecordWithTypes)registrationRecord : this.addTypes(registrationRecord);
        boolean allTypesGiven = true;
        for (int i = 0; i < rirwt.getTypes().length && allTypesGiven; ++i) {
            if (rirwt.getTypes()[i] != 4) continue;
            allTypesGiven = false;
        }
        if (this.manuallyChecked) {
            this.manuallyChecked = false;
            return this.registerToDatabase(rirwt);
        }
        boolean manualInteractionRequired = this.checkAndUseCompoundRegistrationOptions(rirwt);
        if (manualInteractionRequired) {
            return new CompoundNotRegisteredSuspended(rirwt);
        }
        return this.registerToDatabase(rirwt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompoundRegistrationResult registerToDatabase(RegistrationInputRecordWithTypes rirwt) {
        try {
            int i;
            int[] strID = new int[rirwt.getTypes().length];
            String[] structureType = new String[rirwt.getTypes().length];
            String[] componentType = new String[rirwt.getTypes().length];
            int[] componentQuantity = new int[rirwt.getTypes().length];
            int all = 0;
            for (i = 0; i < rirwt.getQuantities().length; ++i) {
                all += rirwt.getQuantities()[i];
            }
            for (i = 0; i < rirwt.getTypes().length; ++i) {
                String strType;
                String filter;
                String string = rirwt.getTypes()[i] == 2 ? SOLVENT_FILTER : (filter = rirwt.getTypes()[i] == 1 ? SALT_FILTER : PRIMARY_FILTER);
                structureType[i] = strType = rirwt.getTypes()[i] == 2 ? "Solvent" : (rirwt.getTypes()[i] == 1 ? "Salt" : "Primary");
                int[] strIndexes = this.idsInDatabase(rirwt.getStructures()[i], "StructuralUnits", filter);
                if (this.isNoIndexes(strIndexes)) {
                    strIndexes = this.idsInDatabase(rirwt.getStructures()[i], "StructuralUnitsTemp", filter);
                    if (this.isNoIndexes(strIndexes)) {
                        strIndexes = this.idsInDatabase(rirwt.getStructures()[i], "StructuralUnitsTemp", null);
                        if (this.isNoIndexes(strIndexes)) {
                            if (this.insertIntoStructuralUnitsTempHandler == null) {
                                this.insertIntoStructuralUnitsTempHandler = new UpdateHandler(this.ch, 1, "StructuralUnitsTemp", "PrimaryRegistrationID, PrimaryFlag, SaltFlag, SolventFlag, AuxFlag, ReagentFlag, SaltCode, SolventCode, AuxCode, ReagentCode");
                                this.insertIntoStructuralUnitsTempHandler.setDuplicateFiltering(true);
                            }
                            this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(1, "PRIMARY");
                            if (rirwt.getTypes()[i] == 0) {
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(2, "1");
                            } else {
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(2, "0");
                            }
                            if (rirwt.getTypes()[i] == 1) {
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(3, "1");
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(7, "SALT");
                            } else {
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(3, "0");
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(7, null);
                            }
                            if (rirwt.getTypes()[i] == 2) {
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(4, "1");
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(8, "SOLV");
                            } else {
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(4, "0");
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(8, null);
                            }
                            if (rirwt.getTypes()[i] == 3) {
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(5, "1");
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(9, "AUX");
                            } else {
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(5, "0");
                                this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(9, null);
                            }
                            this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(6, "0");
                            this.insertIntoStructuralUnitsTempHandler.setValueForAdditionalColumn(10, null);
                            this.insertIntoStructuralUnitsTempHandler.setStructure(rirwt.getStructures()[i].toFormat("mrv"));
                            int lastStrID = this.insertIntoStructuralUnitsTempHandler.execute(true);
                            this.insertIntoStructuralUnitsTempHandler.checkException();
                            strID[i] = lastStrID;
                            componentType[i] = "T";
                            componentQuantity[i] = rirwt.getQuantities()[i];
                            continue;
                        }
                        String flag = rirwt.getTypes()[i] == 2 ? "SolventFlag = 1, SolventCode = 'Solvent'" : (rirwt.getTypes()[i] == 1 ? "SaltFlag = 1, SaltCode = 'Salt'" : "PrimaryFlag = 1, PrimaryRegistrationID = 'Primary'");
                        Statement st = this.ch.getConnection().createStatement();
                        try {
                            st.execute("UPDATE StructuralUnitsTemp SET " + flag + " WHERE CD_ID = " + strIndexes[0]);
                        }
                        finally {
                            try {
                                st.close();
                            }
                            catch (SQLException e) {}
                        }
                        strID[i] = strIndexes[0];
                        componentType[i] = "T";
                        componentQuantity[i] = rirwt.getQuantities()[i];
                        continue;
                    }
                    strID[i] = strIndexes[0];
                    componentType[i] = "T";
                    componentQuantity[i] = rirwt.getQuantities()[i];
                    continue;
                }
                strID[i] = strIndexes[0];
                componentType[i] = "R";
                componentQuantity[i] = rirwt.getQuantities()[i];
            }
            String andOrQuery = "";
            for (int j = 0; j < componentQuantity.length; ++j) {
                if (j != 0) {
                    andOrQuery = andOrQuery + " OR ";
                }
                andOrQuery = andOrQuery + "StructuralUnitID = " + strID[j] + " AND ComponentQuantity = " + componentQuantity[j];
            }
            String query = "SELECT DISTINCT ComponentID FROM Components WHERE ComponentID IN (SELECT ComponentID FROM Components WHERE " + andOrQuery + " GROUP BY ComponentID HAVING COUNT(*) = " + componentQuantity.length + ") AND ComponentID IN (SELECT ComponentID FROM Components GROUP BY ComponentID HAVING COUNT(*) = " + componentQuantity.length + ")";
            PreparedStatement st = this.ch.getConnection().prepareStatement(query);
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                return new CompoundNotRegisteredDuplicateError(rs.getInt(1));
            }
            rs.close();
            st.close();
            try {
                PreparedStatement ps = this.ch.getConnection().prepareStatement("INSERT INTO CompoundsTemp (CD_ID, CD_STRUCTURE) VALUES (CompoundsTemp_SEQ.NEXTVAL,?)");
                ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(rirwt.getCompound().toFormat("mrv").getBytes()), rirwt.getCompound().toFormat("mrv").length());
                ps.executeUpdate();
                ps.close();
                PreparedStatement ps2 = this.ch.getConnection().prepareStatement("INSERT INTO OriginalStructuresTemp (CD_ID, CD_STRUCTURE) VALUES (CompoundsTemp_SEQ.NEXTVAL,?)");
                ps2.setBinaryStream(1, (InputStream)new ByteArrayInputStream(rirwt.getCompound().toFormat("mrv").getBytes()), rirwt.getCompound().toFormat("mrv").length());
                ps2.executeUpdate();
                ps2.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw e;
            }
            int lastCmpdID = 0;
            if (lastCmpdID < 0) {
                return new CompoundNotRegisteredDuplicateError(-lastCmpdID);
            }
            for (int j = 0; j < strID.length; ++j) {
                this.insertIntoComponents(lastCmpdID, strID[j], componentType[j], structureType[j], componentQuantity[j], "ComponentsTemp");
            }
            CompoundRegistered cr = new CompoundRegistered(lastCmpdID);
            int primCount = 0;
            for (int j = 0; j < rirwt.getTypes().length; ++j) {
                if (rirwt.getTypes()[j] != 0) continue;
                ++primCount;
            }
            if (primCount > 1) {
                cr.setMixture(true);
            }
            return cr;
        }
        catch (Exception e) {
            try {
                this.ch.getConnection().rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return new CompoundNotRegisteredOther(e.getMessage());
        }
    }

    private boolean checkAndUseCompoundRegistrationOptions(RegistrationInputRecordWithTypes rirwt) {
        int i;
        int i2;
        int[] sort = new int[rirwt.getTypes().length];
        for (i2 = 0; i2 < sort.length; ++i2) {
            sort[i2] = i2;
        }
        for (i2 = 0; i2 < sort.length; ++i2) {
            for (int j = 0; j < i2; ++j) {
                if (rirwt.getStructures()[sort[j]].getAtomCount() <= rirwt.getStructures()[sort[j + 1]].getAtomCount()) continue;
                int tmp = sort[j];
                sort[j] = sort[j + 1];
                sort[j + 1] = tmp;
            }
        }
        int primaryCount = 0;
        int unknownCount = 0;
        for (i = 0; i < rirwt.getTypes().length; ++i) {
            if (rirwt.getTypes()[i] == 0) {
                ++primaryCount;
                continue;
            }
            if (rirwt.getTypes()[i] != 4) continue;
            ++unknownCount;
        }
        if (unknownCount > 0) {
            for (i = sort.length - 1; i > -1; --i) {
                if (rirwt.getTypes()[sort[i]] != 4) continue;
                try {
                    PreparedStatement st;
                    ResultSet rs;
                    int[] ids = this.idsInDatabase(rirwt.getStructures()[sort[i]], "StructuralUnits", null);
                    if (this.isNoIndexes(ids) || !(rs = (st = this.ch.getConnection().prepareStatement("SELECT SaltFlag, SolventFlag, PrimaryFlag, AuxFlag FROM StructuralUnits WHERE CD_ID = " + ids[0])).executeQuery()).next()) continue;
                    if (rs.getInt("AuxFlag") == 1) {
                        rirwt.getTypes()[sort[i]] = 3;
                        --unknownCount;
                        continue;
                    }
                    if (rs.getInt("SolventFlag") == 1) {
                        rirwt.getTypes()[sort[i]] = 2;
                        --unknownCount;
                        continue;
                    }
                    if (rs.getInt("SaltFlag") == 1) {
                        rirwt.getTypes()[sort[i]] = 1;
                        --unknownCount;
                        continue;
                    }
                    if (rs.getInt("PrimaryFlag") != 1) continue;
                    rirwt.getTypes()[sort[i]] = 0;
                    --unknownCount;
                    ++primaryCount;
                    continue;
                }
                catch (MolFormatException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (DatabaseSearchException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (PropertyNotSetException e) {
                    e.printStackTrace();
                }
            }
        }
        if (primaryCount > 0 && unknownCount == 0) {
            return false;
        }
        if (unknownCount == 0) {
            rirwt.getTypes()[sort[sort.length - 1]] = 0;
            ++primaryCount;
            return false;
        }
        if (rirwt.getTypes()[sort[sort.length - 1]] == 4) {
            rirwt.getTypes()[sort[sort.length - 1]] = 0;
            ++primaryCount;
            if (--unknownCount > 0) {
                if (rirwt.getTypes()[sort[0]] == 4) {
                    rirwt.getTypes()[sort[0]] = 1;
                }
                --unknownCount;
            }
        } else if (unknownCount == 1 && primaryCount == 0) {
            for (i = 0; i < sort.length && unknownCount > 0; ++i) {
                if (rirwt.getTypes()[i] != 4) continue;
                rirwt.getTypes()[i] = 0;
                --unknownCount;
                ++primaryCount;
            }
        }
        for (i = 0; i < sort.length; ++i) {
            if (rirwt.getTypes()[i] != 4) continue;
            rirwt.getTypes()[i] = 0;
            --unknownCount;
            ++primaryCount;
        }
        return unknownCount > 0;
    }

    private boolean isNoIndexes(int[] indexes) {
        return indexes == null || indexes.length == 0;
    }

    public RegistrationInputRecordWithTypes addTypes(RegistrationInputRecord rir) {
        int i;
        int i2;
        int i3;
        RegistrationInputRecordWithTypes rirwt = new RegistrationInputRecordWithTypes(rir);
        Molecule m = rir.getCompound();
        MoleculeGraph[] fragments = m.findFrags(Molecule.class);
        Vector<MoleculeGraph> frags = new Vector<MoleculeGraph>();
        int[] count = new int[fragments.length];
        for (i3 = 0; i3 < count.length; ++i3) {
            count[i3] = 0;
        }
        for (i3 = 0; i3 < fragments.length; ++i3) {
            boolean match = false;
            for (int j = 0; j < frags.size(); ++j) {
                if (!((Molecule)fragments[i3]).toFormat("smarts:u").equals(((Molecule)frags.elementAt(j)).toFormat("smarts:u"))) continue;
                match = true;
                int n = j;
                count[n] = count[n] + 1;
                j += j + i3 + 2;
            }
            if (match) continue;
            int n = frags.size();
            count[n] = count[n] + 1;
            frags.add(fragments[i3]);
        }
        Molecule[] mfragments = new Molecule[frags.size()];
        int[] types = new int[mfragments.length];
        int[] quantities = new int[mfragments.length];
        for (int i4 = 0; i4 < mfragments.length; ++i4) {
            mfragments[i4] = (Molecule)frags.elementAt(i4);
            types[i4] = 4;
            quantities[i4] = count[i4];
        }
        rirwt.setTypes(mfragments, quantities, types);
        int[] sort = new int[rirwt.getTypes().length];
        for (i2 = 0; i2 < sort.length; ++i2) {
            sort[i2] = i2;
        }
        for (i2 = 0; i2 < sort.length; ++i2) {
            for (int j = 0; j < i2; ++j) {
                if (rirwt.getStructures()[sort[j]].getAtomCount() <= rirwt.getStructures()[sort[j + 1]].getAtomCount()) continue;
                int tmp = sort[j];
                sort[j] = sort[j + 1];
                sort[j + 1] = tmp;
            }
        }
        int primaryCount = 0;
        int unknownCount = 0;
        for (i = 0; i < rirwt.getTypes().length; ++i) {
            if (rirwt.getTypes()[i] == 0) {
                ++primaryCount;
                continue;
            }
            if (rirwt.getTypes()[i] != 4) continue;
            ++unknownCount;
        }
        if (unknownCount > 0) {
            for (i = sort.length - 1; i > -1; --i) {
                if (rirwt.getTypes()[sort[i]] != 4) continue;
                try {
                    PreparedStatement st;
                    ResultSet rs;
                    int[] ids = this.idsInDatabase(rirwt.getStructures()[sort[i]], "StructuralUnits", null);
                    if (this.isNoIndexes(ids) || !(rs = (st = this.ch.getConnection().prepareStatement("SELECT SaltFlag, SolventFlag, PrimaryFlag, AuxFlag FROM StructuralUnits WHERE CD_ID = " + ids[0])).executeQuery()).next()) continue;
                    if (rs.getInt("AuxFlag") == 1) {
                        rirwt.getTypes()[sort[i]] = 3;
                        --unknownCount;
                        continue;
                    }
                    if (rs.getInt("SolventFlag") == 1) {
                        rirwt.getTypes()[sort[i]] = 2;
                        --unknownCount;
                        continue;
                    }
                    if (rs.getInt("SaltFlag") == 1) {
                        rirwt.getTypes()[sort[i]] = 1;
                        --unknownCount;
                        continue;
                    }
                    if (rs.getInt("PrimaryFlag") != 1) continue;
                    rirwt.getTypes()[sort[i]] = 0;
                    --unknownCount;
                    ++primaryCount;
                    continue;
                }
                catch (MolFormatException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (DatabaseSearchException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (PropertyNotSetException e) {
                    e.printStackTrace();
                }
            }
        }
        if (primaryCount <= 0 || unknownCount != 0) {
            if (unknownCount == 0) {
                rirwt.getTypes()[sort[sort.length - 1]] = 0;
                ++primaryCount;
            } else {
                if (rirwt.getTypes()[sort[sort.length - 1]] == 4) {
                    rirwt.getTypes()[sort[sort.length - 1]] = 0;
                    ++primaryCount;
                    if (--unknownCount > 0) {
                        if (rirwt.getTypes()[sort[0]] == 4) {
                            rirwt.getTypes()[sort[0]] = 1;
                        }
                        --unknownCount;
                    }
                } else if (unknownCount == 1 && primaryCount == 0) {
                    for (i = 0; i < sort.length && unknownCount > 0; ++i) {
                        if (rirwt.getTypes()[i] != 4) continue;
                        rirwt.getTypes()[i] = 0;
                        --unknownCount;
                        ++primaryCount;
                    }
                } else if (unknownCount > 1 && primaryCount == 0) {
                    rirwt.getTypes()[sort[sort.length - 1]] = 0;
                    ++primaryCount;
                }
                for (i = 0; i < sort.length; ++i) {
                    if (rirwt.getTypes()[i] != 4) continue;
                    rirwt.getTypes()[i] = 1;
                    --unknownCount;
                    ++primaryCount;
                }
            }
        }
        return rirwt;
    }

    public CompoundRegistrationResult mockRegister(RegistrationInputRecord registrationRecord) throws RegistrationException {
        return null;
    }

    public CompoundRegistrationResult modifyCompound(int ID, String modification) {
        return null;
    }

    public void setCompoundRegistrationOptions(CompoundRegistrationOptions options) {
        this.cropts = options;
    }

    public void setManuallyChecked() {
        this.manuallyChecked = true;
    }

    private int[] idsInDatabase(Molecule mol, String tableName, String filter) throws MolFormatException, DatabaseSearchException, SQLException, IOException, PropertyNotSetException {
        JChemSearch s = new JChemSearch();
        s.setQueryStructure(mol.toFormat("mrv"));
        s.setConnectionHandler(this.ch);
        s.setStructureTable(tableName);
        JChemSearchOptions so = new JChemSearchOptions(5);
        s.setSearchOptions(so);
        s.setRunMode(0);
        try {
            s.run();
        }
        catch (Exception e) {
            return null;
        }
        int[] res = s.getResults();
        if (res == null || res.length < 1 || filter == null) {
            return res;
        }
        String idString = "(" + res[0];
        for (int i = 1; i < res.length; ++i) {
            idString = idString + "," + res[i];
        }
        idString = idString + ")";
        PreparedStatement pst = this.ch.getConnection().prepareStatement("SELECT CD_ID FROM " + tableName + " WHERE CD_ID IN " + idString + " AND " + filter);
        ResultSet rs = pst.executeQuery();
        IntVector iv = new IntVector();
        while (rs.next()) {
            iv.add(rs.getInt("CD_ID"));
        }
        rs.close();
        pst.close();
        return iv.toArray();
    }

    private void insertIntoComponents(int cmpdID, int strID, String type, String componentType, int quantity, String tableName) throws SQLException {
        Statement st = this.ch.getConnection().createStatement();
        st.executeQuery("INSERT INTO " + tableName + " VALUES(" + tableName + "_SEQ.NEXTVAL, " + cmpdID + ", " + strID + ", '" + type + "', '" + componentType + "', " + quantity + ")");
        st.close();
    }
}

