/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys.cmpdreg.admin;

import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.StructureTableOptions;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.regsys.RegistrationException;
import chemaxon.jchem.regsys.cmpdreg.admin.BusinessLogicOptions;
import chemaxon.jchem.regsys.cmpdreg.admin.CompoundRegistrationOptions;
import chemaxon.util.ConnectionHandler;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class CompoundRegistrationAdministration {
    public static final int LIBRARY_MODULE = 0;
    public static final int PLATES_MODULE = 1;
    public static final int OTHER_MODULE = 2;
    private static ConnectionHandler ch;

    public CompoundRegistrationAdministration(ConnectionHandler conh) {
        ch = conh;
    }

    public void setDataSource(DataSource dataSource) {
    }

    public DataSource getDataSource() {
        return null;
    }

    public void setBusinessLogicOptions(BusinessLogicOptions businessLogicOptions) throws RegistrationException {
    }

    public BusinessLogicOptions getBusinessLogicOptions() {
        return null;
    }

    public void setCompoundRegistrationOptions(CompoundRegistrationOptions compoundRegistrationOptions) throws RegistrationException {
    }

    public CompoundRegistrationOptions getCompoundRegistrationOptions() {
        return null;
    }

    public void createDatabase(boolean tautomerDuplicateChecking, int depth, String[] levelNames, int[] initialModules) throws SQLException {
        this.createPropertyTable(ch);
        this.dropThenCreateStructureTable(ch, tautomerDuplicateChecking, "StructuralUnits", ", PrimaryRegistrationID VARCHAR2(30), PrimaryFlag NUMBER(1), SaltFlag NUMBER(1), SolventFlag NUMBER(1), AuxFlag NUMBER(1), ReagentFlag NUMBER(1), SaltCode VARCHAR2(5), SolventCode VARCHAR2(5), AuxCode VARCHAR2(5), ReagentCode VARCHAR2(5)");
        this.dropThenCreateRelationalTable(ch, "Compounds", "CD_ID NUMBER(10) PRIMARY KEY NOT NULL, CD_STRUCTURE BLOB");
        this.dropThenCreateRelationalTable(ch, "OriginalStructures", "CD_ID NUMBER(10) PRIMARY KEY NOT NULL, CD_STRUCTURE BLOB");
        this.dropThenCreateRelationalTable(ch, "Components", "ComponentID NUMBER(10) PRIMARY KEY NOT NULL, CompoundID NUMBER(10) REFERENCES Compounds, StructuralUnitID NUMBER(10) REFERENCES StructuralUnits, ComponentType VARCHAR2(10), ComponentQuantity NUMBER(10)");
        this.dropThenCreateRelationalTable(ch, "Batches", "BatchID NUMBER(10) PRIMARY KEY NOT NULL, CompoundID NUMBER(10) REFERENCES Compounds, BatchLabel VARCHAR2(30), ProjectID NUMBER(10), ProducerID NUMBER(10), LabNotebookID NUMBER(10), Amount NUMBER(10), Purity NUMBER(10), AnalythicalMethod VARCHAR2(30)");
        this.dropThenCreateRelationalTable(ch, "Lots", "LotID NUMBER(10) PRIMARY KEY NOT NULL, LotLabel VARCHAR2(30), BarCode VARCHAR2(30), VialType VARCHAR2(30), Brutto NUMBER(10), Tara NUMBER(10)");
        this.dropThenCreateRelationalTable(ch, "LotItems", "LotItemID NUMBER(10) PRIMARY KEY NOT NULL, BatchID NUMBER(10) REFERENCES Batches, LotID NUMBER(10) REFERENCES Lots, BatchQuantity NUMBER(10)");
        this.dropThenCreateStructureTable(ch, tautomerDuplicateChecking, "StructuralUnitsTemp", ", PrimaryRegistrationID VARCHAR2(30), PrimaryFlag NUMBER(1), SaltFlag NUMBER(1), SolventFlag NUMBER(1), AuxFlag NUMBER(1), ReagentFlag NUMBER(1), SaltCode VARCHAR2(5), SolventCode VARCHAR2(5), AuxCode VARCHAR2(5), ReagentCode VARCHAR2(5)");
        this.dropThenCreateRelationalTable(ch, "CompoundsTemp", "CD_ID NUMBER(10) PRIMARY KEY NOT NULL, CD_STRUCTURE BLOB");
        this.dropThenCreateRelationalTable(ch, "OriginalStructuresTemp", "CD_ID NUMBER(10) PRIMARY KEY NOT NULL, CD_STRUCTURE BLOB");
        this.dropThenCreateRelationalTable(ch, "ComponentsTemp", "ComponentID NUMBER(10) PRIMARY KEY NOT NULL, CompoundID NUMBER(10) REFERENCES CompoundsTemp, StructuralUnitID NUMBER(10), Type VARCHAR2(1), ComponentType VARCHAR2(10), ComponentQuantity NUMBER(10)");
        this.dropThenCreateRelationalTable(ch, "BatchesTemp", "BatchID NUMBER(10) PRIMARY KEY NOT NULL, CompoundID NUMBER(10), BatchLabel VARCHAR2(30), ProjectID NUMBER(10), ProducerID NUMBER(10), LabNotebookID NUMBER(10), Amount NUMBER(10), Purity NUMBER(10), AnalythicalMethod VARCHAR2(30)");
        this.dropThenCreateRelationalTable(ch, "LotsTemp", "LotID NUMBER(10) PRIMARY KEY NOT NULL, LotLabel VARCHAR2(30), BarCode VARCHAR2(30), VialType VARCHAR2(30), Brutto NUMBER(10), Tara NUMBER(10)");
        this.dropThenCreateRelationalTable(ch, "LotItemsTemp", "LotItemID NUMBER(10) PRIMARY KEY NOT NULL, BatchID NUMBER(10), LotID NUMBER(10) REFERENCES LotsTemp, BatchQuantity NUMBER(10)");
        this.dropThenCreateRelationalTable(ch, "Aliases", "AliasID NUMBER(10) PRIMARY KEY NOT NULL, OriginalStructureID NUMBER(10) REFERENCES OriginalStructures, Alias VARCHAR2(30)");
        this.dropThenCreateRelationalTable(ch, "MixtureItems", "MixtureItemID NUMBER(10) PRIMARY KEY NOT NULL, CompoundRegistrationID VARCHAR2(30), CompoundID NUMBER(10) REFERENCES CompoundsTemp, CompoundPercentage NUMBER(4,2)");
        this.dropThenCreateRelationalTable(ch, "RegistrationIDs", "RegistrationID NUMBER(10) PRIMARY KEY NOT NULL, CorporateRegistrationID VARCHAR2(30), CompoundRegistrationID NUMBER(10) REFERENCES Compounds, BatchID NUMBER(10) REFERENCES Batches, LotID NUMBER(10) REFERENCES Lots");
        this.dropThenCreateRelationalTable(ch, "AttachedFiles", "AttachedFileID NUMBER(10) PRIMARY KEY NOT NULL, RegistrationID NUMBER(10) REFERENCES RegistrationIDs, AttachedFileName VARCHAR2(30), AttachedFileURL VARCHAR2(30), AttachedFile BLOB");
        this.dropThenCreateRelationalTable(ch, "Producers", "ProducerID NUMBER(10) PRIMARY KEY NOT NULL, ProducerName VARCHAR2(30), ProducerType VARCHAR2(30), ProducerLocation VARCHAR2(100), ProducerDetails VARCHAR2(100)");
        this.dropThenCreateRelationalTable(ch, "Plates", "PlateID NUMBER(10) PRIMARY KEY NOT NULL, PlateLabel VARCHAR2(30), PlateType VARCHAR2(30), BarCode VARCHAR2(30)");
        this.dropThenCreateRelationalTable(ch, "PlateItems", "PlateItemID NUMBER(10) PRIMARY KEY NOT NULL, LotID NUMBER(10) REFERENCES Lots, PlateID NUMBER(10) REFERENCES Plates, PlateRow NUMBER(10), PlateColumn NUMBER(10)");
        this.dropThenCreateRelationalTable(ch, "Data", "DataID NUMBER(10) PRIMARY KEY NOT NULL, BatchID NUMBER(10) REFERENCES Batches, DataName VARCHAR2(30), Data VARCHAR2(100)");
        this.dropThenCreateRelationalTable(ch, "RegistrationTask", "ID NUMBER(10) PRIMARY KEY NOT NULL, UserID NUMBER(10), TaskStartTime DATE");
        try {
            ch.getConnection().commit();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
    }

    private void createPropertyTable(ConnectionHandler ch) {
        try {
            if (!DatabaseProperties.propertyTableExists(ch)) {
                DatabaseProperties.createPropertyTable(ch);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void dropThenCreateStructureTable(ConnectionHandler ch, boolean tautomerDuplicateChecking, String tableName, String extraColumnDefinitions) {
        try {
            UpdateHandler.dropStructureTable(ch, tableName);
        }
        catch (SQLException e) {
            // empty catch block
        }
        StructureTableOptions sto = new StructureTableOptions();
        sto.name = tableName;
        sto.extraColumnDefinitions = extraColumnDefinitions;
        sto.structureColumnType = 0;
        sto.tableType = 0;
        sto.standardizerConfig = null;
        sto.fp_numberOfInts = 8;
        sto.tautomerDuplicateChecking = tautomerDuplicateChecking;
        try {
            UpdateHandler.createStructureTable(ch, sto);
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
    }

    private void dropThenCreateRelationalTable(ConnectionHandler ch, String tableName, String columnsOptions) {
        Statement st;
        try {
            st = ch.getConnection().createStatement();
            st.executeUpdate("DROP TABLE " + tableName);
            st = ch.getConnection().createStatement();
            st.executeUpdate("DROP SEQUENCE " + tableName + "_SEQ");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            st = ch.getConnection().createStatement();
            st.executeUpdate("CREATE TABLE " + tableName + "(" + columnsOptions + ")");
            st = ch.getConnection().createStatement();
            st.executeUpdate("CREATE SEQUENCE " + tableName + "_SEQ");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

