/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys.registrar;

import chemaxon.common.util.IntVector;
import chemaxon.formats.MolFormatException;
import chemaxon.jchem.db.PropertyNotSetException;
import chemaxon.jchem.db.UpdateHandler;
import chemaxon.jchem.regsys.RegistrationException;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DatabaseTools;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TemporaryAreaTasks {
    private UpdateHandler insertIntoStructuresHandler = null;
    private UpdateHandler insertIntoCompoundsHandler = null;
    private ConnectionHandler ch;

    public TemporaryAreaTasks(ConnectionHandler conh) {
        this.ch = conh;
    }

    private int[] idsInDatabase(String nameOfID, String tableName, String filter) throws SQLException {
        PreparedStatement st = this.ch.getConnection().prepareStatement("SELECT " + nameOfID + " FROM " + tableName + " " + filter);
        ResultSet rs = st.executeQuery();
        IntVector iv = new IntVector();
        while (rs.next()) {
            iv.add(rs.getInt(1));
        }
        rs.close();
        st.close();
        iv.trimToSize();
        return iv.toArray();
    }

    private void deleteFromTable(String tableName, int ID) throws SQLException {
        Statement st = this.ch.getConnection().createStatement();
        st.execute("DELETE FROM " + tableName + " WHERE CD_ID = " + ID);
    }

    public int[] getIDOfCompounds() throws SQLException {
        return this.idsInDatabase("CD_ID", "CompoundsTemp", "");
    }

    public int[] getIDOfCompoundsOfUser(String username) throws SQLException {
        return this.idsInDatabase("CD_ID", "CompoundsTemp", "");
    }

    public int[] getIDOfCheckedCompounds() throws SQLException {
        return this.idsInDatabase("CD_ID", "CompoundsTemp", "WHERE STATUS <> 'NEW'");
    }

    public int[] getIDOfNewCompounds() throws SQLException {
        return this.idsInDatabase("CD_ID", "CompoundsTemp", "WHERE STATUS = 'NEW'");
    }

    public void removeCompound(int ID) throws SQLException {
        this.deleteFromTable("Compounds", ID);
    }

    public void removeCompounds(int[] ID) throws SQLException {
        if (ID == null || ID.length < 1) {
            return;
        }
        for (int i = 0; i < ID.length; ++i) {
            this.removeCompound(ID[i]);
        }
    }

    public void sendBackCompounds(int[] ID, String status) throws SQLException {
        this.removeCompounds(ID);
    }

    private int[] getTemporaryComponentsID(int cmpdID) throws SQLException {
        return this.idsInDatabase("STRID", "COMPONENTSTEMP", "WHERE CMPDID = " + cmpdID + " AND STRTYPE = 'T'");
    }

    private void updateStructure(String flagName, String codeColumnName, String codeColumnTempValue, String defaultValue, int newID, int oldID, String type) throws SQLException {
        Statement st = this.ch.getConnection().createStatement();
        String newRegID = codeColumnTempValue == null || codeColumnTempValue.length() < 1 ? defaultValue : codeColumnTempValue;
        st.execute("UPDATE Structures SET " + flagName + " = 1, " + codeColumnName + " = '" + newRegID + "' WHERE CD_ID = " + newID);
        st.close();
        this.updateComponents(oldID, newID, " AND ComponentType = '" + type + "'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int registerStructure(int ID, int cmpdID) throws SQLException, PropertyNotSetException, MolFormatException {
        String tempType;
        int i;
        PreparedStatement stTemp = this.ch.getConnection().prepareStatement("SELECT RegistrationID, PrimaryFlag, SaltFlag, SolventFlag, AuxFlag, ReagentFlag, SaltCode, SolventCode, AuxCode, ReagentCode, Name, CD_STRUCTURE, ComponentType FROM StructuresTemp, ComponentsTemp WHERE CD_ID = " + ID + " AND StrID = " + ID + " AND CmpdID = " + cmpdID);
        ResultSet rsTemp = stTemp.executeQuery();
        int lastID = 0;
        if (!rsTemp.next()) throw new SQLException("No such structure");
        if (this.insertIntoStructuresHandler == null) {
            this.insertIntoStructuresHandler = new UpdateHandler(this.ch, 1, "Structures", "RegistrationID, PrimaryFlag, SaltFlag, SolventFlag, AuxFlag, ReagentFlag, SaltCode, SolventCode, AuxCode, ReagentCode, Name");
            this.insertIntoStructuresHandler.setDuplicateFiltering(true);
        }
        this.insertIntoStructuresHandler.setValueForAdditionalColumn(1, "");
        for (i = 2; i <= 5; ++i) {
            this.insertIntoStructuresHandler.setValueForAdditionalColumn(i, "0");
        }
        for (i = 6; i <= 11; ++i) {
            this.insertIntoStructuresHandler.setValueForAdditionalColumn(i, "");
        }
        String s = DatabaseTools.readString(rsTemp, 12);
        this.insertIntoStructuresHandler.setStructure(s);
        lastID = this.insertIntoStructuresHandler.execute(true);
        if (lastID < 0) {
            lastID = -lastID;
        }
        if ((tempType = rsTemp.getString("ComponentType")).equalsIgnoreCase("primary")) {
            this.updateStructure("PrimaryFlag", "RegistrationID", rsTemp.getString("RegistrationID"), "PrimaryFinal", lastID, ID, "Primary");
        } else if (tempType.equalsIgnoreCase("salt")) {
            this.updateStructure("SaltFlag", "SaltCode", rsTemp.getString("SaltCode"), "Saf", lastID, ID, "Salt");
        } else if (tempType.equalsIgnoreCase("solvent")) {
            this.updateStructure("SolventFlag", "SolventCode", rsTemp.getString("SolventCode"), "SoF", lastID, ID, "Solvent");
        }
        PreparedStatement st = this.ch.getConnection().prepareStatement("SELECT RegistrationID, PrimaryFlag, SaltFlag, SolventFlag, AuxFlag, ReagentFlag, SaltCode, SolventCode, AuxCode, ReagentCode, Name, CD_STRUCTURE FROM Structures WHERE CD_ID = " + lastID);
        ResultSet rs = st.executeQuery();
        if (rs.next()) {
            boolean isSaltTemp = rsTemp.getInt("SaltFlag") == 1;
            boolean isSolventTemp = rsTemp.getInt("SolventFlag") == 1;
            boolean isPrimaryTemp = rsTemp.getInt("PrimaryFlag") == 1;
            boolean isSalt = rs.getInt("SaltFlag") == 1;
            boolean isSolvent = rs.getInt("SolventFlag") == 1;
            boolean isPrimary = rs.getInt("PrimaryFlag") == 1;
            rs.close();
            st.close();
            if (isSalt == isSaltTemp && isPrimary == isPrimaryTemp && isSolvent == isSolventTemp) {
                UpdateHandler.deleteRow(this.ch, "StructuresTemp", ID);
            }
        } else {
            rs.close();
            st.close();
            throw new SQLException("Database error");
        }
        rs.close();
        st.close();
        rsTemp.close();
        stTemp.close();
        return lastID;
    }

    private int registerCompound0(int ID) throws SQLException, PropertyNotSetException, MolFormatException {
        PreparedStatement st = this.ch.getConnection().prepareStatement("SELECT DisplayedRegistrationID, UserID, RegistrationTaskID, RegistrationTimestamp, CD_STRUCTURE FROM CompoundsTemp WHERE CD_ID = " + ID);
        ResultSet rs = st.executeQuery();
        int lastID = 0;
        if (rs.next()) {
            if (this.insertIntoCompoundsHandler == null) {
                this.insertIntoCompoundsHandler = new UpdateHandler(this.ch, 1, "Compounds", "DisplayedRegistrationID, UserID, RegistrationTaskID, RegistrationTimestamp, Registrar");
                this.insertIntoCompoundsHandler.setDuplicateFiltering(true);
            }
            for (int i = 1; i <= 4; ++i) {
                Object o = rs.getObject(i);
                this.insertIntoCompoundsHandler.setValueForAdditionalColumn(i, o == null ? null : o.toString());
            }
            this.insertIntoCompoundsHandler.setValueForAdditionalColumn(5, "Registrar");
            String s = DatabaseTools.readString(rs, 5);
            this.insertIntoCompoundsHandler.setStructure(s);
            lastID = this.insertIntoCompoundsHandler.execute(true);
            if (lastID < 0) {
                throw new SQLException("Duplication");
            }
        } else {
            throw new SQLException("No such structure");
        }
        rs.close();
        st.close();
        UpdateHandler.deleteRow(this.ch, "CompoundsTemp", ID);
        return lastID;
    }

    private void updateComponents(int oldStructureID, int newStructureID, String modifier) throws SQLException {
        Statement st = this.ch.getConnection().createStatement();
        st.executeUpdate("UPDATE ComponentsTemp SET (StrID, StrType) = ( SELECT " + newStructureID + ", 'R' FROM DUAL) WHERE StrID = " + oldStructureID + " AND StrType = 'T'" + (modifier == null ? "" : modifier));
        st.close();
    }

    private void mergeComponents(int oldCmpdID, int newCmpdID) throws SQLException {
        Statement st;
        PreparedStatement pst = this.ch.getConnection().prepareStatement("SELECT StrID, ComponentType, ComponentPctg FROM ComponentsTemp WHERE CmpdID = " + oldCmpdID);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            st = this.ch.getConnection().createStatement();
            st.executeUpdate("INSERT INTO Components VALUES(Components_SEQ.NEXTVAL, " + newCmpdID + ", " + rs.getString(1) + ", '" + rs.getString(2) + "', " + rs.getString(3) + ")");
            st.close();
        }
        rs.close();
        pst.close();
        st = this.ch.getConnection().createStatement();
        st.executeUpdate("DELETE FROM ComponentsTemp WHERE CmpdID = " + oldCmpdID);
        st.close();
    }

    public void registerCompound(int ID) throws SQLException, RegistrationException, MolFormatException, PropertyNotSetException {
        int[] structuresToRegister = this.getTemporaryComponentsID(ID);
        if (structuresToRegister != null && structuresToRegister.length >= 1) {
            for (int i = 0; i < structuresToRegister.length; ++i) {
                int newStrID = this.registerStructure(structuresToRegister[i], ID);
                if (newStrID >= 0) continue;
                newStrID = -newStrID;
            }
        }
        int newCmpdID = this.registerCompound0(ID);
        this.mergeComponents(ID, newCmpdID);
    }

    public void registerCompounds(int[] ID) throws SQLException, RegistrationException {
        if (ID == null || ID.length < 1) {
            return;
        }
        for (int i = 0; i < ID.length; ++i) {
            try {
                if (i % 10 == 0) {
                    System.out.println("Ready: " + i);
                }
                this.registerCompound(ID[i]);
                continue;
            }
            catch (PropertyNotSetException e) {
                throw new SQLException("Corrupted properties\n" + e.getMessage());
            }
            catch (MolFormatException e) {
                throw new SQLException("Bad format in database\n:" + e.getMessage());
            }
        }
    }

    public void registerAllNonDuplicateCompounds() throws SQLException, RegistrationException {
        this.registerCompounds(this.idsInDatabase("CD_ID", "CompoundsTemp", "WHERE STATUS <> 'DUPLICATION'"));
    }

    public void setStatus(int ID, String status) throws RegistrationException, SQLException {
        Statement st = this.ch.getConnection().createStatement();
        st.executeUpdate("UPDATE CompoundsTemp SET Status = '" + status + "' WHERE CD_ID = " + ID);
    }
}

