/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.regsys.registration;

import chemaxon.jchem.regsys.RegistrationException;
import chemaxon.jchem.regsys.cmpdreg.CompoundRegistration;
import chemaxon.jchem.regsys.cmpdreg.RegistrationInputRecord;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundRegistered;
import chemaxon.jchem.regsys.cmpdreg.result.CompoundRegistrationResult;

public abstract class RegistrationSystem {
    public CompoundRegistration compoundRegistration = null;

    public void createRegistrationSystem() {
    }

    public void mockRegister(String source) {
        String structure = null;
        Object externalData = null;
        Object internalData = null;
        try {
            this.mockPipeline(structure, externalData, internalData);
        }
        catch (RegistrationException rex) {
            // empty catch block
        }
    }

    public void register(String source) {
        String structure = null;
        Object externalData = null;
        try {
            this.pipeline(structure, externalData);
        }
        catch (RegistrationException rex) {
            // empty catch block
        }
    }

    protected void pipeline(String structure, Object externalData) throws RegistrationException {
        String standardizedStructure = this.standardization(structure);
        this.qualityCheck(standardizedStructure);
        RegistrationInputRecord rir = this.createInputRecord(structure, externalData);
        CompoundRegistrationResult crr = this.compoundRegistration.register(rir);
        if (!(crr instanceof CompoundRegistered)) {
            this.manualRegistration(rir);
        }
    }

    protected void mockPipeline(String structure, Object externalData, Object internalData) throws RegistrationException {
        String standardizedStructure = this.standardization(structure);
        this.qualityCheck(standardizedStructure);
        RegistrationInputRecord rir = this.createInputRecord(structure, externalData, internalData);
        CompoundRegistrationResult crr = this.compoundRegistration.mockRegister(rir);
        if (!(crr instanceof CompoundRegistered)) {
            this.manualRegistration(rir);
        }
    }

    protected abstract boolean qualityCheck(String var1);

    protected abstract String standardization(String var1);

    protected abstract void manualRegistration(RegistrationInputRecord var1);

    protected abstract RegistrationInputRecord createInputRecord(String var1, Object var2);

    protected abstract RegistrationInputRecord createInputRecord(String var1, Object var2, Object var3);

    protected abstract CompoundRegistrationResult[] results();
}

