/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep;

import chemaxon.jep.ChemContext;
import chemaxon.jep.ChemFunction;
import chemaxon.jep.ContextFunction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.nfunk.jep.JEP;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.SymbolTable;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;

public class ChemJEP
extends JEP
implements CallbackIface {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int UNDECIDED = 2;
    private Class contextClass = null;
    private ChemContext context = null;

    public ChemJEP() throws ParseException {
        this(null);
    }

    public ChemJEP(Class contextClass) throws ParseException {
        this.setAllowUndeclared(true);
        if (contextClass != null) {
            this.contextClass = contextClass;
            String[] fnames = null;
            try {
                fnames = ((ChemContext)contextClass.newInstance()).getContextFunctionNames();
            }
            catch (InstantiationException e) {
                throw new ParseException(e);
            }
            catch (IllegalAccessException e) {
                throw new ParseException(e);
            }
            if (fnames != null) {
                for (int i = 0; i < fnames.length; ++i) {
                    this.addFunction(fnames[i], new ContextFunction(fnames[i], this));
                }
            }
        }
    }

    @Override
    public void addFunction(String name, PostfixMathCommandI function) throws ParseException {
        if (this.getFunction(name) != null) {
            throw new ParseException("Function with name '" + name + "' already exists: " + this.getFunction(name).getClass() + "; new function: " + function.getClass() + " cannot be added with the same name.");
        }
        super.addFunction(name, function);
    }

    protected void setSymbolTable(SymbolTable symTab) {
        this.symTab = symTab;
    }

    public void compile(String expression) throws ParseException {
        this.parseExpression(expression);
    }

    @Override
    public Object callback(String method, Object arg) {
        if (this.context == null) {
            return null;
        }
        return this.context.callback(method, arg);
    }

    private void setContext(ChemContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(ChemContext context) throws ParseException {
        this.setContext(context);
        try {
            Object object = this.getValueAsObject();
            return object;
        }
        finally {
            this.setContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double evaluate_double(ChemContext context) throws ParseException {
        this.setContext(context);
        try {
            double d = this.getValue();
            return d;
        }
        finally {
            this.setContext(null);
        }
    }

    public double[] evaluate_doubles(ChemContext context) throws ParseException {
        Object result = this.evaluate(context);
        if (result instanceof double[]) {
            return (double[])result;
        }
        if (result instanceof Number) {
            return new double[]{((Number)result).doubleValue()};
        }
        if (result instanceof Object[]) {
            Object[] r = (Object[])result;
            double[] d = new double[r.length];
            for (int i = 0; i < r.length; ++i) {
                if (!(r[i] instanceof Number)) {
                    throw new ParseException("could not convert to double: " + r[i]);
                }
                d[i] = ((Number)r[i]).doubleValue();
            }
            return d;
        }
        throw new ParseException("could not convert to double[]: " + result);
    }

    public boolean evaluate_boolean(ChemContext context) throws ParseException {
        double result = this.evaluate_double(context);
        if (Double.isNaN(result)) {
            throw new ParseException("Undecided result.");
        }
        return result > 0.5;
    }

    public boolean[] evaluate_booleans(ChemContext context) throws ParseException {
        double[] d = this.evaluate_doubles(context);
        boolean[] b = new boolean[d.length];
        for (int i = 0; i < d.length; ++i) {
            if (Double.isNaN(d[i])) {
                throw new ParseException("Undecided result.");
            }
            b[i] = d[i] > 0.5;
        }
        return b;
    }

    public static int getLogicalValue(Object result) {
        double d;
        if (result == ChemFunction.TRUE) {
            return 1;
        }
        if (result == ChemFunction.FALSE) {
            return 0;
        }
        if (result == ChemFunction.UNDECIDED) {
            return 2;
        }
        if (result instanceof Double && !Double.isNaN(d = ((Double)result).doubleValue())) {
            return d > 0.5 ? 1 : 0;
        }
        return 2;
    }

    public static boolean isUndecided(Object result) {
        return result == ChemFunction.UNDECIDED;
    }
}

