/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep;

import chemaxon.jep.CTFunctionData;
import chemaxon.jep.ChemFunction;
import chemaxon.jep.DissimilarityFunction;
import chemaxon.jep.FingerprintGenerator;
import chemaxon.jep.MatchFunction;
import chemaxon.jep.Standardizer;
import chemaxon.jep.UserParam;
import chemaxon.jep.function.Plugin;
import chemaxon.jep.function.Service;
import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDescriptorReader;
import chemaxon.marvin.services.ServiceDescriptorTools;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.util.SearchAttributes;
import chemaxon.util.XPathUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class EvaluatorConfiguration
implements Serializable {
    public static final String EVALUATOR_CONFIGURATION_TAG = "EvaluatorConfiguration";
    public static final String EVALUATOR_TAG = "Evaluator";
    private String dir = null;
    private Element root = null;
    private Standardizer standardizer = null;
    private transient FingerprintGenerator fingerprintGenerator = null;
    private boolean cached = false;
    private String licenseEnvironment = "";

    EvaluatorConfiguration(InputStream is, String dir, Standardizer standardizer) throws ParseException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            this.root = doc.getDocumentElement();
            if (!this.root.getNodeName().equals(EVALUATOR_CONFIGURATION_TAG) && !this.root.getNodeName().equals(EVALUATOR_TAG)) {
                this.root = null;
            }
            this.dir = dir;
            this.standardizer = standardizer;
            this.setParams();
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
        }
    }

    EvaluatorConfiguration(File file, Standardizer standardizer) throws ParseException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            this.root = doc.getDocumentElement();
            if (!this.root.getNodeName().equals(EVALUATOR_CONFIGURATION_TAG) && !this.root.getNodeName().equals(EVALUATOR_TAG)) {
                this.root = null;
            }
            this.dir = file.getParent();
            this.standardizer = standardizer;
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        this.setParams();
    }

    EvaluatorConfiguration(Element root, String dir, Standardizer standardizer) throws ParseException {
        this.root = root;
        this.dir = dir;
        this.standardizer = standardizer;
        this.setParams();
    }

    EvaluatorConfiguration(String str, String dir, Standardizer standardizer) throws ParseException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(str.getBytes()));
            this.root = doc.getDocumentElement();
            if (!this.root.getNodeName().equals(EVALUATOR_CONFIGURATION_TAG) && !this.root.getNodeName().equals(EVALUATOR_TAG)) {
                this.root = null;
            }
            this.dir = dir;
            this.standardizer = standardizer;
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        this.setParams();
    }

    EvaluatorConfiguration(InputStream is, Standardizer standardizer) throws ParseException {
        this(is, null, standardizer);
    }

    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    private void setParams() throws ParseException {
        Element element;
        NodeList nodeList = XPathUtil.getFirstNodeListFromPath("Params", this.root);
        Element element2 = element = nodeList != null ? (Element)nodeList.item(0) : null;
        if (element != null) {
            this.cached = "true".equalsIgnoreCase(element.getAttribute("Cached"));
        }
    }

    void setFingerprintGenerator(FingerprintGenerator fg) {
        this.fingerprintGenerator = fg;
    }

    boolean isCached() {
        return this.cached;
    }

    final Element getRoot() {
        return this.root;
    }

    Hashtable getVartab() throws ParseException {
        Hashtable vartab = new Hashtable();
        return vartab;
    }

    Hashtable<String, PostfixMathCommandI> getFuntab() throws ParseException {
        Element dissim;
        String cl;
        String id;
        Element element;
        Node node;
        int i;
        Hashtable<String, PostfixMathCommandI> funtab = new Hashtable<String, PostfixMathCommandI>();
        if (this.root == null) {
            return funtab;
        }
        NodeList nodeList = XPathUtil.getFirstNodeListFromPath("Functions/Function", this.root);
        if (nodeList != null) {
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                element = (Element)node;
                if (element.getAttributeNode("ID") == null || element.getAttributeNode("Class") == null) {
                    throw new ParseException("ID and Class attributes are mandatory for Function elements");
                }
                id = element.getAttribute("ID");
                cl = element.getAttribute("Class");
                String[] aliases = this.getTextContentsOfNodes(element, "Alias");
                try {
                    PostfixMathCommandI f = (PostfixMathCommandI)Class.forName(cl).newInstance();
                    if (f instanceof ChemFunction) {
                        ChemFunction chf = (ChemFunction)f;
                        chf.setCached(this.cached);
                        chf.setParameters(EvaluatorConfiguration.createParameterTable(element));
                    }
                    funtab.put(id, f);
                    funtab.put(id.toLowerCase(), f);
                    if (aliases == null) continue;
                    for (String alias : aliases) {
                        funtab.put(alias, f);
                        funtab.put(alias.toLowerCase(), f);
                    }
                    continue;
                }
                catch (ClassCastException e) {
                    throw new ParseException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new ParseException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ParseException(e);
                }
                catch (InstantiationException e) {
                    throw new ParseException(e);
                }
            }
        }
        if ((nodeList = XPathUtil.getFirstNodeListFromPath("Plugins/Plugin", this.root)) != null) {
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                element = (Element)node;
                if (element.getAttributeNode("ID") == null) {
                    throw new ParseException("ID attribute is mandatory for Plugin elements");
                }
                if (element.getAttributeNode("Class") == null && element.getAttributeNode("JAR") == null) {
                    throw new ParseException("Class or JAR attribute is mandatory for Plugin elements");
                }
                id = element.getAttribute("ID");
                cl = element.getAttribute("Class");
                String jar = element.getAttribute("JAR");
                Plugin p = new Plugin(id, cl, jar, EvaluatorConfiguration.createParameterTable(element));
                p.setLicenseEnvironment(this.licenseEnvironment);
                p.setCached(this.cached);
                String[] aliases = this.getTextContentsOfNodes(element, "Alias");
                funtab.put(id, p);
                funtab.put(id.toLowerCase(), p);
                if (aliases == null) continue;
                for (String alias : aliases) {
                    funtab.put(alias, p);
                    funtab.put(alias.toLowerCase(), p);
                }
            }
        }
        nodeList = this.root.getElementsByTagName("Matching");
        for (i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.getAttributeNode("ID") == null || element2.getAttributeNode("Class") == null) {
                throw new ParseException("ID and Class attributes are mandatory for the Matching element");
            }
            String id2 = element2.getAttribute("ID");
            String cl2 = element2.getAttribute("Class");
            int type = 0;
            String typestr = element2.getAttribute("Type");
            if ("count".equalsIgnoreCase(typestr)) {
                type = 1;
            } else if ("disjointcount".equalsIgnoreCase(typestr)) {
                type = 2;
            } else if ("matchfirst".equalsIgnoreCase(typestr)) {
                type = 3;
            }
            SearchAttributes sa = this.getSearchAttributes(element2, "Search");
            MatchFunction mf = new MatchFunction(cl2, type, sa);
            mf.setLicenseEnvironment(this.licenseEnvironment);
            mf.setCached(this.cached);
            mf.setDir(this.dir);
            mf.setStandardizer(this.standardizer);
            mf.setFingerprintGenerator(this.fingerprintGenerator);
            String[] aliases = this.getTextContentsOfNodes(element2, "Alias");
            funtab.put(id2, mf);
            funtab.put(id2.toLowerCase(), mf);
            if (aliases == null) continue;
            for (String alias : aliases) {
                funtab.put(alias, mf);
                funtab.put(alias.toLowerCase(), mf);
            }
        }
        nodeList = this.root.getElementsByTagName("Dissimilarity");
        if (nodeList != null && (dissim = (Element)nodeList.item(0)) != null) {
            if (dissim.getAttributeNode("ID") == null || dissim.getAttributeNode("Class") == null) {
                throw new ParseException("ID and Class attributes are mandatory for the Dissimilarity section");
            }
            String id3 = dissim.getAttribute("ID");
            String cl3 = dissim.getAttribute("Class");
            NodeList descriptorNodeList = XPathUtil.getFirstNodeListFromPath("Descriptors/Descriptor", dissim);
            if (descriptorNodeList.getLength() == 0) {
                throw new ParseException("No descriptors specified for Dissimilarity");
            }
            ArrayList<String> descriptorList = new ArrayList<String>();
            for (int i2 = 0; i2 < descriptorNodeList.getLength(); ++i2) {
                Element element3 = (Element)descriptorNodeList.item(i2);
                if (element3.getAttribute("Name") == null) {
                    throw new ParseException("Name attribute is mandatory for Descriptor elements");
                }
                String name = element3.getAttribute("Name");
                descriptorList.add(name);
            }
            String[] descriptors = new String[descriptorList.size()];
            descriptorList.toArray(descriptors);
            DissimilarityFunction d = new DissimilarityFunction(cl3, descriptors);
            funtab.put(id3, d);
            funtab.put(id3.toLowerCase(), d);
        }
        return funtab;
    }

    Hashtable<String, UserParam[]> getFunctionParameterData() throws ParseException {
        Hashtable<String, UserParam[]> data = new Hashtable<String, UserParam[]>();
        this.getFunctionParameterData(data, "Matching");
        this.getFunctionParameterData(data, "Functions/Function");
        this.getFunctionParameterData(data, "Dissimilarity");
        this.getFunctionParameterData(data, "Plugins");
        return data;
    }

    private void getFunctionParameterData(Hashtable<String, UserParam[]> data, String path) throws ParseException {
        NodeList nodeList = XPathUtil.getFirstNodeListFromPath(path, this.root);
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NodeList plist;
                Element element = (Element)nodeList.item(i);
                String id = element.getAttribute("ID");
                if (id.equals("")) {
                    id = path;
                }
                int size = (plist = element.getElementsByTagName("UserParam")) == null ? 0 : plist.getLength();
                UserParam[] records = new UserParam[size];
                for (int j = 0; j < size; ++j) {
                    Element pelem = (Element)plist.item(j);
                    if (pelem.getAttributeNode("Name") == null) {
                        throw new ParseException("Name attribute is mandatory for the UserParam elements");
                    }
                    if (pelem.getAttributeNode("Type") == null) {
                        throw new ParseException("Type attribute is mandatory for the UserParam elements");
                    }
                    String name = pelem.getAttribute("Name");
                    String type = pelem.getAttribute("Type");
                    boolean mandatory = "true".equalsIgnoreCase(pelem.getAttribute("Mandatory"));
                    boolean multiple = "true".equalsIgnoreCase(pelem.getAttribute("Multiple"));
                    String defval = pelem.getAttribute("Default");
                    records[j] = new UserParam(name, type, mandatory, multiple, defval);
                }
                data.put(id, records);
            }
        }
    }

    Hashtable<String, CTFunctionData> getFunctionData() throws ParseException {
        Hashtable<String, CTFunctionData> data = new Hashtable<String, CTFunctionData>();
        this.fillFunctionData(data, "Functions/Function", CTFunctionData.FUNCTION);
        this.fillFunctionData(data, "Plugins/Plugin", CTFunctionData.PLUGIN_FUNCTION);
        this.fillFunctionData(data, "Matching", CTFunctionData.MATCH_FUNCTION);
        this.fillFunctionData(data, "Dissimilarity", CTFunctionData.DISSIMILARITY_FUNCTION);
        return data;
    }

    private void fillFunctionData(Hashtable<String, CTFunctionData> data, String path, int functionType) throws ParseException {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate(path, this.root, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ParseException(e);
        }
        UserParam[] pluginUserParams = null;
        if (functionType == CTFunctionData.PLUGIN_FUNCTION) {
            try {
                NodeList pluginNodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("Plugins", this.root, XPathConstants.NODESET);
                Element pluginsElement = (Element)pluginNodeList.item(0);
                pluginUserParams = this.getUserParams(pluginsElement, "UserParam");
            }
            catch (XPathExpressionException e) {
                throw new ParseException(e);
            }
        }
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                CTFunctionData functionData = new CTFunctionData();
                functionData.setFunctionType(functionType);
                Element element = (Element)nodeList.item(i);
                String id = element.getAttribute("ID");
                if (id.equals("")) {
                    id = path;
                }
                functionData.setName(id);
                functionData.setReturnType(this.getTextContentOfNode(element, "ReturnType"));
                String[] aliases = this.getTextContentsOfNodes(element, "Alias");
                functionData.setAliases(aliases);
                if (functionType == CTFunctionData.PLUGIN_FUNCTION) {
                    functionData.setUserParams(pluginUserParams);
                } else {
                    functionData.setUserParams(this.getUserParams(element, "UserParam"));
                }
                functionData.setCategories(this.getTextContentsOfNodes(element, "Category"));
                functionData.setDescription(this.getTextContentOfNode(element, "Description"));
                functionData.setReturnValue(this.getTextContentOfNode(element, "ReturnValue"));
                functionData.setParameters(this.getTextContentOfNode(element, "Parameters"));
                functionData.setGeneralExample(this.getTextContentOfNode(element, "GeneralExample"));
                functionData.setMoleculeContextExample(this.getTextContentOfNode(element, "MoleculeContextExample"));
                functionData.setReactionContextExample(this.getTextContentOfNode(element, "ReactionContextExample"));
                functionData.setUsersGuideURL(this.getTextContentOfNode(element, "UsersGuideURL"));
                data.put(id, functionData);
                if (aliases == null) continue;
                for (int j = 0; j < aliases.length; ++j) {
                    data.put(aliases[j], functionData);
                }
            }
        }
    }

    private String getTextContentOfNode(Element element, String nodeName) {
        NodeList nodeList = element.getElementsByTagName(nodeName);
        return nodeList.item(0) != null ? nodeList.item(0).getTextContent() : null;
    }

    private String[] getTextContentsOfNodes(Element element, String nodeName) {
        NodeList nodeList = element.getElementsByTagName(nodeName);
        int size = nodeList == null ? 0 : nodeList.getLength();
        String[] nodeValues = new String[size];
        for (int i = 0; i < size; ++i) {
            nodeValues[i] = nodeList.item(i).getTextContent();
        }
        return nodeValues;
    }

    private UserParam[] getUserParams(Element element, String nodeName) throws ParseException {
        NodeList plist = element.getElementsByTagName(nodeName);
        int size = plist == null ? 0 : plist.getLength();
        UserParam[] userParams = new UserParam[size];
        for (int i = 0; i < size; ++i) {
            Element pelem = (Element)plist.item(i);
            if (pelem.getAttributeNode("Name") == null) {
                throw new ParseException("Name attribute is mandatory for the UserParam elements");
            }
            if (pelem.getAttributeNode("Type") == null) {
                throw new ParseException("Type attribute is mandatory for the UserParam elements");
            }
            String name = pelem.getAttribute("Name");
            String type = pelem.getAttribute("Type");
            boolean mandatory = "true".equalsIgnoreCase(pelem.getAttribute("Mandatory"));
            boolean multiple = "true".equalsIgnoreCase(pelem.getAttribute("Multiple"));
            String defval = pelem.getAttribute("Default");
            userParams[i] = new UserParam(name, type, mandatory, multiple, defval);
        }
        return userParams;
    }

    HashSet<String> getPluginIDs() throws ParseException {
        NodeList nodeList = XPathUtil.getFirstNodeListFromPath("Plugins/Plugin", this.root);
        HashSet<String> ids = new HashSet<String>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttributeNode("ID") == null) {
                    throw new ParseException("ID attribute is mandatory for Plugin elements");
                }
                String id = element.getAttribute("ID");
                ids.add(id);
            }
        }
        return ids;
    }

    private static Properties createParameterTable(Element element) throws ParseException {
        Properties params = new Properties();
        NodeList nodeList = element.getElementsByTagName("Param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element pelement = (Element)nodeList.item(i);
            if (pelement.getAttributeNode("Name") == null || pelement.getAttributeNode("Value") == null) {
                throw new ParseException("Name and Value attributes are mandatory for Param elements");
            }
            String name = pelement.getAttribute("Name");
            String value = pelement.getAttribute("Value");
            params.put(name, value);
        }
        return params;
    }

    static Hashtable<String, PostfixMathCommandI> getServiceFunctions() {
        Hashtable<String, PostfixMathCommandI> funtab = new Hashtable<String, PostfixMathCommandI>();
        Hashtable<String, ServiceDescriptor> services = EvaluatorConfiguration.readServiceConfig();
        for (String functionName : services.keySet()) {
            Service service = new Service(services.get(functionName));
            funtab.put(functionName, service);
            funtab.put(functionName.toLowerCase(), service);
        }
        return funtab;
    }

    private static Hashtable<String, ServiceDescriptor> readServiceConfig() {
        Hashtable<String, ServiceDescriptor> config = new Hashtable<String, ServiceDescriptor>();
        ServiceDescriptorReader serviceReader = ServiceDescriptorTools.getDefaultServiceDescriptorReader();
        if (serviceReader == null) {
            return config;
        }
        InputStream stream = ServiceDescriptorTools.getServiceDescriptorConfigurationAsStream();
        if (stream == null) {
            return config;
        }
        List<ServiceDescriptor> services = serviceReader.readServiceDescriptors(stream);
        for (int i = 0; i < services.size(); ++i) {
            ServiceDescriptor descriptor = services.get(i);
            config.put(descriptor.getName().replaceAll(" ", ""), descriptor);
            if (descriptor.getAlias() == null) continue;
            config.put(descriptor.getAlias().replaceAll(" ", ""), descriptor);
        }
        return config;
    }

    static Hashtable<String, CTFunctionData> getServiceFunctionData() {
        Hashtable<String, CTFunctionData> data = new Hashtable<String, CTFunctionData>();
        Hashtable<String, ServiceDescriptor> services = EvaluatorConfiguration.readServiceConfig();
        for (String serviceName : services.keySet()) {
            CTFunctionData functionData = new CTFunctionData();
            ServiceDescriptor sd = services.get(serviceName);
            functionData.setFunctionType(CTFunctionData.FUNCTION);
            functionData.setName(serviceName);
            functionData.setAliases(new String[]{sd.getAlias()});
            functionData.setCategories(new String[]{"Service"});
            functionData.setDescription(sd.getDescription());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sd.getArgumentCount(); ++i) {
                sb.append(sd.getArgument(i).getName() + " - " + sd.getArgument(i).getType().getName() + "\n");
            }
            functionData.setParameters(sb.toString().trim());
            data.put(serviceName, functionData);
        }
        return data;
    }

    SearchAttributes getSearchAttributes() throws ParseException {
        return this.getSearchAttributes(this.root, "Search");
    }

    private SearchAttributes getSearchAttributes(Element element, String xmlpath) throws ParseException {
        Element elem;
        NodeList nodeList = XPathUtil.getFirstNodeListFromPath(xmlpath, element);
        Element element2 = elem = nodeList != null ? (Element)nodeList.item(0) : null;
        if (elem != null) {
            SearchAttributes sa = new SearchAttributes();
            String v = elem.getAttribute("StereoSearch");
            if ("true".equalsIgnoreCase(v)) {
                sa.setStereoSearch(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setStereoSearch(false);
            }
            v = elem.getAttribute("DoubleBondStereoMatchingMode");
            if ("none".equalsIgnoreCase(v)) {
                sa.setDoubleBondStereoMatchingMode(2);
            } else if ("marked".equalsIgnoreCase(v)) {
                sa.setDoubleBondStereoMatchingMode(1);
            } else if ("all".equalsIgnoreCase(v)) {
                sa.setDoubleBondStereoMatchingMode(0);
            }
            v = elem.getAttribute("SubgraphSearch");
            if ("true".equalsIgnoreCase(v)) {
                sa.setSubgraphSearch(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setSubgraphSearch(false);
            }
            v = elem.getAttribute("ExactAtomMatching");
            if ("true".equalsIgnoreCase(v)) {
                sa.setExactAtomMatching(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setExactAtomMatching(false);
            }
            v = elem.getAttribute("ExactStereoMatching");
            if ("true".equalsIgnoreCase(v)) {
                sa.setExactStereoMatching(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setExactStereoMatching(false);
            }
            v = elem.getAttribute("OrderSensitiveSearch");
            if ("true".equalsIgnoreCase(v)) {
                sa.setOrderSensitiveSearch(true);
            } else if ("false".equalsIgnoreCase(v)) {
                sa.setOrderSensitiveSearch(false);
            }
            return sa;
        }
        return null;
    }
}

