/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep;

import chemaxon.jep.ChemFunction;
import chemaxon.jep.FingerprintGenerator;
import chemaxon.jep.Standardizer;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.util.SearchAttributes;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;

public class MatchFunction
extends ChemFunction {
    public static final int CHECK = 0;
    public static final int COUNT = 1;
    public static final int DISJOINT_COUNT = 2;
    public static final int MATCH_FIRST = 3;
    private transient MatchFunction mf;
    private String className;
    private Hashtable subMatches = null;
    protected int type = 0;
    protected SearchAttributes attributes = null;
    protected String dir = null;
    protected Standardizer standardizer;
    protected transient FingerprintGenerator fingerprintGenerator = null;
    protected String licenseEnvironment = "";

    protected MatchFunction(String cl, int type, SearchAttributes attributes) {
        super(-1);
        this.className = cl;
        this.type = type;
        this.attributes = attributes;
    }

    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    protected void setType(int type) {
        this.type = type;
    }

    protected void setSearchAttributes(SearchAttributes attributes) {
        this.attributes = attributes;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setStandardizer(Standardizer standardizer) {
        this.standardizer = standardizer;
    }

    public void setFingerprintGenerator(FingerprintGenerator fg) {
        this.fingerprintGenerator = fg;
    }

    @Override
    public PostfixMathCommandI getFunction() {
        MatchFunction fun = new MatchFunction(this.className, this.type, this.attributes);
        fun.setJEP(this.getJEP());
        fun.setDir(this.dir);
        fun.setStandardizer(this.standardizer);
        fun.setFingerprintGenerator(this.fingerprintGenerator);
        fun.setLicenseEnvironment(this.licenseEnvironment);
        return fun;
    }

    private MatchFunction newSubClassInstance(String subClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        MatchFunction f = (MatchFunction)Class.forName(subClassName).newInstance();
        f.setJEP(this.getJEP());
        f.setCurNumberOfParameters(this.curNumberOfParameters);
        f.setType(this.type);
        f.setSearchAttributes(this.attributes);
        f.setDir(this.dir);
        f.setStandardizer(this.standardizer);
        f.setFingerprintGenerator(this.fingerprintGenerator);
        f.setLicenseEnvironment(this.licenseEnvironment);
        return f;
    }

    @Override
    public void run(Stack s) throws ParseException {
        try {
            if (this.mf == null) {
                this.mf = this.newSubClassInstance(this.className);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Class not found: " + this.className, e);
        }
        catch (ClassCastException e) {
            throw new ParseException(e);
        }
        catch (IllegalAccessException e) {
            throw new ParseException(e);
        }
        catch (InstantiationException e) {
            throw new ParseException(e);
        }
        int bottom = s.size() - this.curNumberOfParameters;
        for (int i = s.size() - 1; i >= bottom; --i) {
            if (!(s.elementAt(i) instanceof Collection)) continue;
            this.processSubMatches(s, i);
            return;
        }
        this.mf.run(s);
    }

    private void processSubMatches(Stack s, int index) throws ParseException {
        if (this.subMatches == null) {
            this.subMatches = new Hashtable();
        }
        Collection coll = (Collection)s.elementAt(index);
        Object[] params = new Object[this.curNumberOfParameters];
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            params[i] = s.pop();
        }
        double sum = 0.0;
        double indexInCollection = 0.0;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object p = it.next();
            indexInCollection += 1.0;
            Stack ps = new Stack();
            ps.setSize(this.curNumberOfParameters);
            for (int i = 0; i < this.curNumberOfParameters; ++i) {
                ps.push(params[i] == coll ? p : params[i]);
            }
            MatchFunction mf = (MatchFunction)this.subMatches.get(p);
            if (mf == null) {
                mf = (MatchFunction)this.getFunction();
                mf.setCurNumberOfParameters(this.curNumberOfParameters);
                if (p instanceof String) {
                    this.subMatches.put(p, mf);
                }
            }
            mf.run(ps);
            Object result = ps.pop();
            switch (this.type) {
                case 0: {
                    if (result != TRUE && it.hasNext()) break;
                    s.push(result);
                    return;
                }
                case 1: {
                    sum += ((Double)result).doubleValue();
                    break;
                }
                case 3: {
                    if (!(result instanceof Number) || !((Double)result > 0.0)) break;
                    s.push(indexInCollection);
                    return;
                }
            }
        }
        s.push(new Double(sum));
    }
}

