/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.context;

import chemaxon.jep.ChemContext;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class ReactionContext
extends ChemContext {
    public static String[] CFNS = new String[]{"reactant", "product", "ratom", "patom"};
    private Molecule[] reactants = null;
    private Molecule[] products = null;
    private MolAtom[] map2ratom = null;
    private MolAtom[] map2patom = null;
    private boolean copy = false;

    public ReactionContext() {
    }

    public ReactionContext(boolean copy) {
        this.copy = copy;
    }

    @Override
    public String[] getContextFunctionNames() {
        return CFNS;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equalsIgnoreCase("reactant")) {
            int i = ((Number)arg).intValue();
            if (this.reactants[i] == null) {
                return new ParseException("Undefined symbol: reactant(" + i + ")");
            }
            return this.reactants[i];
        }
        if (method.equalsIgnoreCase("product")) {
            int i = ((Number)arg).intValue();
            if (this.products[i] == null) {
                return new ParseException("Undefined symbol: product(" + i + ")");
            }
            return this.products[i];
        }
        if (method.equalsIgnoreCase("ratom")) {
            int m = ((Number)arg).intValue();
            if (this.map2ratom[m] == null) {
                return new ParseException("Undefined symbol: ratom(" + m + ")");
            }
            return this.map2ratom[m];
        }
        if (method.equalsIgnoreCase("patom")) {
            int m = ((Number)arg).intValue();
            if (this.map2patom[m] == null) {
                return new ParseException("Undefined symbol: patom(" + m + ")");
            }
            return this.map2patom[m];
        }
        return null;
    }

    public void setReactants(Molecule[] reactants) {
        this.reactants = reactants;
    }

    public void setProducts(Molecule[] products) {
        this.products = products;
    }

    public void setReactantAtomsByMap(MolAtom[] ma) {
        this.map2ratom = this.copy ? ReactionContext.arraycopy(ma) : ma;
    }

    public void setProductAtomsByMap(MolAtom[] ma) {
        this.map2patom = this.copy ? ReactionContext.arraycopy(ma) : ma;
    }

    private static MolAtom[] arraycopy(MolAtom[] ma) {
        if (ma == null) {
            return null;
        }
        MolAtom[] array = new MolAtom[ma.length];
        System.arraycopy(ma, 0, array, 0, ma.length);
        return array;
    }

    public boolean isEmpty() {
        return this.reactants == null && this.products == null && this.map2ratom == null && this.map2patom == null;
    }

    @Override
    public void clear() {
        this.reactants = null;
        this.products = null;
        this.map2ratom = null;
        this.map2patom = null;
    }
}

