/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.MDParameters;
import chemaxon.descriptors.MolecularDescriptor;
import chemaxon.jep.DissimilarityFunction;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import chemaxon.util.ConfigTools;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;

public class Dissimilarity
extends DissimilarityFunction {
    private transient Hashtable molecularDescriptorTable = null;

    public Dissimilarity() {
        super(null, null);
    }

    @Override
    public void run(Stack s) throws ParseException {
        if (this.curNumberOfParameters > 3) {
            throw new ParseException("More than 3 parameters: " + this.curNumberOfParameters);
        }
        if (this.curNumberOfParameters == 0) {
            throw new ParseException("No parameters.");
        }
        Molecule mol1 = null;
        Molecule mol2 = null;
        MolecularDescriptor[] mds = null;
        int mi = -1;
        Object p = s.pop();
        mol2 = Dissimilarity.getMolecule(p);
        if (this.curNumberOfParameters == 3) {
            p = s.pop();
            mol1 = Dissimilarity.getMolecule(p);
        }
        if (this.curNumberOfParameters >= 2) {
            p = s.pop();
            if (p instanceof String) {
                String key;
                String str = (String)p;
                int k = str.indexOf(":");
                String string = key = k == -1 ? str : str.substring(0, k);
                if (this.molecularDescriptorTable == null) {
                    this.initDescriptors();
                }
                if ((mds = (MolecularDescriptor[])this.molecularDescriptorTable.get(key)) != null) {
                    int n = mi = k == -1 ? mds[0].getDefaultMetricIndex() : mds[0].getMetricIndex(str.substring(k + 1));
                }
            }
            if (mds == null && mol1 == null) {
                mol1 = Dissimilarity.getMolecule(p);
            }
            if (mds == null && mol1 == null) {
                throw new ParseException("Invalid parameter: " + p);
            }
        }
        if (mol1 == null && (mol1 = (Molecule)this.callback("mol", null)) == null) {
            s.push(UNDECIDED);
            return;
        }
        if (mds == null) {
            mds = (MolecularDescriptor[])this.molecularDescriptorTable.get("CF");
            mi = mds[0].getDefaultMetricIndex();
        }
        try {
            mds[0].generate(mol1);
            mds[1].generate(mol2);
        }
        catch (MDGeneratorException e) {
            throw new ParseException(e);
        }
        double dissimilarity = mds[0].getDissimilarity(mds[1], mi);
        s.push(new Double(dissimilarity));
    }

    private static Molecule getMolecule(Object p) throws ParseException {
        if (p instanceof Molecule) {
            return (Molecule)p;
        }
        if (p instanceof String) {
            try {
                return ConfigTools.getTargetMolecule((String)p);
            }
            catch (IOException e) {
                throw new ParseException(e);
            }
        }
        throw new ParseException("Illegal argument: " + p);
    }

    private void initDescriptors() throws ParseException {
        this.molecularDescriptorTable = new Hashtable();
        if (this.descriptors != null) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                String name = this.descriptors[i];
                MolecularDescriptor[] mds = new MolecularDescriptor[]{MolecularDescriptor.newInstance(name), MolecularDescriptor.newInstance(name)};
                try {
                    String paramName = mds[0].getParametersClassName();
                    Class<?> pcl = Class.forName(paramName);
                    MDParameters params = (MDParameters)pcl.newInstance();
                    mds[0].setParameters(params);
                    mds[1].setParameters(params);
                }
                catch (Exception e) {
                    throw new ParseException(e);
                }
                this.molecularDescriptorTable.put(name, mds);
                String cname = Dissimilarity.extractCapitals(name);
                if (cname.length() <= 0) continue;
                this.molecularDescriptorTable.put(cname, mds);
            }
        }
    }

    private static String extractCapitals(String str) {
        StringBuffer buffer = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            buffer.append(c);
        }
        return new String(buffer);
    }
}

