/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.core.calculations.ElementalAnalysisCalc;
import chemaxon.jep.ChemFunction;
import chemaxon.nfunk.jep.ParseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ElementalAnalysis
extends ChemFunction {
    private static final String REGEX_FORMULA = "((((\\[[1-9][0-9]*[A-Z][a-z]\\])|(\\[[1-9][0-9]*[A-Z]\\])|([A-Z][a-z])|([A-Z]))([1-9][0-9]*)*)+)((\\.(((\\[[1-9][0-9]*[A-Z][a-z]\\])|(\\[[1-9][0-9]*[A-Z]\\])|([A-Z][a-z])|([A-Z]))([1-9][0-9]*)*)*)*)";
    private Pattern formulaPattern = null;
    ElementalAnalysisCalc ea = null;

    public ElementalAnalysis() {
        super(-1);
    }

    private void initialize() {
        if (this.formulaPattern == null) {
            this.formulaPattern = Pattern.compile(REGEX_FORMULA);
        }
        if (this.ea == null) {
            this.ea = new ElementalAnalysisCalc();
        }
    }

    private boolean isValidFormula(String formula) {
        Matcher formulaMatcher = this.formulaPattern.matcher(formula);
        return formulaMatcher.matches();
    }

    @Override
    public void run(Stack s) throws ParseException {
        this.initialize();
        String formula = null;
        String function = null;
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            if (p instanceof String) {
                String ps = (String)p;
                if (this.isValidFormula(ps)) {
                    formula = ps;
                    continue;
                }
                function = ps;
                continue;
            }
            throw new ParseException("Illegal argument: " + p);
        }
        if (formula == null) {
            throw new ParseException("Formula parameter is not set.");
        }
        if (function == null) {
            throw new ParseException("Function parameter is not set.");
        }
        this.ea.setMolecule(formula);
        Class<?> c = this.ea.getClass();
        Method m = null;
        try {
            m = c.getMethod(function, null);
        }
        catch (SecurityException e) {
            throw new ParseException("Security exception.", e);
        }
        catch (NoSuchMethodException e) {
            throw new ParseException("Invalid function: " + function, e);
        }
        if (m != null) {
            try {
                s.push(m.invoke((Object)this.ea, (Object[])null));
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Cannot invoke function: " + function, e);
            }
            catch (IllegalAccessException e) {
                throw new ParseException("Cannot invoke function: " + function, e);
            }
            catch (InvocationTargetException e) {
                throw new ParseException("Cannot invoke function: " + function, e);
            }
        }
    }
}

