/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemFunction;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Stack;

public class FormalCharge
extends ChemFunction {
    public FormalCharge() {
        super(-1);
    }

    @Override
    public void run(Stack s) throws ParseException {
        Molecule mol = null;
        int index = -1;
        MolAtom atom = null;
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            if (p instanceof Molecule) {
                mol = (Molecule)p;
                continue;
            }
            if (p instanceof Number) {
                index = FormalCharge.getInt(p);
                continue;
            }
            if (p instanceof MolAtom) {
                atom = (MolAtom)p;
                continue;
            }
            throw new ParseException("Illegal argument: " + p);
        }
        if (mol == null) {
            mol = (Molecule)this.callback("mol", null);
        }
        if (atom == null) {
            Object p;
            if (index == -1 && (p = this.callback("atom", null)) != null) {
                index = FormalCharge.getInt(p);
            }
            if (index == -1) {
                atom = null;
            } else if (mol != null) {
                if (index < 0 || index >= mol.getAtomCount()) {
                    throw new ParseException("No atom with index: " + index);
                }
                atom = mol.getAtom(index);
            }
        }
        if (atom != null) {
            s.push(new Integer(atom.getCharge()));
        } else if (mol != null) {
            s.push(new Integer(mol.getFormalCharge()));
        } else {
            s.push(UNDECIDED);
        }
    }
}

