/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemFunction;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Stack;

public class HasAromatizationError
extends ChemFunction {
    public HasAromatizationError() {
        super(-1);
    }

    @Override
    public void run(Stack s) throws ParseException {
        Molecule mol = null;
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            if (!(p instanceof Molecule)) {
                throw new ParseException("Illegal argument: " + p);
            }
            mol = (Molecule)p;
        }
        if (mol == null && (mol = (Molecule)this.callback("mol", null)) == null) {
            throw new ParseException("No input molecule.");
        }
        Molecule clone = mol.cloneMolecule();
        s.push(new Boolean(HasAromatizationError.hasAromaticBond(clone) && !clone.dearomatize(1)));
    }

    private static boolean hasAromaticBond(Molecule mol) {
        for (MolAtom atom : mol.getAtomArray()) {
            if (!atom.hasAromaticBond()) continue;
            return true;
        }
        return false;
    }
}

