/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.function.AtomEvaluatorFunction;
import chemaxon.nfunk.jep.ParseException;
import java.util.Arrays;

public class MinMaxEvaluator
extends AtomEvaluatorFunction {
    private double sign = 0.0;
    private boolean inds = false;

    public MinMaxEvaluator(double sign, boolean inds) {
        this.sign = sign;
        this.inds = inds;
    }

    @Override
    protected Object evaluate() throws ParseException {
        int i;
        int[] indices;
        double[] values = this.arg != null ? new double[MinMaxEvaluator.getInt(this.arg)] : new double[1];
        Arrays.fill(values, Double.NaN);
        int n = values.length;
        int[] nArray = indices = this.inds ? new int[n] : null;
        if (indices != null) {
            Arrays.fill(indices, -1);
        }
        int size = this.atoms != null ? this.atoms.length : this.target.getAtomCount();
        block0: for (i = 0; i < size; ++i) {
            int atom = this.atoms != null ? this.atoms[i] : i;
            this.innerContext.setAtom(atom);
            double r = this.innerJEP.evaluate_double(this.innerContext);
            if (Double.isNaN(r)) continue;
            r *= this.sign;
            for (int j = 0; j < n; ++j) {
                if (Double.isNaN(values[j])) {
                    values[j] = r;
                    if (indices == null) continue block0;
                    indices[j] = atom;
                    continue block0;
                }
                if (!(r < values[j])) continue;
                for (int k = n - 1; k > j; --k) {
                    values[k] = values[k - 1];
                    if (indices == null) continue;
                    indices[k] = indices[k - 1];
                }
                values[j] = r;
                if (indices == null) continue block0;
                indices[j] = atom;
                continue block0;
            }
        }
        i = 0;
        while (i < n && !Double.isNaN(values[i])) {
            int n2 = i++;
            values[n2] = values[n2] * this.sign;
        }
        if (indices != null) {
            if (n > 1) {
                return indices;
            }
            return new Integer(indices[0]);
        }
        if (n > 1) {
            return values;
        }
        return new Double(values[0]);
    }
}

