/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemFunction;
import chemaxon.jep.ConditionException;
import chemaxon.jep.MolCondition;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import java.util.Stack;

public class MolConditionFunction
extends ChemFunction {
    private String id = null;
    private MolCondition condition = null;

    public MolConditionFunction(String id, MolCondition condition) throws ParseException {
        super(-1);
        this.id = id;
        this.condition = condition;
    }

    @Override
    public void run(Stack s) throws ParseException {
        Molecule mol = null;
        if (this.curNumberOfParameters > 1) {
            throw new ParseException("More than 1 parameters in " + this.id + ": " + this.curNumberOfParameters);
        }
        if (this.curNumberOfParameters == 1) {
            Object p = s.pop();
            if (!(p instanceof Molecule)) {
                throw new ParseException("Parameter is not a molecule object in " + this.id + ": " + p);
            }
            mol = (Molecule)p;
        } else {
            mol = (Molecule)this.callback("mol", null);
        }
        if (mol == null) {
            s.push(UNDECIDED);
            return;
        }
        try {
            boolean result = this.condition.check(mol);
            s.push(result ? TRUE : FALSE);
        }
        catch (ConditionException e) {
            throw new ParseException(e);
        }
    }
}

