/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemFunction;
import chemaxon.jep.function.MoleculeData;
import chemaxon.marvin.calculations.MajorMicrospeciesAccessorPlugin;
import chemaxon.marvin.calculations.MajorMicrospeciesPlugin;
import chemaxon.marvin.calculations.MarkushEnumerationPlugin;
import chemaxon.marvin.calculations.PredictorPlugin;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.calculations.logPPlugin;
import chemaxon.marvin.plugin.CalculatorPlugin;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.util.CxOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;

public class Plugin
extends ChemFunction {
    private static final String lineSep = System.getProperty("line.separator");
    private String id = null;
    private String cl = null;
    private String jar = null;
    private Properties params = null;
    private transient CalculatorPlugin plugin = null;
    private String localParams = null;
    private Properties combinedParams = null;
    private String licenseEnvironment = "";

    public Plugin(String id, String cl, String jar, Properties params) {
        super(-1);
        this.id = id;
        this.cl = cl;
        this.jar = jar;
        this.params = params;
    }

    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(Stack s) throws ParseException {
        Molecule mol = null;
        double pH = Double.NaN;
        String currentParams = "";
        String arg = null;
        String arg0 = null;
        String type = null;
        int index = -1;
        int[] indices = null;
        MolAtom atom = null;
        int n = 0;
        ArrayList list = new ArrayList(this.curNumberOfParameters);
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = s.pop();
            list.add(p);
            if (!(p instanceof Number)) continue;
            ++n;
        }
        if (n > 1) {
            indices = new int[n];
        }
        int t = 0;
        for (int i = this.curNumberOfParameters - 1; i >= 0; --i) {
            Object p = list.get(i);
            if (p == null) {
                s.push(NAN);
                return;
            }
            if (p instanceof String) {
                String str = (String)p;
                try {
                    double d;
                    pH = d = Double.parseDouble(str);
                    arg = str;
                }
                catch (NumberFormatException e) {
                    if (str.indexOf(":") != -1) {
                        currentParams = str;
                        continue;
                    }
                    if (str.indexOf("-") != -1 || str.indexOf(",") != -1) {
                        arg = str;
                        continue;
                    }
                    type = str;
                }
                continue;
            }
            if (p instanceof Number) {
                if (n == 1) {
                    index = Plugin.getInt(p);
                    continue;
                }
                indices[t++] = Plugin.getInt(p);
                continue;
            }
            if (p instanceof int[]) {
                indices = (int[])p;
                continue;
            }
            if (p instanceof Molecule) {
                mol = (Molecule)p;
                continue;
            }
            if (!(p instanceof MolAtom)) throw new ParseException("Illegal argument: " + p);
            atom = (MolAtom)p;
        }
        try {
            if (this.plugin == null) {
                this.plugin = CalculatorPlugin.create(this.cl, this.jar);
            }
            this.plugin.setLicenseEnvironment(this.licenseEnvironment);
            if (!currentParams.equals(this.localParams)) {
                this.combinedParams = Plugin.getCombinedParams(this.params, currentParams);
                this.plugin.setParameters(this.combinedParams);
                this.localParams = currentParams;
            }
        }
        catch (PluginException e) {
            throw new ParseException(e);
        }
        arg0 = arg;
        if (this.combinedParams == null || this.combinedParams.getProperty("ph") == null) {
            if (this.plugin instanceof MajorMicrospeciesAccessorPlugin) {
                ((MajorMicrospeciesAccessorPlugin)this.plugin).setpH(pH);
                arg = null;
            } else if (this.plugin instanceof MajorMicrospeciesPlugin) {
                ((MajorMicrospeciesPlugin)this.plugin).setpH(pH);
                arg = null;
            } else if (this.plugin instanceof TautomerizationPlugin) {
                ((TautomerizationPlugin)this.plugin).setpH(pH);
                arg = null;
            }
        }
        if ((this.combinedParams == null || this.combinedParams.getProperty("trainingid") == null) && this.plugin instanceof PredictorPlugin) {
            try {
                Properties p = new Properties();
                p.put("type", type == null ? arg : type);
                ((PredictorPlugin)this.plugin).setParameters(p);
            }
            catch (PluginException e) {
                throw new ParseException(e);
            }
        }
        if (atom == null) {
            Object p;
            if (indices == null && index == -1 && (p = this.callback("atom", null)) != null) {
                index = Plugin.getInt(p);
            }
            if (mol == null) {
                mol = (Molecule)this.callback("mol", null);
            }
            if (mol == null) {
                s.push(UNDECIDED);
                return;
            }
        } else {
            if (mol == null) {
                mol = (Molecule)atom.getParent();
            }
            index = mol.indexOf(atom);
        }
        boolean atomic = type == null && (this.plugin.getResultDomain() & 1) != 0 || type != null && (this.plugin.getResultDomain(type) & 1) != 0;
        t = index;
        n = index + 1;
        double[] r = null;
        if (arg == null && index == -1) {
            if (indices != null) {
                if (indices.length <= 0) {
                    s.push(new double[0]);
                    return;
                }
                n = indices.length;
                r = new double[n];
                t = 0;
            } else if (atomic) {
                n = mol.getAtomCount();
                r = new double[n];
                t = 0;
            }
        }
        boolean multi = atomic && !this.plugin.handlesMultiFragmentMolecules() && mol.getFragCount() > 1;
        Molecule[] frags = null;
        MolAtom[] atoms = null;
        Molecule frag = null;
        if (multi) {
            atoms = new MolAtom[n];
            Molecule cmol = (Molecule)mol.clone();
            for (int i = 0; i < n; ++i) {
                index = indices != null ? indices[i] : i;
                atoms[i] = cmol.getAtom(index);
            }
            frags = cmol.convertToFrags();
        }
        Object result = null;
        while (true) {
            block58: {
                Data data;
                block61: {
                    MolAtom a;
                    block60: {
                        block55: {
                            block59: {
                                block56: {
                                    long grinvCC;
                                    String pid;
                                    block57: {
                                        if (t >= n) break block55;
                                        index = indices != null ? indices[t] : t;
                                        data = null;
                                        if (!this.isCached()) break block56;
                                        pid = this.getPID(index, arg0, type, currentParams);
                                        data = (Data)mol.getPropertyObject(pid);
                                        grinvCC = mol.getGrinvCC();
                                        if (data == null || data.getGrinvCC() != grinvCC) break block57;
                                        if (r == null) {
                                            s.push(data.getResult());
                                            return;
                                        }
                                        r[t] = Plugin.getDoubleResult(data.getResult());
                                        break block58;
                                    }
                                    data = new Data(grinvCC);
                                    mol.setPropertyObject(pid, data);
                                }
                                if (frags == null || t == -1) break block59;
                                a = atoms[t];
                                break block60;
                            }
                            frag = mol;
                            break block61;
                        }
                        s.push((double[])(r != null ? r : result));
                        return;
                    }
                    for (int i = 0; i < frags.length; ++i) {
                        index = frags[i].indexOf(a);
                        if (index == -1) continue;
                        frag = frags[i];
                        break;
                    }
                }
                String errorMessage = null;
                try {
                    if (type != null && this.plugin instanceof logPPlugin) {
                        ((logPPlugin)this.plugin).setUserTypes(type);
                    }
                    if (this.plugin instanceof MarkushEnumerationPlugin) {
                        if (this.combinedParams == null || this.combinedParams.getProperty("max") == null) {
                            ((MarkushEnumerationPlugin)this.plugin).setMaxStructureCount(index);
                        }
                        index = -1;
                    }
                    this.plugin.checkMolecule(frag);
                    this.plugin.setMolecule(frag);
                    if (!this.plugin.run()) {
                        errorMessage = this.plugin.getErrorMessage() + (mol != null ? " Molecule: " + mol.toFormat("cxsmiles") : "");
                    }
                    if (type == null) {
                        type = (String)this.plugin.getResultTypes()[0];
                    }
                    if (arg == null) {
                        if (index == -1) {
                            index = 0;
                        }
                        result = this.plugin.getResult((Object)type, index);
                        if (r != null) {
                            r[t] = Plugin.getDoubleResult(result);
                        }
                    } else {
                        result = this.plugin.getResult((Object)type, arg);
                    }
                    if (data != null) {
                        data.setResult(result);
                    }
                }
                catch (Exception e) {
                    ParseException parseException;
                    if (errorMessage == null) {
                        parseException = new ParseException(e);
                        throw parseException;
                    }
                    parseException = new ParseException(errorMessage, e);
                    throw parseException;
                }
            }
            ++t;
        }
    }

    private static Properties getCombinedParams(Properties globalParams, String localParamsString) {
        if (localParamsString.length() == 0) {
            return globalParams;
        }
        Properties combinedParams = (Properties)globalParams.clone();
        CxOptions co = new CxOptions(localParamsString);
        Iterator optionNameIt = co.optionNames();
        while (optionNameIt.hasNext()) {
            String name = (String)optionNameIt.next();
            String value = co.getStringValue(name);
            combinedParams.setProperty(name, value);
        }
        return combinedParams;
    }

    private static double getDoubleResult(Object result) throws ParseException {
        if (result instanceof Double) {
            return (Double)result;
        }
        if (result instanceof Integer) {
            return ((Integer)result).intValue();
        }
        throw new ParseException("Invalid plugin result type: " + result.getClass());
    }

    private String getPID(int index, String arg, String type, String currentParams) {
        return this.id + "(" + index + "," + arg + "," + type + "," + currentParams + ")";
    }

    static class Data
    extends MoleculeData {
        private Object result = null;

        public Data(long grinvCC) {
            super(grinvCC);
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

