/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.jep.ChemFunction;
import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.services.ServiceHandler;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;

public class Service
extends ChemFunction {
    private transient ServiceDescriptor descriptor;

    public Service(ServiceDescriptor descriptor) {
        super(-1);
        this.descriptor = descriptor;
    }

    @Override
    public void run(Stack s) throws ParseException {
        ArrayList list = new ArrayList(this.curNumberOfParameters);
        for (int i = 0; i < this.curNumberOfParameters; ++i) {
            list.add(s.pop());
        }
        Collections.reverse(list);
        ServiceHandler<? extends ServiceDescriptor> handler = this.descriptor.getServiceHandler();
        if (this.descriptor.getArgumentCount() > 0 && this.descriptor.getArgumentCount() == list.size() + 1 && this.descriptor.getArgument(0).getType().equals(Molecule.class)) {
            Molecule mol = (Molecule)this.callback("mol", null);
            if (mol == null) {
                throw new ParseException("No input molecule.");
            }
            list.add(0, mol);
        }
        if (this.descriptor.getArgumentCount() != list.size()) {
            throw new ParseException("Wrong number of arguments! Required arguments: " + this.descriptor.getArguments());
        }
        Object result = null;
        try {
            result = handler.callService(this.descriptor, list.toArray());
            s.push(result);
        }
        catch (ServiceException e) {
            throw new ParseException(e);
        }
    }
}

