/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;

public class Sum
extends PostfixMathCommand {
    public Sum() {
        this.numberOfParameters = 1;
        this.curNumberOfParameters = 1;
    }

    @Override
    public void run(Stack s) throws ParseException {
        double sum = this.addAll(s.pop());
        s.push(new Double(sum));
    }

    private double addAll(Object p) throws ParseException {
        double sum = 0.0;
        if (p instanceof double[]) {
            double[] a = (double[])p;
            for (int i = 0; i < a.length; ++i) {
                if (new Double(a[i]).isNaN()) continue;
                sum += a[i];
            }
        } else if (p instanceof int[]) {
            int[] a = (int[])p;
            for (int i = 0; i < a.length; ++i) {
                sum += (double)a[i];
            }
        } else if (p instanceof long[]) {
            long[] a = (long[])p;
            for (int i = 0; i < a.length; ++i) {
                sum += (double)a[i];
            }
        } else if (p instanceof Number) {
            sum += ((Number)p).doubleValue();
        } else if (p instanceof Collection) {
            Collection coll = (Collection)p;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                sum += this.addAll(it.next());
            }
        } else {
            throw new ParseException("Array sum query is not implemented for class: " + p.getClass().getName());
        }
        return sum;
    }
}

