/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jep.util;

import chemaxon.common.util.IntVector;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class SubstitutionUtil {
    private static final char[] delimiters = new char[]{'+', '-', '*', '/', '&', '|', ')', ',', ';', '<', '>', '=', '!', '\"', '\'', '%', '^'};
    private static final char[] leftDelimiters = new char[]{'('};
    private String filterExpression = null;
    private String[] expressions = null;
    private ArrayList selection = null;
    private IntVector usedColumns = null;
    boolean[][] collision = null;
    boolean[] globalCollision = null;
    ArrayList hitsWithCollison = null;

    public void setExpression(String expression) {
        this.filterExpression = expression;
    }

    public void setSubExpressions(String[] expressions) {
        this.expressions = expressions;
    }

    public void evaluate() {
        int colCount = this.expressions.length;
        for (int i = 0; i < colCount; ++i) {
            this.expressions[i] = this.removeWhiteSpace(this.expressions[i]).toLowerCase();
            this.expressions[i] = this.removeSemicolonsAtBothEnds(this.expressions[i]).toLowerCase();
        }
        this.filterExpression = this.removeWhiteSpace(this.filterExpression).toLowerCase();
        ArrayList<int[]> substringIndexes = new ArrayList<int[]>();
        for (int x = 0; x < colCount; ++x) {
            String sub = this.expressions[x];
            int length = sub.length();
            int p = 0;
            int start = 0;
            while ((start = this.filterExpression.indexOf(sub, p)) != -1) {
                char ch;
                p = start + 1;
                int end = start + length - 1;
                if (start != 0 && !SubstitutionUtil.isLeftDelimiter(ch = this.filterExpression.charAt(start - 1)) || end < this.filterExpression.length() - 1 && !SubstitutionUtil.isRightDelimiter(ch = this.filterExpression.charAt(end + 1))) continue;
                substringIndexes.add(new int[]{start, end, x, length});
            }
        }
        this.selection = this.getBestCoverage(substringIndexes);
        IntVector usedCols = new IntVector();
        for (int x = 0; x < this.selection.size(); ++x) {
            int[] hit = (int[])this.selection.get(x);
            int col = hit[2];
            if (usedCols.contains(col)) continue;
            usedCols.add(col);
        }
        usedCols.sort();
        this.usedColumns = usedCols;
    }

    public String getModifiedExpression(String prefix) {
        if (this.selection.size() == 0) {
            return null;
        }
        StringBuffer filter = new StringBuffer(this.filterExpression);
        for (int x = this.selection.size() - 1; x >= 0; --x) {
            int[] hit = (int[])this.selection.get(x);
            int start = hit[0];
            int end = hit[1];
            int colIndex = this.usedColumns.indexOf(hit[2]);
            filter.replace(start, end + 1, "field('" + prefix + colIndex + "')");
        }
        return filter.toString();
    }

    public int[] getUsedColumns() {
        return this.usedColumns.toArray();
    }

    private ArrayList getBestCoverage(ArrayList hits) {
        int count = hits.size();
        this.globalCollision = new boolean[count];
        boolean noCollisionGlobally = true;
        for (int x = 0; x < count - 1; ++x) {
            int[] a = (int[])hits.get(x);
            for (int y = x + 1; y < count; ++y) {
                int[] b = (int[])hits.get(y);
                if (!SubstitutionUtil.hasCommonRange(a, b)) continue;
                noCollisionGlobally = false;
                this.globalCollision[x] = true;
                this.globalCollision[y] = true;
            }
        }
        ArrayList result = new ArrayList();
        if (noCollisionGlobally) {
            result.addAll(hits);
        } else {
            this.hitsWithCollison = new ArrayList();
            for (int x = 0; x < count; ++x) {
                if (!this.globalCollision[x]) {
                    result.add(hits.get(x));
                    continue;
                }
                this.hitsWithCollison.add(hits.get(x));
            }
            result.addAll(this.getBestCoverage());
        }
        result = SubstitutionUtil.orderSelection(result);
        return result;
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        boolean found = false;
        for (int y = 0; y < delimiters.length; ++y) {
            if (delimiters[y] != ch) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean isLeftDelimiter(char ch) {
        return SubstitutionUtil.isDelimiter(ch, delimiters) || SubstitutionUtil.isDelimiter(ch, leftDelimiters);
    }

    private static boolean isRightDelimiter(char ch) {
        return SubstitutionUtil.isDelimiter(ch, delimiters);
    }

    private ArrayList getBestCoverage() {
        int countWithColl = this.hitsWithCollison.size();
        this.collision = new boolean[countWithColl][countWithColl];
        for (int x = 0; x < countWithColl - 1; ++x) {
            int[] a = (int[])this.hitsWithCollison.get(x);
            for (int y = x + 1; y < countWithColl; ++y) {
                int[] b = (int[])this.hitsWithCollison.get(y);
                if (!SubstitutionUtil.hasCommonRange(a, b)) continue;
                this.collision[x][y] = true;
                this.collision[y][x] = true;
            }
        }
        long combinations = 1 << countWithColl;
        boolean[] currentCombination = new boolean[countWithColl];
        boolean[] bestCombination = new boolean[countWithColl];
        int bestCoverage = 0;
        int minColumns = Integer.MAX_VALUE;
        block2: for (long c = combinations - 1L; c >= 0L; --c) {
            int x;
            long c0 = c;
            for (x = 0; x < countWithColl; ++x) {
                currentCombination[x] = (c0 & 1L) != 0L;
                c0 >>>= 1;
            }
            for (x = 0; x < countWithColl - 1; ++x) {
                if (!currentCombination[x]) continue;
                for (int y = x + 1; y < countWithColl; ++y) {
                    if (currentCombination[y] && this.collision[x][y]) continue block2;
                }
            }
            int coverage = 0;
            int columns = 0;
            for (int x2 = 0; x2 < countWithColl; ++x2) {
                if (!currentCombination[x2]) continue;
                int[] hit = (int[])this.hitsWithCollison.get(x2);
                coverage += hit[3];
                ++columns;
            }
            if (coverage <= bestCoverage && (coverage != bestCoverage || columns >= minColumns)) continue;
            bestCoverage = coverage;
            minColumns = columns;
            System.arraycopy(currentCombination, 0, bestCombination, 0, countWithColl);
        }
        ArrayList result = new ArrayList();
        for (int x = 0; x < countWithColl; ++x) {
            if (!bestCombination[x]) continue;
            result.add(this.hitsWithCollison.get(x));
        }
        return result;
    }

    private static ArrayList orderSelection(ArrayList selection) {
        ArrayList result = new ArrayList();
        int size = 0;
        while ((size = selection.size()) > 0) {
            int minIndex = 0;
            int minValue = Integer.MAX_VALUE;
            for (int x = 0; x < size; ++x) {
                int[] hit = (int[])selection.get(x);
                int start = hit[0];
                if (start >= minValue) continue;
                minValue = start;
                minIndex = x;
            }
            result.add(selection.get(minIndex));
            selection.remove(minIndex);
        }
        return result;
    }

    private static boolean hasCommonRange(int[] a, int[] b) {
        int a_begin = a[0];
        int a_end = a[1];
        int b_begin = b[0];
        int b_end = b[1];
        return a_begin <= b_end && b_begin <= a_end;
    }

    private String removeWhiteSpace(String input) {
        StringTokenizer st = new StringTokenizer(input);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
        }
        return sb.toString();
    }

    private String removeSemicolonsAtBothEnds(String input) {
        StringBuffer sb = new StringBuffer(input);
        while (sb.length() > 0 && sb.charAt(0) == ';') {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

