/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class License
implements Cloneable {
    private static final int FIELD_COUNT = 7;
    public static final String ROOT = "ChemAxon";
    public static final String LICENSE_TAG = "License";
    public static final String NOTE = "PLEASE DO NOT MODIFY THIS FILE AND BE AWARE THAT THE FILE CONTAINS CONFIDENTIAL INFORMATION.";
    public static final String SOFTWARE = "Software";
    public static final String LICENSE_TERM = "License Term";
    public static final String LICENSEE = "Licensee";
    public static final String LICENSED_UNIT_COUNT = "Number of Users";
    public static final String EXPIRATION_DATE = "Expiration Date";
    public static final String SUPPORT_EXPIRATION_DATE = "Support Expiration Date";
    public static final String RESTRICTION = "Restriction";
    public static final String SINGLE_BATCH_RESTRICTION = "Single/Batch";
    public static final String BSP_RESTRICTION = "B/S/P";
    public static final String BSPE_RESTRICTION = "B/S/P/E";
    public static final String SEARCH_PER_MIN_RESTRICTION = "Search/Min";
    public static final String PASSWORD_ALLOWED = "Password Allowed";
    public static final String PASSWORD_NOT_ALLOWED = "Password Not Allowed";
    public static final String HELD_CONTENT = "Held Content Only";
    public static final String INTEGRATION_NOT_ALLOWED = "Integration Not Allowed";
    public static final String INTEGRATED = "Integrated With";
    public static final String SERVER_USE = "Server Use";
    public static final String BASIC = "Basic";
    public static final String STANDARD = "Standard";
    public static final String PROFESSIONAL = "Professional";
    public static final String ENTERPRISE = "Enterprise";
    public static final String LICENSE_TERM_ANNUAL = "Annual";
    public static final String LICENSE_TERM_PERPETUAL = "Perpetual";
    public static final String LICENSE_TERM_EVALUATION = "Evaluation";
    public static final String LICENSE_TERM_ACADEMIC_RESEARCH = "Academic Research";
    public static final String LICENSE_TERM_ACADEMIC = "Academic";
    public static final String COMMENT = "Comment";
    public static final String SIGNATURE = "Signature";
    public static final String DEFAULT_LICENSED_UNIT_COUNT = "Unlimited";
    public static final String SEARCH_PER_MIN_UNLIMITED = "Unlimited";
    public static final String NEVER_EXPIRES = "Never";
    public static final String SERVER_USE_ALLOWED = "Allowed";
    public static final String SERVER_USE_NOT_ALLOWED = "Not Allowed";
    public static final String VALIDATION = "Validation";
    public static final String VALID = "Valid";
    public static final String INVALID = "Invalid";
    public static final String EXPIRED = "Expired";
    public static final String ABOUT_TO_EXPIRE = "About to Expire";
    public static final int VALID_ID = 1;
    public static final int INVALID_ID = 2;
    public static final int EXPIRED_ID = 3;
    public static final int ABOUT_TO_EXPIRE_ID = 4;
    private static HashMap<String, Integer> fields = new HashMap();
    private static String[] fieldNames = new String[7];
    private int fieldCount = 7;
    private String[] fieldValues = new String[this.fieldCount];
    private HashMap<String, String> restrictions = new HashMap();
    private String signature = null;
    private int state = 2;
    boolean validated = false;
    long lastStateUpdate = 0L;

    public License clone() throws CloneNotSupportedException {
        License clone = (License)super.clone();
        clone.fieldValues = (String[])this.fieldValues.clone();
        clone.restrictions = (HashMap)this.restrictions.clone();
        return clone;
    }

    public String getLicenseData() {
        ArrayList<String> licenseDataElements = new ArrayList<String>();
        String licenseData = "";
        for (int i = 0; i < this.fieldCount; ++i) {
            if (this.fieldValues[i] == null) continue;
            licenseDataElements.add(fieldNames[i] + "=" + this.fieldValues[i]);
        }
        for (String r : this.restrictions.keySet()) {
            licenseDataElements.add(r + "=" + this.restrictions.get(r));
        }
        Collections.sort(licenseDataElements);
        for (int i = 0; i < licenseDataElements.size(); ++i) {
            licenseData = licenseData + (String)licenseDataElements.get(i) + "\n";
        }
        return licenseData;
    }

    public String toString() {
        String licenseData = "";
        for (int i = 0; i < this.fieldCount; ++i) {
            if (this.fieldValues[i] == null) continue;
            licenseData = licenseData + fieldNames[i] + ": " + this.fieldValues[i] + "\n";
        }
        for (String r : this.restrictions.keySet()) {
            licenseData = licenseData + r + ": " + this.restrictions.get(r) + "\n";
        }
        return licenseData;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setFieldCount(int fieldCount) {
        this.fieldCount = fieldCount;
    }

    public String getFieldName(int i) {
        return fieldNames[i];
    }

    public String getFieldValue(int i) {
        return this.fieldValues[i];
    }

    public String getFieldValue(String name) {
        return this.fieldValues[this.indexOf(name)];
    }

    public void setField(String name, String value) {
        this.fieldValues[this.indexOf((String)name)] = value;
    }

    private int indexOf(String fieldName) {
        return fields.containsKey(fieldName) ? fields.get(fieldName) : -1;
    }

    public String getSoftware() {
        return this.getFieldValue(SOFTWARE);
    }

    public void setSoftware(String software) {
        this.setField(SOFTWARE, software);
    }

    public String getLicenseTerm() {
        return this.getFieldValue(LICENSE_TERM);
    }

    public void setLicenseTerm(String licenseTerm) {
        this.setField(LICENSE_TERM, licenseTerm);
    }

    public String getLicensee() {
        return this.getFieldValue(LICENSEE);
    }

    public void setLicensee(String licensee) {
        this.setField(LICENSEE, licensee);
    }

    public String getLicensedUnitCount() {
        return this.getFieldValue(LICENSED_UNIT_COUNT);
    }

    public void setLicensedUnitCount(String licensedUnitCount) {
        this.setField(LICENSED_UNIT_COUNT, licensedUnitCount);
    }

    public String getExpirationDate() {
        return this.getFieldValue(EXPIRATION_DATE);
    }

    public void setExpirationDate(String expirationDate) {
        this.setField(EXPIRATION_DATE, expirationDate);
    }

    public String getSupportExpirationDate() {
        return this.getFieldValue(SUPPORT_EXPIRATION_DATE);
    }

    public void setSupportExpirationDate(String supportExpirationDate) {
        this.setField(SUPPORT_EXPIRATION_DATE, supportExpirationDate);
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setRestriction(String name, String value) {
        this.restrictions.put(name, value);
    }

    public Set getRestrictionNames() {
        return this.restrictions.keySet();
    }

    public String getRestriction(String rName) {
        return this.restrictions.get(rName);
    }

    public String getRestrictions() {
        String res = "";
        for (String r : this.restrictions.keySet()) {
            res = res + r + ": " + this.restrictions.get(r) + " \n";
        }
        return res;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getStateText() {
        switch (this.state) {
            case 1: {
                return VALID;
            }
            case 3: {
                return EXPIRED;
            }
            case 4: {
                return ABOUT_TO_EXPIRE;
            }
        }
        return INVALID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        if (this.fieldCount != license.fieldCount) {
            return false;
        }
        if (!Arrays.equals(this.fieldValues, license.fieldValues)) {
            return false;
        }
        return !(this.restrictions != null ? !this.restrictions.equals(license.restrictions) : license.restrictions != null);
    }

    public int hashCode() {
        int result = this.fieldCount;
        result = 31 * result + (this.fieldValues != null ? Arrays.hashCode(this.fieldValues) : 0);
        result = 31 * result + (this.restrictions != null ? this.restrictions.hashCode() : 0);
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        result = 31 * result + this.state;
        result = 31 * result + (this.validated ? 1 : 0);
        result = 31 * result + (int)(this.lastStateUpdate ^ this.lastStateUpdate >>> 32);
        return result;
    }

    static {
        fields.put(SOFTWARE, 0);
        fields.put(LICENSE_TERM, 1);
        fields.put(LICENSEE, 2);
        fields.put(LICENSED_UNIT_COUNT, 3);
        fields.put(EXPIRATION_DATE, 4);
        fields.put(SUPPORT_EXPIRATION_DATE, 5);
        fields.put(COMMENT, 6);
        for (String name : fields.keySet()) {
            int idx = fields.get(name);
            License.fieldNames[idx] = name;
        }
    }
}

