/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

import chemaxon.license.License;
import chemaxon.license.LicenseHandler;
import chemaxon.license.LicenseReader;
import chemaxon.license.LicenseStateChecker;
import java.util.HashMap;

public class LicenseConverter {
    static String[] products = new String[]{"Marvin Applets", "Marvin Beans", "Instant JChem", "Instant JChem VIZ", "JChem Base", "JChem Cartridge", "Standardizer", "Screen", "Reactor", "Fragmenter", "JKlustor", "Metabolizer", "Markush Search", "Name to Structure", "Document to Structure", "JChem for Excel", "Calculations Pack", "Web Services Server", "SharePoint", "Structure Checker", "3D Alignment", "3D Screen", "Molecular Descriptors", "ECFP/FCFP", "Registration System"};
    static String[] plugins = new String[]{"Protonation Plugin Group", "Partitioning Plugin Group", "Charge Plugin Group", "Isomers Plugin Group", "Conformation Plugin Group", "3D Alignment", "Geometry Plugin Group", "Huckel Analysis Plugin", "Refractivity Plugin", "HBDA Plugin", "Markush Enumeration Plugin", "Structure to Name Plugin", "Structural Frameworks Plugin", "Predictor Plugin", "Free Plugin"};
    private static HashMap<String, Long> validLicenses;
    private static HashMap<String, HashMap<String, Long>> internalLicenseUsages;
    private static final String REACTOR_CLASS = "chemaxon.reaction.Reactor";
    private static final String CARTRIDGE_CLASS = "chemaxon.jchem.cartridge.servlets.react.InteropReactor";
    private static final String STANDARDIZER_CLASS = "chemaxon.reaction.Standardizer";
    private static final String METABOLIZER_CLASS = "chemaxon.metabolizer.Metabolizer";
    private static final String SKETCH_PANEL_CLASS = "chemaxon.marvin.sketch.swing.SketchPanel";
    private static final String VIEW_PANEL_CLASS = "chemaxon.marvin.view.swing.ViewPanel";
    private static final String SKETCH_CANVAS_CLASS = "chemaxon.marvin.sketch.swing.SketchCanvas";
    private static final String EDIT_MOLFILE_FRAME_CLASS = "chemaxon.marvin.common.swing.modules.EditMolfileFrame";
    private static final String FREE_LOAD_SAVE_CLASS = "chemaxon.marvin.common.swing.modules.FreeLoadSave";
    private static final String DND_HANDLER_CLASS = "chemaxon.marvin.common.swing.DnD";
    private static final String NAME_TO_STRUCTURE_STRUCTURE_CLASS = "chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure";
    private static final String NAME_TO_STRUCTURE_CONVERT_CLASS = "chemaxon.naming.n2s.SystematicNameConverter";
    private static final String MSPACE_PLUGIN_ALIGNMENT_CLASS = "chemaxon.marvin.space.MSpacePluginAlignment";
    private static final String ALIGNMENT_PLUGIN_DISPLAY_CLASS = "chemaxon.marvin.calculations.AlignmentPluginDisplay";
    private static final String ALIGNMENT_PLUGIN_MOLFACTORY_CLASS = "chemaxon.marvin.alignment.AlignmentMoleculeFactory";
    private static final String ALIGNMENT_PLUGIN_GAUSSIAN_CLASS = "chemaxon.marvin.alignment.GaussianSum";
    private static final String RECENT_PIECES_ACTION_CLASS = "chemaxon.marvin.sketch.swing.actions.RecentPiecesAction";
    private static final String LOGP_PLUGIN_CLASS = "chemaxon.marvin.calculations.logPPlugin";
    private static final String MOLECULE_VIEWER_CLASS = "chemaxon.marvin.common.swing.MoleculeViewer";
    private static final String PASTE_ACTION_CLASS = "chemaxon.marvin.swing.action.PasteAction";
    private static final String GRAPHIC_SCENE_CLASS = "chemaxon.marvin.space.GraphicScene";
    private static final String CHECKER_STATUSBAR_CLASS = "chemaxon.marvin.sketch.swing.modules.checker.CheckerStatusbarComponent";
    private static final String BCUT_CLASS = "chemaxon.descriptors.BCUT";
    private static final String PHARMACOFORE_CLASS = "chemaxon.descriptors.PharmacophoreFingerprint";
    private static final String ECFP_CLASS = "chemaxon.descriptors.ECFP";
    private static final String PKAPLUGIN_CLASS = "chemaxon.marvin.calculations.pKaPlugin";
    private static final String MAJORMICROSPECIESPLUGIN_CLASS = "chemaxon.marvin.calculations.MajorMicrospeciesPlugin";
    private static final String MOLALIGNER_CLASS = "chemaxon.util.MolAligner";

    public static synchronized void convert(License lic, HashMap<String, Long> valids, HashMap<String, HashMap<String, Long>> internalUsages) {
        validLicenses = valids;
        internalLicenseUsages = internalUsages;
        String integration = lic.getRestriction("Integrated With");
        String string = integration = integration == null ? "" : integration;
        if (lic.getSoftware().equals("Screen")) {
            LicenseConverter.convertScreenLicense(lic, integration);
        } else if (lic.getSoftware().equals("Reactor")) {
            LicenseConverter.convertReactorLicense(lic, integration);
        } else if (lic.getSoftware().equals("JKlustor")) {
            LicenseConverter.convertJKlustorLicense(lic, integration);
        } else if (lic.getSoftware().equals("Standardizer")) {
            LicenseConverter.convertStandardizerLicense(lic, integration);
        } else if (lic.getSoftware().equals("Fragmenter")) {
            LicenseConverter.convertFragmenterLicense(lic, integration);
        } else if (lic.getSoftware().equals("Metabolizer")) {
            LicenseConverter.convertMetabolizerLicense(lic, integration);
        } else if (lic.getSoftware().equals("JChem Base")) {
            LicenseConverter.convertJChemBaseLicense(lic, integration);
        } else if (lic.getSoftware().equals("JChem Cartridge")) {
            LicenseConverter.convertJChemCartridgeLicense(lic, integration);
        } else if (lic.getSoftware().equals("Structure Search")) {
            LicenseConverter.convertMolsearchLicense(lic, integration);
        } else if (lic.getSoftware().equals("Instant JChem")) {
            LicenseConverter.convertIJCLicense(lic, integration);
        } else if (lic.getSoftware().equals("JChem for Excel")) {
            LicenseConverter.convertJChemForExcelLicense(lic, integration);
        } else if (lic.getSoftware().equals("Markush Search")) {
            LicenseConverter.convertMarkushSearchLicense(lic, integration);
        } else if (lic.getSoftware().equals("Calculations Pack")) {
            LicenseConverter.convertCalculationsPackLicense(lic, integration);
        } else if (lic.getSoftware().equals("SharePoint")) {
            LicenseConverter.convertSharePointLicense(lic, integration);
        } else if (lic.getSoftware().equals("Document to Structure")) {
            LicenseConverter.convertDocumentToStructureLicense(lic, integration);
        } else if (lic.getSoftware().equals("3D Screen")) {
            LicenseConverter.convertScreen3DLicense(lic, integration);
        } else if (lic.getSoftware().equals("ECFP/FCFP")) {
            LicenseConverter.convertECFP_FCFPLicense(lic, integration);
        } else if (lic.getSoftware().equals("Molecular Descriptors")) {
            LicenseConverter.convertMolecularDescriptorLicense(lic, integration);
        } else if (lic.getSoftware().equals("Registration System")) {
            LicenseConverter.convertRegistrationSystemLicense(lic, integration);
        } else {
            LicenseConverter.addTechnicalLicense(lic, lic.getSoftware(), integration);
        }
    }

    static void addBuiltInLicenses(boolean addTestLicenses, HashMap<String, Long> valids, HashMap<String, HashMap<String, Long>> internalUsages) {
        validLicenses = valids;
        internalLicenseUsages = internalUsages;
        LicenseConverter.addCalculatorPlugins(SKETCH_PANEL_CLASS);
        LicenseConverter.addCalculatorPlugins(VIEW_PANEL_CLASS);
        HashMap<String, Long> extraLicenses = internalLicenseUsages.get("Structure to Name Plugin");
        extraLicenses.remove(VIEW_PANEL_CLASS);
        LicenseConverter.addInternalLicenseUsage("Markush Enumeration Plugin", SKETCH_PANEL_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Markush Enumeration Plugin", VIEW_PANEL_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure to Name Plugin", SKETCH_PANEL_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure to Name Plugin", SKETCH_CANVAS_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure to Name Plugin", EDIT_MOLFILE_FRAME_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure to Name Plugin", FREE_LOAD_SAVE_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure to Name Plugin", RECENT_PIECES_ACTION_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure to Name Plugin", ALIGNMENT_PLUGIN_DISPLAY_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure to Name Plugin", MSPACE_PLUGIN_ALIGNMENT_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Name to Structure", SKETCH_PANEL_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Name to Structure", PASTE_ACTION_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Name to Structure", EDIT_MOLFILE_FRAME_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Name to Structure", MOLECULE_VIEWER_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Name to Structure", FREE_LOAD_SAVE_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Name to Structure", DND_HANDLER_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Geometry Plugin Group", NAME_TO_STRUCTURE_STRUCTURE_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Geometry Plugin Group", ALIGNMENT_PLUGIN_MOLFACTORY_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Geometry Plugin Group", ALIGNMENT_PLUGIN_GAUSSIAN_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Isomers Plugin Group", LOGP_PLUGIN_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Charge Plugin Group", GRAPHIC_SCENE_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure Checker", CHECKER_STATUSBAR_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure Checker", STANDARDIZER_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure Checker", STANDARDIZER_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("HBDA Plugin", BCUT_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Charge Plugin Group", BCUT_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Isomers Plugin Group", BCUT_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("HBDA Plugin", PHARMACOFORE_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Protonation Plugin Group", PHARMACOFORE_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Charge Plugin Group", PHARMACOFORE_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Standardizer", PHARMACOFORE_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Isomers Plugin Group", PKAPLUGIN_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Isomers Plugin Group", MAJORMICROSPECIESPLUGIN_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure Checker", NAME_TO_STRUCTURE_CONVERT_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Isomers Plugin Group", "LicenseEnvironmentForFreeIsomersInternalUsage", Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Markush Enumeration Plugin", "FreeMarkushEnumerationForInternalUseLicenseEnvironment", Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("Structure Search", "StructureSearchForInternalMolSearchLicenseEnvironment", Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("3D Alignment", MOLALIGNER_CLASS, Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("3D Alignment", "chemaxon.marvin.space.gui.DockingForMSpace", Long.MAX_VALUE);
        LicenseConverter.addInternalLicenseUsage("3D Alignment", "chemaxon.marvin.space.gui.AlignmentForMSpace", Long.MAX_VALUE);
        if (addTestLicenses) {
            LicenseConverter.addInternalLicenseUsage("Reactor", "chemaxon.license.LicenseEnvironmentAcceptanceTest", Long.MAX_VALUE);
            LicenseConverter.addInternalLicenseUsage("Structure to Name Plugin", "chemaxon.license.NameLicenserTest", Long.MAX_VALUE);
        }
        LicenseConverter.addValidLicense("Free Plugin", Long.MAX_VALUE);
    }

    public static String[] getInternalProductUserClasses() {
        return new String[]{REACTOR_CLASS, CARTRIDGE_CLASS, STANDARDIZER_CLASS, METABOLIZER_CLASS, SKETCH_PANEL_CLASS, SKETCH_CANVAS_CLASS, VIEW_PANEL_CLASS, EDIT_MOLFILE_FRAME_CLASS, FREE_LOAD_SAVE_CLASS, RECENT_PIECES_ACTION_CLASS, ALIGNMENT_PLUGIN_DISPLAY_CLASS, MSPACE_PLUGIN_ALIGNMENT_CLASS, LOGP_PLUGIN_CLASS, MOLECULE_VIEWER_CLASS, PASTE_ACTION_CLASS, GRAPHIC_SCENE_CLASS, CHECKER_STATUSBAR_CLASS};
    }

    private static void addValidLicense(String product, long time) {
        Long oldtime = validLicenses.get(product);
        if (oldtime == null || time > oldtime) {
            validLicenses.put(product, time);
        }
    }

    private static void addInternalLicenseUsage(String product, String environment, long time) {
        Long oldtime;
        HashMap<String, Long> extraLicenses = internalLicenseUsages.get(product);
        if (extraLicenses == null) {
            extraLicenses = new HashMap();
        }
        if ((oldtime = extraLicenses.get(environment)) == null || time > oldtime) {
            extraLicenses.put(environment, time);
            internalLicenseUsages.put(product, extraLicenses);
        }
    }

    private static void addTechnicalLicense(License lic, String product, String environment) {
        long expiration = LicenseStateChecker.setExpirationTime(lic);
        if ("".equals(environment)) {
            LicenseConverter.addValidLicense(product, expiration);
        } else {
            LicenseConverter.addInternalLicenseUsage(product, environment, expiration);
        }
    }

    private static void convertScreen3DLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "3D Screen", env);
        LicenseConverter.addTechnicalLicense(lic, "3D Alignment", env);
    }

    private static void convertScreenLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Screen", env);
        LicenseConverter.addTechnicalLicense(lic, "Optimize Metrics", env);
    }

    private static void convertReactorLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Reactor", env);
        String bsp = lic.getRestriction("B/S/P/E");
        if (bsp == null && (bsp = lic.getRestriction("B/S/P")) == null) {
            bsp = "Professional";
        }
        if (bsp.equals("Professional")) {
            LicenseConverter.addTechnicalLicense(lic, "Synthesizer", env);
            long expiration = LicenseStateChecker.setExpirationTime(lic);
            LicenseConverter.addInternalLicenseUsage("Standardizer", REACTOR_CLASS, expiration);
            LicenseConverter.addInternalLicenseUsage("Structure Search", REACTOR_CLASS, expiration);
            LicenseConverter.addInternalLicenseUsage("Reactor", CARTRIDGE_CLASS, expiration);
            LicenseConverter.addCalculatorPlugins(lic, REACTOR_CLASS, null);
            if (LicenseHandler.getInstance().addTestLicenses) {
                LicenseConverter.addInternalLicenseUsage("Reactor", "chemaxon.license.util.CartridgeStub", Long.MAX_VALUE);
                LicenseConverter.addInternalLicenseUsage("Structure Search", "chemaxon.license.util.ReactorStub", Long.MAX_VALUE);
            }
        }
    }

    private static void convertJKlustorLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "JKlustor", env);
        LicenseConverter.addTechnicalLicense(lic, "Molecular Descriptors", env);
        String bsp = lic.getRestriction("B/S/P/E");
        if (bsp == null) {
            bsp = lic.getRestriction("B/S/P");
        }
        if (bsp != null && bsp.equals("Standard")) {
            LicenseConverter.addTechnicalLicense(lic, "Pharmacophore Recognition", env);
            LicenseConverter.addTechnicalLicense(lic, "Library MCS", env);
            LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
        }
    }

    private static void convertStandardizerLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Standardizer", env);
        LicenseConverter.addInternalLicenseUsage("Isomers Plugin Group", STANDARDIZER_CLASS, LicenseStateChecker.setExpirationTime(lic));
        String bsp = lic.getRestriction("B/S/P/E");
    }

    private static void convertFragmenterLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Fragmenter", env);
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
    }

    private static void convertMolsearchLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
        LicenseConverter.addTechnicalLicense(lic, "MCES", env);
    }

    private static void convertJChemBaseLicense(License lic, String env) {
        LicenseReader.getInstance().setJChemSearchPerMin(lic.getRestriction("Search/Min"));
        LicenseConverter.addTechnicalLicense(lic, lic.getSoftware(), env);
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
        LicenseConverter.addTechnicalLicense(lic, "MCES", env);
    }

    private static void convertRegistrationSystemLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Registration System", env);
        LicenseConverter.addTechnicalLicense(lic, "JChem Base", env);
    }

    private static void convertJChemCartridgeLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "JChem Cartridge", env);
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
        LicenseConverter.addTechnicalLicense(lic, "MCES", env);
    }

    private static void convertJChemForExcelLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "JChem for Excel", env);
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
        LicenseConverter.addTechnicalLicense(lic, "JChem Base", "JChemForExcelLicenseEnvironment");
    }

    private static void convertIJCLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Instant JChem", env);
        LicenseConverter.addTechnicalLicense(lic, "JChem Base", "InstantJChemLicenseEnvironment");
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
        String bsp = lic.getRestriction("B/S/P/E");
        LicenseConverter.addTechnicalLicense(lic, "MCES", env);
    }

    private static void convertMarkushSearchLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Markush Search", env);
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
    }

    private static void convertCalculationsPackLicense(License lic, String env) {
        LicenseHandler.getInstance().allowIJCRegistration = true;
        LicenseConverter.addTechnicalLicense(lic, "Calculations Pack", env);
        LicenseConverter.addTechnicalLicense(lic, "Standardizer", "InstantJChemLicenseEnvironment");
        LicenseConverter.addTechnicalLicense(lic, "Standardizer", "JChemForExcelLicenseEnvironment");
        LicenseConverter.addCalculatorPlugins(lic, "InstantJChemLicenseEnvironment", "Conformation Plugin Group");
        LicenseConverter.addCalculatorPlugins(lic, "JChemForExcelLicenseEnvironment", null);
    }

    private static void convertECFP_FCFPLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "ECFP/FCFP", env);
        LicenseConverter.addCalculatorPlugins(lic, ECFP_CLASS, null);
    }

    private static void convertMolecularDescriptorLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Molecular Descriptors", env);
        LicenseConverter.addTechnicalLicense(lic, "Pharmacophore Recognition", env);
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
    }

    private static void convertMetabolizerLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Metabolizer", env);
        long expiration = LicenseStateChecker.setExpirationTime(lic);
        LicenseConverter.addInternalLicenseUsage("Standardizer", METABOLIZER_CLASS, expiration);
        LicenseConverter.addInternalLicenseUsage("Structure Search", METABOLIZER_CLASS, expiration);
        LicenseConverter.addInternalLicenseUsage("Reactor", METABOLIZER_CLASS, expiration);
        LicenseConverter.addCalculatorPlugins(lic, METABOLIZER_CLASS, null);
        if (LicenseHandler.getInstance().addTestLicenses) {
            LicenseConverter.addTechnicalLicense(lic, "Reactor", "chemaxon.license.util.MetabolizerStub");
            LicenseConverter.addTechnicalLicense(lic, "Charge Plugin Group", "chemaxon.license.util.MetabolizerStub");
        }
    }

    private static void convertSharePointLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "SharePoint", env);
        LicenseConverter.addTechnicalLicense(lic, "JChem Base", env);
        LicenseConverter.addTechnicalLicense(lic, "Structure Search", env);
    }

    private static void convertDocumentToStructureLicense(License lic, String env) {
        LicenseConverter.addTechnicalLicense(lic, "Document to Structure", env);
        LicenseConverter.addTechnicalLicense(lic, "Name to Structure", env);
    }

    private static void addCalculatorPlugins(License lic, String env, String exception) {
        for (int i = 0; i < plugins.length; ++i) {
            if (exception != null && plugins[i].equals(exception)) continue;
            LicenseConverter.addTechnicalLicense(lic, plugins[i], env);
        }
    }

    private static void addCalculatorPlugins(String environment) {
        for (int i = 0; i < plugins.length; ++i) {
            LicenseConverter.addInternalLicenseUsage(plugins[i], environment, Long.MAX_VALUE);
        }
    }
}

