/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.license;

public class LicenseExceptionHandler {
    static final String LICENSE_FILE_NOT_FOUND = "No license file found";
    static final String LICENSES_ARE_EXPIRED = "License is expired";
    static final String LICENSE_PROBLEM = "No valid license has been found";
    static final String EVALUATION_ONLY = "The product will run in Evaluation Mode.";
    static final String LICENSE_CONTACT = "Please contact sales@chemaxon.com to obtain the corresponding license.\nStudents and academic researchers are entitled of free use\nthrough our Academic Package, for more information\nplease visit: http://www.chemaxon.com/acpack_conditions.html";
    static final String LICENSE_CONTACT_HTML = "Please contact <a href=\"mailto:sales@chemaxon.com\">sales@chemaxon.com</a> to obtain the corresponding license.<br>\nStudents and academic researchers are entitled of free use through our Academic Package, for more information\nplease visit: <a href=\"http://www.chemaxon.com/acpack_conditions.html\">http://www.chemaxon.com/acpack_conditions.html</a>\n";
    static final String LICENSE_EVAL_CONTACT_HTML = "To disable this dialog please contact <a href=\"mailto:sales@chemaxon.com\">sales@chemaxon.com</a> to obtain the corresponding license.<br>\nStudents and academic researchers are entitled of free use through our Academic Package, for more information\nplease visit: <a href=\"http://www.chemaxon.com/acpack_conditions.html\">http://www.chemaxon.com/acpack_conditions.html</a>\n";
    private String lastReadLicensePath = "";
    private boolean licenseEverRead = false;
    private boolean licenseExpired = false;

    protected LicenseExceptionHandler() {
    }

    public static LicenseExceptionHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void setLicensePath(String path) {
        this.lastReadLicensePath = path;
    }

    public void setLicenseRead(boolean read) {
        this.licenseEverRead = read;
    }

    public String generateMessage(String product) {
        return this.getProblemMessage() + ".\n" + "Product name: " + product + "\n" + this.generateLicensePathMessage() + LICENSE_CONTACT;
    }

    public void setLicenseExpired(boolean b) {
        this.licenseExpired = b;
    }

    public String getProblemMessage() {
        if (!this.licenseEverRead) {
            return LICENSE_FILE_NOT_FOUND;
        }
        if (this.licenseExpired) {
            return LICENSES_ARE_EXPIRED;
        }
        return LICENSE_PROBLEM;
    }

    private String generateLicensePathMessage() {
        return "License path: " + this.lastReadLicensePath + "\n";
    }

    public String getLicenseExceptionMessage() {
        return "No valid license has been found.\nPlease contact sales@chemaxon.com to obtain the corresponding license.\nStudents and academic researchers are entitled of free use\nthrough our Academic Package, for more information\nplease visit: http://www.chemaxon.com/acpack_conditions.html";
    }

    public String getLicenseExceptionMessage(String product) {
        return "No valid license has been found for " + product + ".\n" + LICENSE_CONTACT;
    }

    private static class SingletonHolder {
        private static final LicenseExceptionHandler INSTANCE = new LicenseExceptionHandler();

        private SingletonHolder() {
        }
    }
}

